/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.Property;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class PointGeomEditor
extends guiPanel
implements IGeomEditor<Point> {
    private static final long serialVersionUID = 1621134734853455553L;
    private Point3DPanel d_locPanel;

    public PointGeomEditor() {
        this.setLayout(new GridBagLayout());
        GridBagHelper gb = new GridBagHelper(this);
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        this.d_locPanel.addToPanel(gb);
        gb.finalizeRows();
        this.load(Property.of(new Point(new Point3d(0.0, 0.0, 0.0))));
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = GeomGuiUtil.getDataVals(geoms, new LocProp(), 3, Geometry.LU);
        this.d_locPanel.setX(loc[0]);
        this.d_locPanel.setY(loc[1]);
        this.d_locPanel.setZ(loc[2]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        GeomGuiUtil.setDataVals(geoms, new LocProp(), Geometry.LU, loc);
    }

    public void load(Property<Point> p) {
        this.d_locPanel.load(p.map(point -> new UnitPoint3D(point.loc, Geometry.LU)).orElse(null));
    }

    public Property<Point> save() {
        UnitPoint3D p3d = this.d_locPanel.save();
        return Property.ofNullable(p3d).map(up -> new Point(up.getPoint3dValue(Geometry.LU)));
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<Point> {
        private LocProp() {
        }

        @Override
        protected Point constructGeom(Point arg0, double[] data) {
            return new Point(new Point3d(data));
        }

        @Override
        protected double[] saveData(Point geom) {
            double[] vals = new double[3];
            geom.loc.get(vals);
            return vals;
        }
    }
}

