/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class FreePointGeomEditor
extends guiPanel
implements IGeomEditor<FreePointGeom> {
    private static final long serialVersionUID = 7556093351826105101L;
    private Point3DPanel d_locPanel;
    private ValueField<UnitDouble> d_rotation;
    private ValueField<Double> d_xOrien;
    private ValueField<Double> d_yOrien;
    private ValueField<Double> d_zOrien;

    public FreePointGeomEditor() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        guiLabel orientationLab = new guiLabel(Intl.intl("Orientation"));
        guiLabel rotationLab = new guiLabel(Intl.intl("Rotation") + ":");
        this.d_rotation = ValueFields.udFld(UnitSystem.getSource(29));
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        guiLabel xOrienLab = new guiLabel(Intl.intl("X:"));
        guiLabel yOrienLab = new guiLabel(Intl.intl("Y:"));
        guiLabel zOrienLab = new guiLabel(Intl.intl("Z:"));
        this.d_xOrien = ValueFields.doubleFld();
        this.d_yOrien = ValueFields.doubleFld();
        this.d_zOrien = ValueFields.doubleFld();
        this.d_locPanel.addToPanel(this, 0, row++);
        GridBagUtil.add(this, orientationLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, xOrienLab, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_xOrien, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, yOrienLab, 3, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_yOrien, 4, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, zOrienLab, 5, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_zOrien, 6, row++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, rotationLab, 0, row, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotation, 2, row, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        this.load(new FreePointLoc());
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = GeomGuiUtil.getDataVals(geoms, new LocProp(), 3, Geometry.LU);
        Double[] orient = GeomGuiUtil.getDoubleDataVals(geoms, new OrientProp(), 3);
        Object rot = PropertyUtil.getProperty(new RotProp(), geoms);
        if (!(rot instanceof UnitDouble)) {
            rot = null;
        }
        this.d_locPanel.setX(loc[0]);
        this.d_locPanel.setY(loc[1]);
        this.d_locPanel.setZ(loc[2]);
        this.d_xOrien.setValue(orient[0]);
        this.d_yOrien.setValue(orient[1]);
        this.d_zOrien.setValue(orient[2]);
        this.d_rotation.setValue((UnitDouble)rot);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        Double[] orient = new Double[]{(Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue()};
        UnitDouble rot = (UnitDouble)this.d_rotation.getValue();
        GeomGuiUtil.setDataVals(geoms, new LocProp(), Geometry.LU, loc);
        GeomGuiUtil.setDoubleDataVals(geoms, new OrientProp(), orient);
        PropertyUtil.setProperty(new RotProp(), rot, geoms);
    }

    public void load(FreePointLoc fpl) {
        assert (fpl.d_geom instanceof Point);
        this.d_locPanel.load(new UnitPoint3D(((Point)fpl.d_geom).loc, Geometry.LU));
        this.d_xOrien.setValue(fpl.d_orientation.x);
        this.d_yOrien.setValue(fpl.d_orientation.y);
        this.d_zOrien.setValue(fpl.d_orientation.z);
        this.d_rotation.setValue(fpl.d_rotation);
    }

    public FreePointLoc getFreePointLoc() {
        UnitPoint3D p3d = this.d_locPanel.save();
        Vector3d v3d = new Vector3d((Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue());
        return new FreePointLoc(new Point(p3d.getPoint3dValue(Geometry.LU)), v3d, (UnitDouble)this.d_rotation.getValue());
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<FreePointGeom> {
        private LocProp() {
        }

        @Override
        protected FreePointGeom constructGeom(FreePointGeom arg0, double[] data) {
            FreePointLoc loc = new FreePointLoc(new Point(new Point3d(data[0], data[1], data[2])), arg0.loc.d_orientation, arg0.loc.d_rotation);
            return new FreePointGeom(loc);
        }

        @Override
        protected double[] saveData(FreePointGeom geom) {
            FreePointLoc loc = geom.loc;
            assert (loc.d_geom instanceof Point);
            Point3d p3d = ((Point)geom.loc.d_geom).loc;
            return new double[]{p3d.x, p3d.y, p3d.z};
        }
    }

    private static class OrientProp
    extends GeomGuiUtil.AGeomProp<FreePointGeom> {
        private OrientProp() {
        }

        @Override
        protected FreePointGeom constructGeom(FreePointGeom arg0, double[] data) {
            FreePointLoc loc = new FreePointLoc(arg0.loc.d_geom, new Vector3d(data[0], data[1], data[2]), arg0.loc.d_rotation);
            return new FreePointGeom(loc);
        }

        @Override
        protected double[] saveData(FreePointGeom geom) {
            FreePointLoc loc = geom.loc;
            double[] vals = new double[3];
            loc.d_orientation.get(vals);
            return vals;
        }
    }

    private static class RotProp
    extends PropertyUtil.AProp<IPyroGeomSrc, UnitDouble> {
        public RotProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        public Object get(IPyroGeomSrc obj) {
            return ((FreePointGeom)obj.getGeom().getLocalGeom()).loc.d_rotation;
        }

        @Override
        public void set(IPyroGeomSrc obj, UnitDouble prop) {
            FreePointGeom old = (FreePointGeom)obj.getGeom().getLocalGeom();
            FreePointLoc newLoc = new FreePointLoc(old.loc.d_geom, old.loc.d_orientation, prop);
            obj.setGeom(GeomNodeUtil.newNode(new FreePointGeom(newLoc)));
        }
    }
}

