/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class AttachedPointGeomEditor
extends guiPanel
implements IGeomEditor<AttachedPointGeom> {
    private static final long serialVersionUID = -7397906603675436194L;
    private Point3DPanel d_locPanel;
    private ValueField<UnitDouble> d_rotation;
    private ValueField<Double> d_xOrien;
    private ValueField<Double> d_yOrien;
    private ValueField<Double> d_zOrien;

    public AttachedPointGeomEditor() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        guiLabel orientationLab = new guiLabel(Intl.intl("Normal of Solid"));
        guiLabel rotationLab = new guiLabel(Intl.intl("Rotation") + ":");
        this.d_rotation = ValueFields.udFld(UnitSystem.getSource(29));
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        guiLabel xOrienLab = new guiLabel(Intl.intl("X") + ":");
        guiLabel yOrienLab = new guiLabel(Intl.intl("Y") + ":");
        guiLabel zOrienLab = new guiLabel(Intl.intl("Z") + ":");
        this.d_xOrien = ValueFields.doubleFld();
        this.d_yOrien = ValueFields.doubleFld();
        this.d_zOrien = ValueFields.doubleFld();
        this.d_locPanel.addToPanel(this, 0, row++);
        GridBagUtil.add(this, orientationLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, xOrienLab, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_xOrien, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, yOrienLab, 3, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_yOrien, 4, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, zOrienLab, 5, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_zOrien, 6, row++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, rotationLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotation, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.load(new AttachedPointLoc());
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = GeomGuiUtil.getDataVals(geoms, new LocProp(), 3, Geometry.LU);
        Double[] orient = GeomGuiUtil.getDoubleDataVals(geoms, new OrientProp(), 3);
        Object rot = PropertyUtil.getProperty(new RotProp(), geoms);
        if (!(rot instanceof UnitDouble)) {
            rot = null;
        }
        this.d_locPanel.setX(loc[0]);
        this.d_locPanel.setY(loc[1]);
        this.d_locPanel.setZ(loc[2]);
        this.d_xOrien.setValue(orient[0]);
        this.d_yOrien.setValue(orient[1]);
        this.d_zOrien.setValue(orient[2]);
        this.d_rotation.setValue((UnitDouble)rot);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] loc = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        Double[] orient = new Double[]{(Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue()};
        UnitDouble rot = (UnitDouble)this.d_rotation.getValue();
        GeomGuiUtil.setDataVals(geoms, new LocProp(), Geometry.LU, loc);
        GeomGuiUtil.setDoubleDataVals(geoms, new OrientProp(), orient);
        PropertyUtil.setProperty(new RotProp(), rot, geoms);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return true;
    }

    public void load(AttachedPointLoc fpl) {
        this.d_locPanel.load(fpl.d_location);
        this.d_xOrien.setValue(fpl.d_faceNormal.x);
        this.d_yOrien.setValue(fpl.d_faceNormal.y);
        this.d_zOrien.setValue(fpl.d_faceNormal.z);
        this.d_rotation.setValue(fpl.d_rotation);
    }

    public AttachedPointLoc getAttachedPointLoc() {
        UnitPoint3D p3d = this.d_locPanel.save();
        Vector3d v3d = new Vector3d((Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue());
        return new AttachedPointLoc(p3d, v3d, (UnitDouble)this.d_rotation.getValue());
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<AttachedPointGeom> {
        private LocProp() {
        }

        @Override
        protected AttachedPointGeom constructGeom(AttachedPointGeom arg0, double[] data) {
            AttachedPointLoc loc = new AttachedPointLoc(new UnitPoint3D(data[0], data[1], data[2], Geometry.LU), arg0.loc.d_faceNormal, arg0.loc.d_rotation);
            return new AttachedPointGeom(loc);
        }

        @Override
        protected double[] saveData(AttachedPointGeom geom) {
            Unit lu = Geometry.LU;
            AttachedPointLoc loc = geom.loc;
            return new double[]{loc.d_location.x(lu), loc.d_location.y(lu), loc.d_location.z(lu)};
        }
    }

    private static class OrientProp
    extends GeomGuiUtil.AGeomProp<AttachedPointGeom> {
        private OrientProp() {
        }

        @Override
        protected AttachedPointGeom constructGeom(AttachedPointGeom arg0, double[] data) {
            AttachedPointLoc loc = new AttachedPointLoc(arg0.loc.d_location, new Vector3d(data[0], data[1], data[2]), arg0.loc.d_rotation);
            return new AttachedPointGeom(loc);
        }

        @Override
        protected double[] saveData(AttachedPointGeom geom) {
            AttachedPointLoc loc = geom.loc;
            double[] vals = new double[3];
            loc.d_faceNormal.get(vals);
            return vals;
        }
    }

    private static class RotProp
    extends PropertyUtil.AProp<IPyroGeomSrc, UnitDouble> {
        public RotProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        public Object get(IPyroGeomSrc obj) {
            return ((AttachedPointGeom)obj.getGeom().getLocalGeom()).loc.d_rotation;
        }

        @Override
        public void set(IPyroGeomSrc obj, UnitDouble prop) {
            AttachedPointGeom old = (AttachedPointGeom)obj.getGeom().getLocalGeom();
            AttachedPointLoc newLoc = new AttachedPointLoc(old.loc.d_location, old.loc.d_faceNormal, prop);
            obj.setGeom(GeomNodeUtil.newNode(new AttachedPointGeom(newLoc)));
        }
    }
}

