/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Objects;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class AARectangleEditor
extends guiPanel
implements IGeomEditor<AARectangle> {
    private static final long serialVersionUID = -196090020161127760L;
    public static final String FACE_NAME = Intl.intl("Face");
    public static final int X_PLANE = 0;
    public static final int Y_PLANE = 1;
    public static final int Z_PLANE = 2;
    public static final int NO_PLANE = 3;
    private guiComboBox<String> d_planeCombo;
    private ValueField<UnitDouble> d_planeLoc;
    private AABoxGeomEditor d_boxGeomEditor;
    private final GeomGuiUtil.AGeomProp rectProp = new GeomGuiUtil.AGeomProp<AARectangle>(this){

        @Override
        protected double[] saveData(AARectangle geom) {
            return new double[]{geom.d_plane, geom.d_planeVal, geom.d_minx, geom.d_miny, geom.d_maxx, geom.d_maxy};
        }

        @Override
        protected AARectangle constructGeom(AARectangle baseGeom, double[] data) {
            return new AARectangle((byte)data[0], data[1], data[2], data[3], data[4], data[5], baseGeom.flipped);
        }
    };

    public AARectangleEditor(boolean emptyAllowed) {
        this.setLayout(new GridBagLayout());
        this.d_boxGeomEditor = new AABoxGeomEditor(emptyAllowed, true);
        guiLabel planeLab = new guiLabel(Intl.intl("Plane"));
        this.d_planeCombo = new guiComboBox<Object>((T[])new Object[]{" X ", " Y ", " Z "});
        this.d_planeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                int index = AARectangleEditor.this.d_planeCombo.getSelectedIndex();
                if (index == 0) {
                    AARectangleEditor.this.selectPlane(0);
                } else if (index == 1) {
                    AARectangleEditor.this.selectPlane(1);
                } else if (index == 2) {
                    AARectangleEditor.this.selectPlane(2);
                } else {
                    AARectangleEditor.this.selectPlane(3);
                }
            }
        });
        guiLabel equalsLab = new guiLabel("=");
        this.d_planeLoc = AARectangleEditor.newField(emptyAllowed, 0.0, SI.METER);
        guiPanel holdPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(holdPanel, planeLab, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(holdPanel, this.d_planeCombo, 1, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(holdPanel, equalsLab, 2, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(holdPanel, this.d_planeLoc, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, holdPanel, 0, 0, 6, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        TitleSeparator path = new TitleSeparator(Intl.intl("Bounds"));
        guiPanel boxPanel = this.d_boxGeomEditor.getPanel();
        GridBagUtil.add(this, path, 0, 1, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, boxPanel, 0, 2, 6, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.addGlue(this);
        this.setMinimumSize(this.getPreferredSize());
        this.selectPlane(0);
    }

    private static ValueField<UnitDouble> newField(boolean emptyAllowed, double initVal, Unit srcUnit) {
        ValueField<UnitDouble> field = ValueFields.udFld(new UnitDouble(initVal, srcUnit), UnitSystem.getSource(0));
        field.setColumns(8);
        field.setNullAllowed(emptyAllowed);
        return field;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Rectangle");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    public guiComboBox<String> getPlaneCB() {
        return this.d_planeCombo;
    }

    public AABoxGeomEditor getBoxGeomEditor() {
        return this.d_boxGeomEditor;
    }

    public UnitDouble getArea() {
        ValueField[] min = this.d_boxGeomEditor.getMinFields();
        ValueField[] max = this.d_boxGeomEditor.getMaxFields();
        int plane = this.d_planeCombo.getSelectedIndex();
        UnitDouble minB = null;
        UnitDouble minA = null;
        UnitDouble maxB = null;
        UnitDouble maxA = null;
        switch (plane) {
            case 0: {
                minA = (UnitDouble)min[1].getValue();
                minB = (UnitDouble)min[2].getValue();
                maxA = (UnitDouble)max[1].getValue();
                maxB = (UnitDouble)max[2].getValue();
                break;
            }
            case 1: {
                minA = (UnitDouble)min[0].getValue();
                minB = (UnitDouble)min[2].getValue();
                maxA = (UnitDouble)max[0].getValue();
                maxB = (UnitDouble)max[2].getValue();
                break;
            }
            case 2: {
                minA = (UnitDouble)min[0].getValue();
                minB = (UnitDouble)min[1].getValue();
                maxA = (UnitDouble)max[0].getValue();
                maxB = (UnitDouble)max[1].getValue();
            }
        }
        return AARectangleEditor.calculateArea(minA, minB, maxA, maxB);
    }

    private static UnitDouble calculateArea(UnitDouble minA, UnitDouble minB, UnitDouble maxA, UnitDouble maxB) {
        if (Objects.isNull(minA) || Objects.isNull(minB) || Objects.isNull(maxA) || Objects.isNull(maxB)) {
            return null;
        }
        UnitDouble a = maxA.sub(minA);
        UnitDouble b = maxB.sub(minB);
        return a.multiply(b);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (enable) {
            this.selectPlane(this.d_planeCombo.getSelectedIndex());
        }
    }

    public void selectPlane(int plane) {
        int m;
        ValueField[] min = this.d_boxGeomEditor.getMinFields();
        ValueField[] max = this.d_boxGeomEditor.getMaxFields();
        for (m = 0; m < min.length; ++m) {
            min[m].setEnabled(false);
        }
        for (m = 0; m < max.length; ++m) {
            max[m].setEnabled(false);
        }
        switch (plane) {
            case 0: {
                min[1].setEnabled(true);
                max[1].setEnabled(true);
                min[2].setEnabled(true);
                max[2].setEnabled(true);
                break;
            }
            case 1: {
                min[0].setEnabled(true);
                max[0].setEnabled(true);
                min[2].setEnabled(true);
                max[2].setEnabled(true);
                break;
            }
            case 2: {
                min[0].setEnabled(true);
                max[0].setEnabled(true);
                min[1].setEnabled(true);
                max[1].setEnabled(true);
            }
        }
        this.revalidate();
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> objs, boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        int selPlane = this.d_planeCombo.getSelectedIndex();
        boolean checkX = selPlane == 1 || selPlane == 2;
        boolean checkY = selPlane == 0 || selPlane == 2;
        boolean checkZ = selPlane == 0 || selPlane == 1;
        ValueField[] min = this.d_boxGeomEditor.getMinFields();
        ValueField[] max = this.d_boxGeomEditor.getMaxFields();
        if (checkX && !GeomGuiUtil.validateMinMax(this.getParent(), min[0], max[0], Intl.intl("Min X"), Intl.intl("Max X"), false, this.rectProp, 2, 4, objs, showWarn, allowModify)) {
            return false;
        }
        if (checkY) {
            int ix;
            int n = ix = selPlane == 0 ? 2 : 3;
            if (!GeomGuiUtil.validateMinMax(this.getParent(), min[1], max[1], Intl.intl("Min Y"), Intl.intl("Max Y"), false, this.rectProp, ix, ix + 2, objs, showWarn, allowModify)) {
                return false;
            }
        }
        return !checkZ || GeomGuiUtil.validateMinMax(this.getParent(), min[2], max[2], Intl.intl("Min Z"), Intl.intl("Max Z"), false, this.rectProp, 3, 5, objs, showWarn, allowModify);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] data = GeomGuiUtil.getDataVals(geoms, this.rectProp, 6, Geometry.LU);
        if (data[0] == null) {
            this.d_planeCombo.setSelectedItem(null);
            this.d_planeLoc.setValue(null);
            this.d_boxGeomEditor.load((AABoxGeom)null);
        } else {
            byte planeb = (byte)data[0].getValueNoUnit();
            this.d_planeLoc.setValue(data[1]);
            ValueField[] min = this.d_boxGeomEditor.getMinFields();
            ValueField[] max = this.d_boxGeomEditor.getMaxFields();
            switch (planeb) {
                case 0: {
                    this.d_planeCombo.setSelectedIndex(0);
                    this.selectPlane(0);
                    min[1].setValue(data[2]);
                    min[2].setValue(data[3]);
                    max[1].setValue(data[4]);
                    max[2].setValue(data[5]);
                    break;
                }
                case 1: {
                    this.d_planeCombo.setSelectedIndex(1);
                    this.selectPlane(1);
                    min[0].setValue(data[2]);
                    min[2].setValue(data[3]);
                    max[0].setValue(data[4]);
                    max[2].setValue(data[5]);
                    break;
                }
                case 2: {
                    this.d_planeCombo.setSelectedIndex(2);
                    this.selectPlane(2);
                    min[0].setValue(data[2]);
                    min[1].setValue(data[3]);
                    max[0].setValue(data[4]);
                    max[1].setValue(data[5]);
                }
            }
        }
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        ValueField maxy;
        ValueField maxx;
        ValueField miny;
        ValueField minx;
        String planeStr = this.d_planeCombo.getSelectedItem();
        if (planeStr == null) {
            return;
        }
        ValueField[] min = this.d_boxGeomEditor.getMinFields();
        ValueField[] max = this.d_boxGeomEditor.getMaxFields();
        int plane = this.d_planeCombo.getSelectedIndex();
        switch (plane) {
            case 0: {
                plane = 0;
                minx = min[1];
                miny = min[2];
                maxx = max[1];
                maxy = max[2];
                break;
            }
            case 1: {
                plane = 1;
                minx = min[0];
                miny = min[2];
                maxx = max[0];
                maxy = max[2];
                break;
            }
            case 2: {
                plane = 2;
                minx = min[0];
                miny = min[1];
                maxx = max[0];
                maxy = max[1];
                break;
            }
            default: {
                assert (false);
                maxy = null;
                maxx = null;
                miny = null;
                minx = null;
            }
        }
        GeomGuiUtil.setDataVals(geoms, this.rectProp, Geometry.LU, new UnitDouble(plane, Geometry.LU), (UnitDouble)this.d_planeLoc.getValue(), (UnitDouble)minx.getValue(), (UnitDouble)miny.getValue(), (UnitDouble)maxx.getValue(), (UnitDouble)maxy.getValue());
    }

    public void load(AARectangle rec) {
        this.d_planeLoc.setValue(new UnitDouble(rec.d_planeVal, Geometry.LU));
        AABoxGeom tempGeom = new AABoxGeom(rec.getBoundingBox(new AABox()));
        this.d_boxGeomEditor.load(tempGeom);
        if (rec.d_plane == 0) {
            this.d_planeCombo.setSelectedIndex(0);
        } else if (rec.d_plane == 1) {
            this.d_planeCombo.setSelectedIndex(1);
        } else {
            this.d_planeCombo.setSelectedIndex(2);
        }
    }

    public AARectangle saveData() {
        int selPlane = this.d_planeCombo.getSelectedIndex();
        boolean saveX = selPlane == 1 || selPlane == 2;
        boolean saveY = selPlane == 0 || selPlane == 2;
        boolean saveZ = selPlane == 0 || selPlane == 1;
        AABoxGeom tempBox = this.d_boxGeomEditor.save();
        Point3d min = tempBox.min;
        Point3d max = tempBox.max;
        double planeVal = ((UnitDouble)this.d_planeLoc.getValue()).getValue(Geometry.LU);
        if (saveX && saveY) {
            return new AARectangle(2, planeVal, min.x, min.y, max.x, max.y, false);
        }
        if (saveY && saveZ) {
            return new AARectangle(0, planeVal, min.y, min.z, max.y, max.z, false);
        }
        return new AARectangle(1, planeVal, min.x, min.z, max.x, max.z, false);
    }

    public UnitAABox getBoundingBox() {
        ValueField[] min = this.d_boxGeomEditor.getMinFields();
        if (min == null) {
            return null;
        }
        ValueField[] max = this.d_boxGeomEditor.getMaxFields();
        if (max == null) {
            return null;
        }
        int plane = this.d_planeCombo.getSelectedIndex();
        if (plane < 0 || 2 < plane) {
            return null;
        }
        UnitDouble planeLoc = (UnitDouble)this.d_planeLoc.getValue();
        if (planeLoc == null) {
            return null;
        }
        try {
            switch (plane) {
                case 0: {
                    return new UnitAABox(new UnitPoint3D(planeLoc, (UnitDouble)min[1].getValue(), (UnitDouble)min[2].getValue()), new UnitPoint3D(planeLoc, (UnitDouble)max[1].getValue(), (UnitDouble)max[2].getValue()));
                }
                case 1: {
                    return new UnitAABox(new UnitPoint3D((UnitDouble)min[0].getValue(), planeLoc, (UnitDouble)min[2].getValue()), new UnitPoint3D((UnitDouble)max[0].getValue(), planeLoc, (UnitDouble)max[2].getValue()));
                }
                case 2: {
                    return new UnitAABox(new UnitPoint3D((UnitDouble)min[0].getValue(), (UnitDouble)min[1].getValue(), planeLoc), new UnitPoint3D((UnitDouble)max[0].getValue(), (UnitDouble)max[1].getValue(), planeLoc));
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

