/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ModelImage;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.floorview.EditBGImageAction;
import pyrosim.gui.floorview.NewFloorDlg;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.table.PopupTableCell;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class ManageFloorsDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final PyroMod d_mod;
    private final EditBGImageAction d_editBgImageAction;
    private final guiTable d_table;

    public ManageFloorsDlg(JFrame owner, PyroMod mediator, EditBGImageAction imageEditor) {
        super((Window)owner, Intl.intl("Manage Floors"), 9);
        this.d_mod = mediator;
        this.d_editBgImageAction = imageEditor;
        this.d_editBgImageAction.acquire();
        UnitSystem us = PyroSim.getApp().getUnitSystem();
        FloorManager floors = this.d_mod.getFloorManager();
        FloorTableModel model = new FloorTableModel(((APyroObject)floors).flatten(Floor.class));
        ColorCell colorCellRenderEdit = new ColorCell(this);
        BgImageCell bgImageCellRenderEdit = new BgImageCell(this, this.d_editBgImageAction);
        this.d_table = new guiTable((TableModel)model, 31);
        this.d_table.setSortOrder(0);
        this.d_table.setDefaultRenderer(ModelImage.class, bgImageCellRenderEdit);
        this.d_table.setDefaultEditor(ModelImage.class, bgImageCellRenderEdit);
        this.d_table.setDefaultEditor(UnitDouble.class, new guiTable.UnitDoubleEditor(us.getLengthUnit()));
        this.d_table.setDefaultRenderer(UnitDouble.class, new guiTable.UnitDoubleRenderer(us.getLengthUnit()));
        this.d_table.setDefaultRenderer(Color.class, colorCellRenderEdit);
        this.d_table.setDefaultEditor(Color.class, colorCellRenderEdit);
        this.d_table.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new NameCellRenderer());
        guiTableEditor tableEditor = new guiTableEditor(this.d_table, 22);
        NewFloorAction newFloorAction = new NewFloorAction(this, model);
        JButton newFloorButton = new JButton(newFloorAction);
        this.d_table.autoSizeColumns(false, 200, (col, val) -> {
            int unitPx = 85;
            if (col == 0) {
                return Math.max(val, 110);
            }
            if (col == 5) {
                return Math.max(val, 195);
            }
            return Math.max(val, 85);
        });
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(newFloorButton, 0);
        gb.addRow(tableEditor);
        gb.addRow(Intl.intl("Clip Color and Background Image are optional."));
        gb.addRow(Intl.intl("Double-click to edit values. Select and press Delete to remove."));
        gb.finalizeRows();
        this.setDisposeAfterModal(false);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
    }

    @Override
    public void dispose() {
        this.d_editBgImageAction.release();
        super.dispose();
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result != 1) {
            this.dispose();
        }
        return result;
    }

    public void save() {
        FloorTableModel model = (FloorTableModel)this.d_table.getModel();
        FloorManager floorManager = this.d_mod.getFloorManager();
        ArrayList<Floor> previous = new ArrayList<Floor>(((APyroObject)floorManager).flatten(Floor.class));
        List altered = model.getRows().stream().map(FloorRow::getFloor).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        List added = model.getRows().stream().filter(r -> r.getFloor() == null).map(FloorRow::toFloor).collect(Collectors.toUnmodifiableList());
        List deleted = previous.stream().filter(Predicate.not(altered::contains)).collect(Collectors.toUnmodifiableList());
        CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(this.d_mod);
        Task a = Actions.getDeleteTask(this.d_mod, deleted);
        if (a == null && !deleted.isEmpty()) {
            return;
        }
        AddTask b = new AddTask((IPyroObject)floorManager, added);
        AUndoableTask c = ManageFloorsDlg.editTask(model);
        task.addTask(a);
        task.addTask(b);
        task.addTask(c);
        this.d_mod.getTaskManager().exec(task, Intl.intl("Manage Floors"));
    }

    private static AUndoableTask editTask(FloorTableModel model) {
        final BiConsumer<Floor, Floor> updater = (of, nf) -> {
            if (of == null || nf == null) {
                return;
            }
            of.setName(nf.getName());
            of.setElevation(nf.getElevation());
            of.setSlabThickness(nf.getSlabThickness());
            of.setWallHeight(nf.getWallHeight());
            of.setBgImage(nf.getBgImage());
            of.setClipColor(nf.getClipColor());
        };
        final LinkedIdentityHashMap undo = new LinkedIdentityHashMap();
        final List alteredRows = model.getRows().stream().filter(r -> r.getFloor() != null).collect(Collectors.toUnmodifiableList());
        return new AUndoableTask(){

            @Override
            public void undo() {
                for (FloorRow row : alteredRows) {
                    Floor of = row.getFloor();
                    Floor uf = (Floor)undo.get(of);
                    updater.accept(of, uf);
                }
            }

            @Override
            public void run() {
                undo.clear();
                for (FloorRow row : alteredRows) {
                    Floor of = row.getFloor();
                    Floor nf = row.toFloor();
                    undo.put(of, of.clone());
                    updater.accept(of, nf);
                }
            }
        };
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        TableModel model = this.d_table.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (Column column : Column.values()) {
                if (column.nullable || model.getValueAt(row, column.ordinal()) != null) continue;
                if (column == Column.CLIP_COLOR) {
                    this.d_table.setValueAt(Floor.DEFAULT_COLOR, row, column.ordinal());
                    continue;
                }
                if (showWarn) {
                    int viewRow = this.d_table.convertRowIndexToView(row) + 1;
                    String msg = String.format(Intl.intl("Error on row %d: %s must not be empty."), viewRow, column.header);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        IntFunction<String> getName = r -> {
            UnitDouble elevation = (UnitDouble)model.getValueAt(r, Column.ELEVATION.ordinal());
            String baseName = (String)model.getValueAt(r, Column.NAME.ordinal());
            if (elevation == null) {
                return baseName;
            }
            return TVEntryPoints.FloorEP.getName(baseName, elevation);
        };
        for (int rowA = 0; rowA < model.getRowCount(); ++rowA) {
            String rowAName = getName.apply(rowA);
            for (int rowB = rowA + 1; rowB < model.getRowCount(); ++rowB) {
                String rowBName = getName.apply(rowB);
                if (!rowAName.equals(rowBName)) continue;
                if (showWarn) {
                    int viewRowA = this.d_table.convertRowIndexToView(rowA) + 1;
                    int viewRowB = this.d_table.convertRowIndexToView(rowB) + 1;
                    String msg = String.format(Intl.intl("Error on rows %d and %d: each floor must have a unique name."), viewRowA, viewRowB);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        for (int row = 0; row < model.getRowCount(); ++row) {
            UnitDouble slabThickness = (UnitDouble)model.getValueAt(row, Column.SLAB_THICKNESS.ordinal());
            UnitDouble wallHeight = (UnitDouble)model.getValueAt(row, Column.WALL_HEIGHT.ordinal());
            if (!(slabThickness.getValueNoUnit() < 0.0) && !(wallHeight.getValueNoUnit() < 0.0)) continue;
            if (showWarn) {
                int viewRow = this.d_table.convertRowIndexToView(row) + 1;
                String msg = String.format(Intl.intl("Error on row %d: Slab Thickness and Wall Height must be >= 0."), viewRow);
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
            }
            return false;
        }
        return true;
    }

    private static class FloorTableModel
    extends AbstractTableModel
    implements ResizableTableModel {
        private static final long serialVersionUID = 1L;
        private final List<FloorRow> d_rows;

        public FloorTableModel(Collection<Floor> floors) {
            this.d_rows = floors.stream().map(FloorRow::new).collect(Collectors.toCollection(ArrayList::new));
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return Objects.requireNonNull(Column.fromOrdinal((int)column)).type;
        }

        @Override
        public String getColumnName(int column) {
            return Objects.requireNonNull(Column.fromOrdinal((int)column)).header;
        }

        @Override
        public int getRowCount() {
            return this.d_rows.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        public List<FloorRow> getRows() {
            return this.d_rows;
        }

        public FloorRow getRow(int rowIndex) {
            return this.d_rows.get(rowIndex);
        }

        public void addRow(FloorRow row) {
            this.d_rows.add(row);
            int size = this.d_rows.size();
            this.fireTableRowsInserted(size, size);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getRow(rowIndex).getValue(columnIndex);
        }

        @Override
        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.d_rows.size()) {
                FloorRow row = new FloorRow(new Object[Column.values().length]);
                row.setValue(columnIndex, newValue);
                this.addRow(row);
            } else {
                FloorRow row = this.getRow(rowIndex);
                row.setValue(columnIndex, newValue);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void removeRow(int index) {
            this.d_rows.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        @Override
        public void insertRow(int index, Object[] row) {
            this.d_rows.add(index, new FloorRow(row));
            this.fireTableRowsInserted(index, index);
        }

        @Override
        public int getMaxRows() {
            return Integer.MAX_VALUE;
        }
    }

    private static class ColorCell
    extends PopupTableCell<Color> {
        private static final long serialVersionUID = 1L;
        private Color d_cachedIconColor = null;
        private Icon d_cachedIcon = null;

        public ColorCell(Window owner) {
            super(current -> {
                SimpleColorChooser dlg = new SimpleColorChooser(owner, Intl.intl("Color"), 1);
                if (current != null) {
                    dlg.setColor((Color)current);
                }
                return dlg.doModal() == 1 ? dlg.getColor() : null;
            }, current -> ColorCell.colorToString(current));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            assert (comp instanceof JLabel);
            if (comp instanceof JLabel) {
                int fontAscent = comp.getFontMetrics(comp.getFont()).getAscent();
                Icon colorIcon = this.getColorIcon((Color)value, fontAscent - 1);
                ((JLabel)comp).setIcon(colorIcon);
            }
            return comp;
        }

        private Icon getColorIcon(Color value, int size) {
            if (!Objects.equals(this.d_cachedIconColor, value)) {
                this.d_cachedIconColor = value;
                this.d_cachedIcon = new ColorIcon(this.d_cachedIconColor, size, size, 3);
            }
            return this.d_cachedIcon;
        }

        private static String colorToString(Color c) {
            if (c == null) {
                return "";
            }
            return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    private static class BgImageCell
    extends PopupTableCell<ModelImage> {
        private static final long serialVersionUID = 1L;

        public BgImageCell(Window owner, EditBGImageAction imageEditor) {
            super((T current) -> {
                Floor tmp = new Floor("");
                return imageEditor.editFloor(tmp) ? tmp.getBgImage() : null;
            }, (T current) -> {
                if (current != null && current.getImage() != null && current.getImage().getFilename() != null) {
                    String fn = current.getImage().getFilename();
                    return FilenameUtils.getName(fn);
                }
                return null;
            });
        }
    }

    private static enum Column {
        NAME(Intl.intl("Name"), String.class, NamedPyroObject::getName, (f, v) -> f.setName(v == null ? "" : v), true),
        ELEVATION(Intl.intl("Elevation"), UnitDouble.class, f -> f.getElevation(), (f, v) -> f.setElevation((UnitDouble)v), false),
        SLAB_THICKNESS(Intl.intl("Slab Thickness"), UnitDouble.class, f -> f.getSlabThickness(), (f, v) -> f.setSlabThickness((UnitDouble)v), false),
        WALL_HEIGHT(Intl.intl("Wall Height"), UnitDouble.class, f -> f.getWallHeight(), (f, v) -> f.setWallHeight((UnitDouble)v), false),
        CLIP_COLOR(Intl.intl("Clip Color"), Color.class, f -> f.getClipColor(), (f, v) -> f.setClipColor((Color)v), false),
        BG_IMAGE(Intl.intl("Background Image"), ModelImage.class, f -> f.getBgImage(), (f, v) -> f.setBgImage((ModelImage)v), true);

        public final Class<?> type;
        public final Function<Floor, Object> getter;
        public final BiConsumer<Floor, Object> setter;
        public final String header;
        public final boolean nullable;

        private <T> Column(String header, Class<T> type, Function<Floor, T> getter, BiConsumer<Floor, T> setter, boolean nullable) {
            this.header = header;
            this.type = type;
            this.getter = getter::apply;
            this.setter = (f, v) -> setter.accept((Floor)f, type.cast(v));
            this.nullable = nullable;
        }

        public static Column fromOrdinal(int ordinal) {
            return Column.values()[ordinal];
        }
    }

    public static class NameCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            UnitDouble elevation = (UnitDouble)table.getValueAt(row, Column.ELEVATION.ordinal());
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (elevation != null) {
                if (value == null) {
                    value = "";
                }
                String name = TVEntryPoints.FloorEP.getName((String)value, elevation);
                this.setText(name);
            }
            return c;
        }
    }

    private static class NewFloorAction
    extends guiAction {
        private static final long serialVersionUID = 1L;
        private final FloorTableModel d_model;
        private final Window d_owner;

        public NewFloorAction(Window owner, FloorTableModel model) {
            super(Intl.intl("Add Floor..."));
            this.d_model = model;
            this.d_owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Floor> floors = this.d_model.getRows().stream().filter(FloorRow::isValid).map(FloorRow::toFloor).collect(Collectors.toList());
            NewFloorDlg.open(this.d_owner, floors, f -> {
                FloorRow temp = new FloorRow((Floor)f);
                this.d_model.addRow(new FloorRow(temp.data));
            });
        }
    }

    private static class FloorRow {
        private final Object[] data;
        private final Floor floor;

        public FloorRow(Object[] data) {
            if (data.length != Column.values().length) {
                throw new IllegalArgumentException("Length of data must match that of Column.values()");
            }
            this.data = data;
            this.floor = null;
        }

        public FloorRow(Floor floor) {
            this.floor = floor;
            this.data = new Object[Column.values().length];
            for (Column column : Column.values()) {
                this.data[column.ordinal()] = column.getter.apply(floor);
            }
        }

        public void setValue(int index, Object value) {
            this.data[index] = value;
        }

        public Object getValue(int index) {
            return this.data[index];
        }

        public Floor toFloor() {
            Floor floor = new Floor("");
            for (Column column : Column.values()) {
                column.setter.accept(floor, this.getValue(column.ordinal()));
            }
            return floor;
        }

        public boolean isValid() {
            for (Column column : Column.values()) {
                Object value = this.getValue(column.ordinal());
                if (value != null || column.nullable) continue;
                return false;
            }
            return true;
        }

        public Floor getFloor() {
            return this.floor;
        }
    }
}

