/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javafx.stage.FileChooser;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Pair;

public class ImageLoader
implements BGImageDlg.IImageLoader {
    private static final FileChooser.ExtensionFilter[] FILTERS = new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_BMP, FileFilters.EXT_FILTER_GIF, FileFilters.EXT_FILTER_JPEG_ALL, FileFilters.EXT_FILTER_PNG, FileFilters.EXT_FILTER_TIFF, FileFilters.EXT_FILTER_TARGA};

    @Override
    public File choose(Component parent, File currFile) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(currFile != null ? currFile.getName() : null, currFile != null ? currFile.getAbsolutePath() : PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, FILTERS);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return null;
        }
        PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
        return f;
    }

    @Override
    public Pair<Image, BGImageXform> load(File file) throws IOException {
        String filename = file.getAbsolutePath();
        try {
            IImage img = ImageManager.getImage(filename);
            if (img == null) {
                throw new IOException(Intl.intl("Could not load image."));
            }
            return new Pair<Image, Object>((Image)img, null);
        }
        catch (OutOfMemoryError e) {
            throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
        }
    }
}

