/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.gui.floorview.ConfigureBGImageAction;
import pyrosim.gui.floorview.FloorComboBox;
import pyrosim.gui.floorview.ManageFloorsAction;
import thunderheadeng.gui.ComboboxPopupMenuWidthListener;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;

public class FloorView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final PyroMod d_mod;
    private final ConfigureBGImageAction d_configureBGImageAction;
    private final ManageFloorsAction d_manageFloorsAction;

    public FloorView(PyroMod mod, RenderComponent renderComp) {
        this.d_mod = mod;
        this.d_configureBGImageAction = new ConfigureBGImageAction(this.d_mod, renderComp);
        this.d_manageFloorsAction = new ManageFloorsAction(this.d_mod, renderComp);
        FloorComboBox fcb = new FloorComboBox(this.getMediator());
        fcb.setMaximumSize(new Dimension(150, fcb.getPreferredSize().height));
        fcb.addPopupMenuListener(new ComboboxPopupMenuWidthListener());
        this.setLayout(new MigLayout("fill, insets 1 6 1 6"));
        JToolBar floorPanelTb = new JToolBar();
        floorPanelTb.setFloatable(false);
        floorPanelTb.add(fcb);
        floorPanelTb.add(this.getConfigureBGImageAction());
        floorPanelTb.add(this.getManageFloorsAction());
        Utils.noToolBarFocus(floorPanelTb);
        this.add((Component)new guiLabel(Intl.intl("Floor:")), "split 2");
        this.add((Component)floorPanelTb, "growx");
    }

    public ConfigureBGImageAction getConfigureBGImageAction() {
        return this.d_configureBGImageAction;
    }

    public ManageFloorsAction getManageFloorsAction() {
        return this.d_manageFloorsAction;
    }

    public PyroMod getMediator() {
        return this.d_mod;
    }
}

