/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Color;
import java.util.HashMap;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import pyrosim.gui.floorview.EditBGImageAction;
import pyrosim.gui.floorview.ImageLoader;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.DisposableObject;
import thunderheadeng.util.IPropertySet;

public class EditModelImageAction
extends DisposableObject
implements EditBGImageAction {
    private final IntermediateGraphicsXfer<?> d_igx = new IntermediateGraphicsXfer();
    private final PyroMod d_mod;
    private final RenderComponent d_renderComp;

    public EditModelImageAction(PyroMod mod, RenderComponent renderComp) {
        this.d_mod = mod;
        this.d_renderComp = renderComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editFloor(final Floor f) {
        HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> colorMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
        colorMap.put(BGImageDlg.Colors.AXIS, PyroSimColors.AXIS_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_BOX, PyroSimColors.AXIS_BOX_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_TEXT, PyroSimColors.AXIS_TEXT_COLOR);
        colorMap.put(BGImageDlg.Colors.BACKGROUND, PyroSimColors.BACKGROUND_COLOR);
        colorMap.put(BGImageDlg.Colors.ORIGIN, PyroSimColors.ORIGIN2D_COLOR);
        ImageLoader imgLoader = new ImageLoader();
        BGImageDlg.ImageInfo existing = null;
        final ModelImage image = f.getBgImage();
        if (image != null) {
            existing = new BGImageDlg.ImageInfo(image.getImage(), image.getLWTransform(), image.getOpacity());
        }
        final BGImageDlg.ImageInfo result = BGImageDlg.editImage(PyroSim.getApp().getActiveFrame(), this.d_renderComp, PyroSim.getApp().getColorManager(), colorMap, imgLoader, PyroSim.getApp().getUnitSystem().getLengthUnit(), this.d_igx, existing);
        try {
            if (result == null) {
                boolean bl = false;
                return bl;
            }
            AUndoableTask tsk = new AUndoableTask(this){

                @Override
                public void undo() {
                    f.setBgImage(image);
                }

                @Override
                public void run() {
                    ModelImage newImg = new ModelImage(result.image, result.xform, result.opacity);
                    f.setBgImage(newImg);
                }
            };
            this.d_mod.getTaskManager().exec(tsk, Intl.intl("Edit Background Image"));
            boolean bl = true;
            return bl;
        }
        finally {
            this.d_igx.dispose();
        }
    }

    @Override
    public void dispose() {
        this.d_igx.release();
    }
}

