/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.fds;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.sql.Date;
import java.text.DateFormat;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.ResultsArchive;
import pyrosim.io.IOUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiTFWithButton;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.TypedProp;

public class RestoreResultsDlg
extends guiDialog {
    private static final long serialVersionUID = 1209299358363477267L;
    public static final TypedProp<Boolean> PREF_RETAIN = new TypedProp<Boolean>((Object)"RestoreResultsDlg.retainArchive", true);
    private final guiCheckBox d_retainArchiveCB;
    private final guiTable d_recordTbl = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("FDS Results"), Intl.intl("Date Created")}, new Class[]{RecordVal.class, RecordVal.class}, 0, 0, 6);
    private final guiTFWithButton d_dstChooser;

    public RestoreResultsDlg(Window parent) {
        super(parent, Intl.intl("Restore Archived Results"), 9);
        this.d_recordTbl.setRowSelectionAllowed(true);
        this.d_recordTbl.setColumnSelectionAllowed(false);
        this.d_recordTbl.setColumnEditable(0, false);
        this.d_recordTbl.setColumnEditable(1, false);
        this.d_recordTbl.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.d_recordTbl.setSelectionMode(0);
        this.d_recordTbl.setSortColumn(1);
        this.d_recordTbl.setSortOrder(2);
        JScrollPane sp = new JScrollPane(this.d_recordTbl);
        this.d_retainArchiveCB = new guiCheckBox(Intl.intl("Retain selected archive."), true);
        this.d_dstChooser = new guiTFWithButton();
        guiTFWithButton.BrowseFileCmd browseCmd = new guiTFWithButton.BrowseFileCmd(this.d_dstChooser.getTextField());
        this.d_dstChooser.setButtonCommand(browseCmd);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Destination directory:"), this.d_dstChooser, 1.0, 0);
        gb.addRow(this.d_retainArchiveCB, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Available Archives (choose one)")));
        gb.addIdentRow(sp, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
        this.setResizable(true);
    }

    @Override
    public int doModal() {
        this.loadPrefs();
        int result = super.doModal();
        if (result == 1) {
            this.savePrefs();
        }
        return result;
    }

    private void loadPrefs() {
        this.d_retainArchiveCB.setSelected(PyroPrefs.getBoolean(PREF_RETAIN));
    }

    private void savePrefs() {
        PyroPrefs.set(PREF_RETAIN, this.d_retainArchiveCB.isSelected(), true);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        String msg;
        int option;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_dstChooser.getTextField().getText().trim().isEmpty()) {
            String msg2 = Intl.intl("You must specify a destination directory for the restored results.");
            return this.invalidateFld(showWarn, allowModify, this.d_dstChooser.getTextField(), msg2);
        }
        int selRow = this.d_recordTbl.getSelectedRow();
        if (selRow == -1) {
            if (showWarn) {
                RestoreResultsDlg.showInvalidEntryMessage(this, Intl.intl("Select an archive from the table to restore."));
            }
            return false;
        }
        File outputDir = this.getDestinationDir();
        return !outputDir.isDirectory() || IOUtil.listFiles(outputDir).size() <= 0 || !showWarn || (option = JOptionPane.showConfirmDialog(this, msg = Intl.intl("All existing files in the destination directory will be deleted.\nWould you like to continue?"), Intl.intl("Delete Existing Files?"), 0)) == 0;
    }

    public void setDefaultDestination(File dstDir) {
        this.d_dstChooser.getTextField().setText(dstDir.getAbsolutePath());
    }

    public File getDestinationDir() {
        return new File(this.d_dstChooser.getTextField().getText().trim());
    }

    public void load(List<ResultsArchive.Record> records) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_recordTbl.getModel();
        model.setRowCount(records.size());
        for (int m = 0; m < records.size(); ++m) {
            ResultsArchive.Record rec = records.get(m);
            model.setValueAt(new RecordVal(rec, RecordVal.Type.NAME), m, 0);
            model.setValueAt(new RecordVal(rec, RecordVal.Type.DATE), m, 1);
        }
        this.d_recordTbl.autoSizeColumns(true);
        if (records.size() > 0) {
            this.d_recordTbl.setRowSelectionInterval(0, 0);
            this.d_recordTbl.setColumnSelectionInterval(0, 1);
        }
    }

    public boolean getRetainArchive() {
        return this.d_retainArchiveCB.isSelected();
    }

    public ResultsArchive.Record getSelectedRecord() {
        RecordVal val = (RecordVal)this.d_recordTbl.getValueAt(this.d_recordTbl.getSelectedRow(), 0);
        return val.record;
    }

    private static class RecordVal
    implements Comparable<RecordVal> {
        public final Type field;
        public final ResultsArchive.Record record;

        public RecordVal(ResultsArchive.Record record, Type field) {
            this.field = field;
            this.record = record;
        }

        @Override
        public int compareTo(RecordVal o) {
            switch (this.field) {
                case DATE: {
                    return Long.signum(this.record.dateCreated - o.record.dateCreated);
                }
                case NAME: {
                    return this.record.name.compareToIgnoreCase(o.record.name);
                }
            }
            return 0;
        }

        public String toString() {
            switch (this.field) {
                case DATE: {
                    Date date = new Date(this.record.dateCreated);
                    return DateFormat.getDateTimeInstance(3, 3).format(date);
                }
                case NAME: {
                    return this.record.name;
                }
            }
            return super.toString();
        }

        public static enum Type {
            DATE,
            NAME;

        }
    }
}

