/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SmokeLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class SmokeDetectorEditor
extends ADevcEditor<SmokeDetector> {
    private final SmokeDetectorDataPanel d_dataPanel;

    public SmokeDetectorEditor(PyroMod pyMod) {
        this.d_dataPanel = new SmokeDetectorDataPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Smoke Detector");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SD");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component parent, SmokeDetector loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public SmokeDetector create() {
        return new SmokeDetector("", this.d_dataPanel.getSmokeLinkModel());
    }

    @Override
    public void load(SmokeDetector sd) {
        this.d_dataPanel.setSmokeLinkModel(sd.getModel());
    }

    @Override
    public void save(SmokeDetector sd) {
        sd.setModel(this.d_dataPanel.getSmokeLinkModel());
    }

    public static class SmokeDetectorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1165057042647528613L;
        private final guiComboBox<SmokeLinkModel> d_modelCombo;

        public SmokeDetectorDataPanel(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_modelCombo = new SmokeLinkModelComboBox(pyMod.getSmokeLinkModels());
            this.d_modelCombo.setMinimumSize(this.d_modelCombo.getPreferredSize());
            this.setSmokeLinkModel(pyMod.getSmokeLinkModels().getDefaultModel());
            JButton d_editSmokeLink = new JButton(Intl.intl("Edit") + "...");
            d_editSmokeLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editSmokeLinkModels(d_modelCombo.getSelectedItem());
                    if (d_modelCombo.getSelectedItem() == null && d_modelCombo.getItemCount() > 0) {
                        d_modelCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Model:"), this.d_modelCombo, d_editSmokeLink, 0);
            gb.finalizeRows();
        }

        public SmokeLinkModel getSmokeLinkModel() {
            return this.d_modelCombo.getSelectedItem();
        }

        public void setSmokeLinkModel(SmokeLinkModel slm) {
            this.d_modelCombo.setSelectedItem(slm);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_modelCombo.getSelectedItem() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a model."));
                }
                if (allowModify) {
                    this.d_modelCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

