/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Arrays;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;

public abstract class ADevcEditor<T extends IDevice>
implements IDevcEditor<T> {
    @Override
    public AlarmInfoPanel createAlarmPanel() {
        IMeasurer msr;
        Object tempObj = this.create();
        if (tempObj instanceof IMeasurer && (msr = (IMeasurer)tempObj).getNumMeasurements() == 1) {
            return new AlarmInfoPanel(msr.getQuantity(0), 0);
        }
        return null;
    }

    @Override
    public TripFlagsPanel createTripPanel() {
        return new TripFlagsPanel();
    }

    @Override
    public ControlSelPnl createCtrlInputPanel(PyroMod domain, NamePnl namePnl) {
        Object tempDevc = this.create();
        if (tempDevc instanceof ISignalSink && ((ISignalSink)tempDevc).getInputPin() instanceof OneLogicInPin) {
            String lbl = tempDevc instanceof IFreezable ? Intl.intl("Freeze Output:") : null;
            String tt = tempDevc instanceof IFreezable ? Intl.intl("Freezes the output of the device when a control activates.") : null;
            ControlSelPnl eventPanel = new ControlSelPnl(domain.getControls(), lbl, tt);
            if (namePnl != null) {
                tempDevc.setName(namePnl.save());
                eventPanel.setNameSrc(namePnl.getNameField(), Arrays.asList(tempDevc));
            }
            return eventPanel;
        }
        return null;
    }
}

