/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckManager;
import pyrosim.domain.auditing.ModelWarning;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.WarningReport;

public class RunModelCheckDlg
extends guiDialog {
    private final PyroMod d_pyroMod;

    public RunModelCheckDlg(Window owner, PyroMod pyroMod) {
        super(owner, Intl.intl("Model Check Results"), 16);
        this.d_pyroMod = pyroMod;
        this.setPreferredSize(new Dimension(900, 500));
        this.setSize(new Dimension(500, 300));
    }

    public void process() {
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new MigLayout("hidemode 3, align 50% 50%"));
        ModelCheckManager modelCheckManager = this.d_pyroMod.getModelCheckMgr();
        DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel();
        JProgressBar progressBar = new JProgressBar(progressModel);
        guiLabel processing = new guiLabel(Intl.intl("Running Model Checks..."));
        mainPanel.add((Component)processing, "wrap");
        mainPanel.add((Component)progressBar, "h 20, w 300");
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        final SecondaryLoop waitLoop = eq.createSecondaryLoop();
        WarningReport<ModelWarning> warningReport = new WarningReport<ModelWarning>(ModelWarning.class, new int[]{1, 2, 0, 3}, new String[]{Intl.intl("Name"), Intl.intl("Description"), Intl.intl("Value"), Intl.intl("Objects")}, 0);
        List modelChecks = ((APyroObject)modelCheckManager).flatten(ModelCheck.class).stream().filter(mc -> mc.isEnabled()).collect(Collectors.toList());
        progressModel.setMinimum(1);
        progressModel.setMaximum(modelChecks.size());
        Runnable execTask = () -> {
            try {
                this.addModelWarnings(warningReport, modelChecks, progressModel);
            }
            finally {
                waitLoop.exit();
            }
        };
        new Thread(execTask).start();
        waitLoop.enter();
        WarningDlg<ModelWarning> warningDlg = new WarningDlg<ModelWarning>(PyroSim.getApp().getActiveFrame(), Intl.intl("Model Check Results"), null, warningReport, 16, WarningDlg.Severity.INFO);
        JButton resetToSelectedBtn = new JButton(Intl.intl("Show Selected Objects"));
        resetToSelectedBtn.setToolTipText(Intl.intl("Reset the view to the objects that may have caused the problems."));
        BiConsumer<List, ActionEvent> selectObjs = (objs, e) -> SwingUtilities.invokeLater(() -> {
            this.d_pyroMod.pauseUpdates();
            try {
                this.d_pyroMod.getSelectionModel().clearSelection();
                this.d_pyroMod.getSelectionModel().selectAll(objs);
                ModelView mv = PyroSim.getApp().getModelView();
                ModelView.ResetToSelectedObjectsAction action = mv.getResetToSelectedAction();
                ((guiAction)action).actionPerformed((ActionEvent)e);
            }
            finally {
                this.d_pyroMod.resumeUpdates();
            }
        });
        resetToSelectedBtn.addActionListener(e -> {
            List warnings = warningDlg.getSelectedWarnings();
            if (warnings.isEmpty()) {
                JOptionPane.showMessageDialog(warningDlg, Intl.intl("Select at least one row first."), Intl.intl("Select a Row"), 2);
                return;
            }
            List objs = warnings.stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
            if (objs.isEmpty()) {
                JOptionPane.showMessageDialog(warningDlg, Intl.intl("There are no objects associated with the selected rows."), Intl.intl("No Objects"), 2);
                return;
            }
            selectObjs.accept(objs, e);
        });
        warningDlg.getActionPanel().add((Component)resetToSelectedBtn, 0);
        final IEventObserver cancelObserver = events -> {
            IEventRecord<IPyroObject> oevts = events.getEvents(IPyroObject.class, new Class[0]);
            if (oevts.hasRemovedObjs()) {
                Set<IPyroObject> removed = oevts.getRemovedObjs();
                warningDlg.removeIf(err -> err.causeObjs.stream().anyMatch(removed::contains));
            }
        };
        this.d_pyroMod.getEvents().addObserver(cancelObserver);
        resetToSelectedBtn.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RunModelCheckDlg.this.d_pyroMod.getEvents().removeObserver(cancelObserver);
                waitLoop.exit();
            }
        });
        processing.setVisible(false);
        progressBar.setVisible(false);
        mainPanel.add(warningDlg.getDialogPane());
        if (!warningReport.isEmpty()) {
            int width = Integer.min(mainPanel.getPreferredSize().width, this.getPreferredSize().width);
            this.setSize(width, mainPanel.getPreferredSize().height);
            this.setLocationRelativeTo(this.getParent());
        } else {
            warningDlg.getTable().setAutoResizeMode(4);
        }
        waitLoop.enter();
    }

    private void addModelWarnings(WarningReport<ModelWarning> warningReport, List<ModelCheck> modelChecks, DefaultBoundedRangeModel progressModel) {
        int i = progressModel.getValue();
        for (ModelCheck modelCheck : modelChecks) {
            Collection<ModelWarning> warnings = modelCheck.getModelWarnings(this.d_pyroMod);
            for (ModelWarning warning : warnings) {
                warningReport.addWarning(warning);
            }
            progressModel.setValue(i++);
        }
    }
}

