/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import pyrosim.FDSVersion;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.auditing.FilterFactory;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckFilter;
import pyrosim.domain.auditing.RecordCheckDesc;
import pyrosim.domain.auditing.ResultContainsCondition;
import pyrosim.domain.auditing.ResultsEmptyCondition;
import pyrosim.domain.auditing.SurfaceCheckDesc;
import pyrosim.gui.boundcond.SurfacePanel;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v7.FDS7Const;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Global;

public class ModelCheckEditor
extends guiPanel
implements IEditor<ModelCheck> {
    private static final long serialVersionUID = 1274617741602977042L;
    private final guiTextField d_checkID;
    private final guiTextField d_desc;
    private JComboBox d_resultCB;
    private final guiComboBox<String> d_checkType;
    private final guiComboBox<String> d_surfType;
    private final Consumer<String> d_updateCheckType;
    private final Consumer<String> d_updateSurfaceType;
    private final guiCheckBox d_hrrCheck;
    private final guiCheckBox d_flowVol;
    private final guiCheckBox d_flowVel;
    private ModelFilterTable d_table;
    public static final String SURFACE_CHECK = Intl.intl("Surface");
    public static final String RECORD_CHECK = Intl.intl("Record");

    public ModelCheckEditor() {
        this.setLayout(new MigLayout("hidemode 3, fillx, insets 0, gap 6"));
        guiPanel modelCheckPanel = new guiPanel(new MigLayout("hidemode 3, fillx, insets 0, gap 6", "[min!][]"));
        guiLabel labCheckID = new guiLabel(Intl.intl("Check ID:"));
        labCheckID.setToolTipText(Intl.intl("ID"));
        this.d_checkID = new guiTextField();
        this.d_checkID.setEditable(false);
        guiLabel labFYI = new guiLabel(Intl.intl("Description:"));
        labFYI.setToolTipText(Intl.intl("Description"));
        this.d_desc = new guiTextField();
        guiLabel labResultCondition = new guiLabel(Intl.intl("Pass Condition:"));
        labResultCondition.setToolTipText(Intl.intl("Defines whether the test will pass with at least one record found or if none are found"));
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(ResultContainsCondition.RESULTS_CONTAIN);
        conditions.add(ResultsEmptyCondition.RESULTS_EMPTY);
        this.d_resultCB = new JComboBox<Object>(conditions.toArray());
        guiLabel typeLabel = new guiLabel(Intl.intl("Model Check Type:"));
        typeLabel.setToolTipText(Intl.intl("Type of Model Check"));
        this.d_checkType = new guiComboBox<String>((T[])new String[]{SURFACE_CHECK, RECORD_CHECK});
        guiLabel labTable = new guiLabel(Intl.intl("Filters:"));
        labTable.setToolTipText(Intl.intl("Model records will be filtered by this criteria."));
        guiDefaultTableModel model = new guiDefaultTableModel(0, 5, true, Integer.MAX_VALUE, false, 5);
        this.d_table = new ModelFilterTable(model, new String[]{Intl.intl("Op"), Intl.intl("Record"), Intl.intl("Field"), Intl.intl("Condition"), Intl.intl("Value")}, new Class[]{ModelCheck.Op.class, String.class, String.class, ModelCheck.Condition.class, String.class});
        JComboBox<ModelCheck.Op> opBox = new JComboBox<ModelCheck.Op>(ModelCheck.Op.values());
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(opBox));
        ArrayList<String> al = new ArrayList<String>(this.getRecordSpecs().keySet());
        Collections.sort(al);
        JComboBox<Object> recordBox = new JComboBox<Object>(al.toArray());
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(recordBox));
        JComboBox<ModelCheck.Condition> conBox = new JComboBox<ModelCheck.Condition>(ModelCheck.Condition.values());
        this.d_table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(conBox));
        guiTableEditor editor = new guiTableEditor(this.d_table, 22);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(400, editor.getPreferredSize().height));
        modelCheckPanel.add(labCheckID);
        modelCheckPanel.add((Component)this.d_checkID, "growx, wrap");
        modelCheckPanel.add(labFYI);
        modelCheckPanel.add((Component)this.d_desc, "growx, wrap");
        modelCheckPanel.add(typeLabel);
        modelCheckPanel.add(this.d_checkType, "wrap, width 100");
        modelCheckPanel.add(labResultCondition);
        modelCheckPanel.add((Component)this.d_resultCB, "wrap");
        this.d_surfType = new guiComboBox();
        this.d_surfType.addItem((String)SurfacePanel.BURNER);
        this.d_surfType.addItem((String)SurfacePanel.SUPPLY);
        this.d_surfType.addItem((String)SurfacePanel.EXHAUST);
        guiLabel surfTypeLabel = new guiLabel(Intl.intl("Surface Type: "));
        modelCheckPanel.add(surfTypeLabel);
        modelCheckPanel.add(this.d_surfType, "wrap, width 100");
        this.add((Component)modelCheckPanel, "grow, wrap");
        this.add((Component)labTable, "wrap");
        this.add((Component)editor, "span 2, grow, wrap");
        guiPanel surfPanel = new guiPanel(new MigLayout("hidemode 3"));
        this.d_hrrCheck = new guiCheckBox(Intl.intl("Calculate total maximum HRR per applicable surface."));
        this.d_flowVol = new guiCheckBox(Intl.intl("Calculate total maximum flow volume per applicable surface."));
        this.d_flowVel = new guiCheckBox(Intl.intl("Calculate maximum flow velocity per applicable surface."));
        surfPanel.add((Component)this.d_hrrCheck, "wrap");
        surfPanel.add((Component)this.d_flowVol, "wrap");
        surfPanel.add((Component)this.d_flowVel, "wrap");
        this.add(surfPanel);
        this.d_updateCheckType = check -> {
            if (check.equals(SURFACE_CHECK)) {
                labTable.setVisible(false);
                editor.setVisible(false);
                surfPanel.setVisible(true);
                surfTypeLabel.setVisible(true);
                this.d_surfType.setVisible(true);
                labResultCondition.setVisible(false);
                this.d_resultCB.setVisible(false);
            } else {
                labTable.setVisible(true);
                editor.setVisible(true);
                surfPanel.setVisible(false);
                surfTypeLabel.setVisible(false);
                this.d_surfType.setVisible(false);
                labResultCondition.setVisible(true);
                this.d_resultCB.setVisible(true);
            }
            this.setModified(true);
        };
        this.d_updateSurfaceType = s -> {
            if (s.equals(SurfacePanel.BURNER)) {
                this.d_hrrCheck.setVisible(true);
                this.d_flowVol.setVisible(false);
                this.d_flowVel.setVisible(false);
            } else {
                this.d_hrrCheck.setVisible(false);
                this.d_flowVol.setVisible(true);
                this.d_flowVel.setVisible(true);
            }
            this.setModified(true);
        };
        this.d_checkType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModelCheckEditor.this.d_updateCheckType.accept((String)e.getItem());
                ModelCheckEditor.this.d_table.clearRows();
            }
        });
        this.d_surfType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModelCheckEditor.this.d_updateSurfaceType.accept((String)e.getItem());
            }
        });
        this.d_updateSurfaceType.accept(this.d_surfType.getSelectedItem());
        this.d_updateCheckType.accept(this.d_checkType.getSelectedItem());
        this.d_resultCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModelCheckEditor.this.setModified(true);
            }
        });
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(ModelCheck mc) {
        this.setEnabled(mc != null);
        if (mc != null) {
            if (mc.getCheckDesc() instanceof SurfaceCheckDesc) {
                SurfaceCheckDesc smc = (SurfaceCheckDesc)mc.getCheckDesc();
                this.d_checkType.setSelectedItem(SURFACE_CHECK);
                if (smc.getType().equals((Object)SurfaceCheckDesc.Type.EXHAUST)) {
                    this.d_surfType.setSelectedItem(SurfacePanel.EXHAUST);
                } else if (smc.getType().equals((Object)SurfaceCheckDesc.Type.SUPPLY)) {
                    this.d_surfType.setSelectedItem(SurfacePanel.SUPPLY);
                } else {
                    this.d_surfType.setSelectedItem(SurfacePanel.BURNER);
                }
                this.d_hrrCheck.setSelected(smc.d_maxHrr);
                this.d_flowVol.setSelected(smc.d_maxVol);
                this.d_flowVel.setSelected(smc.d_maxVel);
            } else {
                this.d_checkType.setSelectedItem(RECORD_CHECK);
            }
            this.d_checkID.setText(mc.getName());
            this.d_desc.setText(mc.getDescription());
            this.d_desc.setEnabled(true);
            String rc = mc.getResultCondition().getID();
            this.d_resultCB.setSelectedItem(rc);
            if (mc.getCheckDesc() instanceof RecordCheckDesc) {
                RecordCheckDesc rcd = (RecordCheckDesc)mc.getCheckDesc();
                this.d_table.clearRows();
                ArrayList<ModelCheckFilter> filters = rcd.getFilters();
                if (filters.size() > 0) {
                    ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(filters.size());
                    for (int i = 0; i < filters.size(); ++i) {
                        ModelCheckFilter f = filters.get(i);
                        this.d_table.setValueAt((Object)f.getOp(), i, 0);
                        this.d_table.setValueAt(f.getRecord(), i, 1);
                        this.d_table.setValueAt(f.getField(), i, 2);
                        this.d_table.setValueAt((Object)f.getCondition(), i, 3);
                        this.d_table.setValueAt(f.getValue(), i, 4);
                    }
                }
            }
            this.setModified(false);
        }
    }

    @Override
    public ModelCheck preview(ModelCheck check) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveCheck(check);
        return check;
    }

    @Override
    public ModelCheck commit(final ModelCheck dataObj) {
        assert (dataObj != null);
        assert (this.isModified());
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                ModelCheckEditor.this.saveCheck(dataObj);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Check"));
        this.setModified(false);
        return dataObj;
    }

    protected void saveCheck(ModelCheck dataObj) {
        ICheckDesc mcDesc = dataObj.getCheckDesc();
        String checkType = this.d_checkType.getSelectedItem();
        if (checkType.equals(SURFACE_CHECK) && mcDesc instanceof RecordCheckDesc) {
            dataObj.setCheckDesc(new SurfaceCheckDesc());
        }
        if (checkType.equals(RECORD_CHECK) && mcDesc instanceof SurfaceCheckDesc) {
            dataObj.setCheckDesc(new RecordCheckDesc(new ArrayList<ModelCheckFilter>()));
        }
        dataObj.setDescription(this.d_desc.getText());
        String condition = this.d_resultCB.getSelectedItem().toString();
        if (condition.equals(ResultsEmptyCondition.RESULTS_EMPTY)) {
            dataObj.setResultCondition(new ResultsEmptyCondition());
        } else if (condition.equals(ResultContainsCondition.RESULTS_CONTAIN)) {
            dataObj.setResultCondition(new ResultContainsCondition());
        }
        if (dataObj.getCheckDesc() instanceof SurfaceCheckDesc) {
            SurfaceCheckDesc surfaceCheck = (SurfaceCheckDesc)dataObj.getCheckDesc();
            String type = this.d_surfType.getSelectedItem();
            if (type.equals(SurfacePanel.BURNER)) {
                surfaceCheck.setType(SurfaceCheckDesc.Type.HRR);
            }
            if (type.equals(SurfacePanel.EXHAUST)) {
                surfaceCheck.setType(SurfaceCheckDesc.Type.EXHAUST);
            }
            if (type.equals(SurfacePanel.SUPPLY)) {
                surfaceCheck.setType(SurfaceCheckDesc.Type.SUPPLY);
            }
            surfaceCheck.setOptions(this.d_hrrCheck.isSelected(), this.d_flowVol.isSelected(), this.d_flowVel.isSelected());
        }
        if (dataObj.getCheckDesc() instanceof RecordCheckDesc) {
            RecordCheckDesc rcd = (RecordCheckDesc)dataObj.getCheckDesc();
            int numRows = this.d_table.getRowCount() - 1;
            if (numRows > 0) {
                ArrayList<ModelCheckFilter> checkFilters = new ArrayList<ModelCheckFilter>();
                for (int row = 0; row < numRows; ++row) {
                    ModelCheckFilter mcf = this.d_table.createCheckFilter(row);
                    checkFilters.add(mcf);
                }
                rcd.setFilters(checkFilters);
            }
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private Map<String, FDSRecordSpec> getRecordSpecs() {
        FDSVersion fdsVersion = PyroSim.getApp().getFDSCompability();
        if (fdsVersion.major == 7) {
            return FDS7Const.getRecordSpecs();
        }
        return FDS6Const.getRecordSpecs();
    }

    private class ModelFilterTable
    extends guiTable {
        public ModelFilterTable(guiDefaultTableModel model, String[] columnHeaders, Class[] columnClasses) {
            super((TableModel)model, 24);
            this.setNullValuesAllowed(true);
            if (columnHeaders.length != columnClasses.length) {
                throw new IllegalArgumentException("Must have same number of column headers as column classes.");
            }
            this.setModel(model);
            TableColumnModel tcm = this.getColumnModel();
            for (int i = 0; i < columnHeaders.length; ++i) {
                tcm.getColumn(i).setHeaderValue(columnHeaders[i]);
                model.setColumnClass(i, columnClasses[i]);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row == 0 && col == 0) {
                return false;
            }
            return row <= 0 || this.getValueAt(row, 0) != ModelCheck.Op.AND || col != 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row == 0 && column == 0) {
                value = null;
            }
            super.setValueAt(value, row, column);
            if (row > 0 && column == 0 && value == ModelCheck.Op.AND) {
                value = this.getValueAt(row - 1, 1);
                column = 1;
                this.setValueAt(value, row, column);
            }
            if (column == 1 && value != null) {
                for (int i = row + 1; i < this.getRowCount() && this.getValueAt(i, 0) == ModelCheck.Op.AND; ++i) {
                    this.setValueAt(value, i, 1);
                }
                super.setValueAt("", row, 2);
                super.setValueAt("", row, 4);
            }
            if (column == 2 && value != null) {
                String record = this.getValueAt(row, 1).toString();
                FDSRecordSpec.Field f = ModelCheckEditor.this.getRecordSpecs().get((Object)record).fields.get(value.toString());
                if (f.initialValue != null) {
                    super.setValueAt(f.initialValue, row, 4);
                }
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            Object recordVal = this.getValueAt(row, 1);
            Object fieldVal = this.getValueAt(row, 2);
            if (column == 2 && recordVal != null) {
                ArrayList<String> al = new ArrayList<String>(ModelCheckEditor.this.getRecordSpecs().get((Object)recordVal).fields.keySet());
                Collections.sort(al);
                JComboBox<Object> fieldBox = new JComboBox<Object>(al.toArray());
                return new DefaultCellEditor(fieldBox);
            }
            if (column == 4 && recordVal != null && fieldVal != null) {
                FDSRecordSpec.Field f = ModelCheckEditor.this.getRecordSpecs().get((Object)recordVal).fields.get(fieldVal);
                if (f.clazz == UnitDouble.class) {
                    FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
                    return new guiTable.UnitDoubleEditor(udf.unit);
                }
                if (f.clazz == Double.class) {
                    return new guiTable.guiDoubleEditor();
                }
                if (f.clazz == Integer.class) {
                    return new guiTable.guiIntegerEditor();
                }
                if (f.clazz == Boolean.class) {
                    return new guiTable.guiBooleanEditor();
                }
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object recordVal = this.getValueAt(row, 1);
            Object fieldVal = this.getValueAt(row, 2);
            if (column == 4 && recordVal != null && fieldVal != null) {
                DefaultTableCellRenderer renderer;
                FDSRecordSpec.Field f = ModelCheckEditor.this.getRecordSpecs().get((Object)recordVal).fields.get(fieldVal);
                if (f.clazz == UnitDouble.class) {
                    FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
                    renderer = new guiTable.UnitDoubleRenderer(udf.unit);
                } else {
                    renderer = f.clazz == Double.class ? new guiTable.guiDoubleRenderer() : (f.clazz == Integer.class ? new guiTable.guiIntegerRenderer() : (f.clazz == Boolean.class ? new guiTable.guiBooleanRenderer() : new DefaultTableCellRenderer()));
                }
                renderer.setHorizontalAlignment(2);
                return renderer;
            }
            return super.getCellRenderer(row, column);
        }

        private ModelCheckFilter createCheckFilter(int row) {
            ModelCheck.Op op = (ModelCheck.Op)((Object)ModelCheckEditor.this.d_table.getValueAt(row, 0));
            op = op == null ? ModelCheck.Op.AND : op;
            String record = (String)ModelCheckEditor.this.d_table.getValueAt(row, 1);
            String field = (String)ModelCheckEditor.this.d_table.getValueAt(row, 2);
            ModelCheck.Condition condition = (ModelCheck.Condition)((Object)ModelCheckEditor.this.d_table.getValueAt(row, 3));
            Object value = ModelCheckEditor.this.d_table.getValueAt(row, 4);
            FDSRecordSpec.Field f = ModelCheckEditor.this.getRecordSpecs().get((Object)record).fields.get(field);
            if (f.clazz == UnitDouble.class) {
                UnitDouble ud = this.parseUnitDoubleVal(value, f);
                return FilterFactory.create(op, record, field, condition, ud);
            }
            if (f.clazz == Double.class) {
                Double d = Double.parseDouble(value.toString());
                return FilterFactory.create(op, record, field, condition, d);
            }
            if (f.clazz == Integer.class) {
                int i = Integer.parseInt(value.toString());
                return FilterFactory.create(op, record, field, condition, i);
            }
            if (f.clazz == Boolean.class) {
                boolean b = Boolean.parseBoolean(value.toString());
                return FilterFactory.create(op, record, field, condition, b);
            }
            return FilterFactory.create(op, record, field, condition, value.toString());
        }

        private UnitDouble parseUnitDoubleVal(Object value, FDSRecordSpec.Field f) {
            try {
                FDSRecordSpec.UnitDoubleFld udf = (FDSRecordSpec.UnitDoubleFld)f;
                return Global.parseUnitDouble(value.toString(), udf.unit);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean valid = super.validateData(showWarn, allowModify);
            if (!valid) {
                return false;
            }
            TableModel model = this.getModel();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    if (model.getValueAt(row, col) != null || row == 0 || col == 0) continue;
                    String msg = String.format(thunderheadeng.Intl.intl("Error: Blank value in cell, [%s]."), this.formatCellName(row, col));
                    this.flagInvalidCell(row, col, showWarn, allowModify, msg);
                    return false;
                }
            }
            return true;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            c.setEnabled(this.isCellEditable(row, column));
            return c;
        }
    }
}

