/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jscience.physics.units.Unit;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.actions.ARunFDSValidation;

public class FuelMolecularWeightValidation
extends ARunFDSValidation {
    private String d_fuel = "";
    private double maxMolecularWeight = 100.0;
    private Collection<IPyroObject> d_tooBigFuels = new ArrayList<IPyroObject>();

    public FuelMolecularWeightValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        Unit molweight = this.d_app.getUnitSystem().getUnit(17);
        List allUserDefSpecs = this.d_pyroMod.getExSpecList().flatten().stream().filter(s -> !s.isPredefined()).collect(Collectors.toList());
        if (allUserDefSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        for (ExSpec s2 : allUserDefSpecs) {
            ExSpec.PrimitiveParams specParams = s2.getPrimParams();
            if (specParams.isSpecHeatSet() || specParams.isSpecHeatLiquidSet()) continue;
            if (s2.getWtType() == 1 && s2.getMolecularWeight().getValue(molweight) > this.maxMolecularWeight) {
                this.addFuelToWarningsList(s2);
                continue;
            }
            if (s2.getWtType() != 2 || s2.getChemFormula().isEmpty() || !(FuelMolecularWeightValidation.getMolecularWeightFromFormula(s2.getChemFormula()) > this.maxMolecularWeight)) continue;
            this.addFuelToWarningsList(s2);
        }
        return this.d_tooBigFuels;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("One or more high molecular weight fuels that are not in the FDS database\nare detected: " + this.d_fuel + "\nReduce molecular weight or define fuel specific heat.\n\nClick OK to abort simulation and return to PyroSim.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Fuel Molecular Weight Validation");
    }

    private void addFuelToWarningsList(ExSpec fuel) {
        this.d_fuel = this.d_fuel.isEmpty() ? fuel.getName() : this.d_fuel.concat(", " + fuel.getName());
        this.d_tooBigFuels.add(fuel);
    }

    private static double getMolecularWeightFromFormula(String formula) {
        try {
            IMolecularFormula f = MolecularFormulaManipulator.getMolecularFormula(formula, DefaultChemObjectBuilder.getInstance());
            return MolecularFormulaManipulator.getMass(f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0.0;
        }
    }
}

