/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.geom.Geometry;
import pyrosim.gui.comboboxes.GridComboBox;
import pyrosim.gui.grid.PartitionMeshDlg;
import pyrosim.gui.grid.RefineMeshDlg;
import pyrosim.gui.grid.SplitMeshDlg;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ActionsMesh {
    private static final UnitDouble UD_ZERO = new UnitDouble(0.0, SI.METER);

    private static UnitDouble getExtent(UnitDouble[] dxs) {
        UnitDouble extent = UD_ZERO;
        for (UnitDouble dx : dxs) {
            extent = extent == UD_ZERO ? dx : extent.add(dx);
        }
        return extent;
    }

    private static List<Grid> getSelectedMeshes(PyroSimSelectionModel selection) {
        ArrayList<IPyroObject> dataObjs = new ArrayList<IPyroObject>(selection.getSelected(IPyroObject.class, Grid.class, GridList.class));
        ArrayList<Grid> meshes = new ArrayList<Grid>();
        for (IPyroObject obj : dataObjs) {
            if (obj instanceof Grid) {
                meshes.add((Grid)obj);
                continue;
            }
            if (!(obj instanceof GridList)) continue;
            meshes.addAll(((GridList)obj).flatten());
        }
        return meshes;
    }

    private static List<IMeasurementStat> getDependingStats(Grid grid, DepSnapshot ds) {
        ArrayList<IMeasurementStat> stats = new ArrayList<IMeasurementStat>();
        ds.takeSnapshot(grid);
        for (Dependency dep : ds.getDependents(grid)) {
            IMeasurementStat stat;
            IDirectDependent depObj = dep.source;
            if (!(depObj instanceof IMeasurementStat) || !((stat = (IMeasurementStat)((Object)depObj)).getMsrGeom() instanceof StatGeom.GridGeom)) continue;
            stats.add(stat);
        }
        return stats;
    }

    private static class MeshChooserDlg
    extends guiDialog {
        private static final long serialVersionUID = 7314096068036393842L;
        private GridComboBox d_cbMeshes;

        public MeshChooserDlg(Window owner, String title, GridList allGrids, final Collection<Grid> chooseFrom) {
            super(owner, title, 9);
            this.d_cbMeshes = new GridComboBox(allGrids);
            this.d_cbMeshes.setFilter(new Predicate<Grid>(){

                @Override
                public boolean test(Grid g) {
                    return chooseFrom.contains(g);
                }
            });
            GridBagHelper baggins = new GridBagHelper(this.getDialogPane());
            baggins.addFilledRow(new guiLabel(Intl.intl("The selected meshes have different cell sizes.")));
            baggins.addRow(new guiLabel(Intl.intl("Use Cell Size from Mesh: ")), this.d_cbMeshes);
        }

        public Grid getSelectedMesh() {
            return (Grid)this.d_cbMeshes.getSelectedItem();
        }
    }

    private static class ReplaceGridReferenceTask
    extends AUndoableTask {
        private final IMeasurementStat d_stat;
        private final Grid d_grid;

        public ReplaceGridReferenceTask(IMeasurementStat stat, Grid grid) {
            this.d_stat = stat;
            this.d_grid = grid;
        }

        @Override
        public void undo() {
            this.d_stat.setGeom(GeomNodeUtil.newNode(new StatGeom.GridGeom(this.d_grid)));
        }

        @Override
        public void run() {
            this.d_stat.setGeom(GeomNodeUtil.newNode(new AABoxGeom(this.d_grid.getBounds())));
        }
    }

    public static class MergeMeshAction
    extends guiAction {
        private static final long serialVersionUID = -4791693111614498239L;
        private static final ImageIcon ICON = null;

        public MergeMeshAction() {
            super(Intl.intl("Merge Meshes"), ICON);
        }

        public static boolean isMergeOptionAvailable(PyroSimSelectionModel sm) {
            IFilteredCollection<IPyroObject> selGrids = sm.getSelected(IPyroObject.class, Grid.class, GridList.class);
            return selGrids.isExclusive() && 1 < ActionsMesh.getSelectedMeshes(sm).size();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            PyroSimSelectionModel selModel = pyMod.getSelectionModel();
            List<Grid> toMerge = ActionsMesh.getSelectedMeshes(selModel);
            AABox allBounds = null;
            for (Grid g : toMerge) {
                if (allBounds == null) {
                    allBounds = new AABox(g.getBounds());
                    continue;
                }
                allBounds.add(g.getBounds());
            }
            double tol = 1.0E-6;
            byte diffAxes = 0;
            boolean X = true;
            int Y = 2;
            int Z = 4;
            for (Grid g : toMerge) {
                AABox gridBounds = g.getBounds();
                if (!theUtil.eq0(gridBounds.getMinX() - allBounds.getMinX(), tol) || !theUtil.eq0(gridBounds.getMaxX() - allBounds.getMaxX(), tol)) {
                    diffAxes = (byte)(diffAxes | 1);
                }
                if (!theUtil.eq0(gridBounds.getMinY() - allBounds.getMinY(), tol) || !theUtil.eq0(gridBounds.getMaxY() - allBounds.getMaxY(), tol)) {
                    diffAxes = (byte)(diffAxes | 2);
                }
                if (theUtil.eq0(gridBounds.getMinZ() - allBounds.getMinZ(), tol) && theUtil.eq0(gridBounds.getMaxZ() - allBounds.getMaxZ(), tol)) continue;
                diffAxes = (byte)(diffAxes | 4);
            }
            if (diffAxes != 0 && (diffAxes & diffAxes - 1) != 0) {
                JOptionPane.showMessageDialog(pySim.getMainFrame(), Intl.intl("Unable to merge meshes.\nMeshes differ in more than one axis."), Intl.intl("Error"), 2);
                return;
            }
            boolean[] uniformAcrossMeshes = new boolean[]{true, true, true};
            boolean[] uniformWithinEachMesh = new boolean[]{true, true, true};
            UnitPoint3D sz0 = null;
            for (Grid g : toMerge) {
                if (sz0 == null) {
                    sz0 = g.getCellSize(uniformWithinEachMesh);
                    continue;
                }
                UnitPoint3D sz = g.getCellSize(uniformWithinEachMesh);
                uniformAcrossMeshes[0] = uniformAcrossMeshes[0] & (uniformWithinEachMesh[0] && sz0.xu().diff(sz.xu()).getValue(SI.METER) <= tol);
                uniformAcrossMeshes[1] = uniformAcrossMeshes[1] & (uniformWithinEachMesh[1] && sz0.yu().diff(sz.yu()).getValue(SI.METER) <= tol);
                uniformAcrossMeshes[2] = uniformAcrossMeshes[2] & (uniformWithinEachMesh[2] && sz0.zu().diff(sz.zu()).getValue(SI.METER) <= tol);
            }
            final byte diffAxesBits = diffAxes;
            Collections.sort(toMerge, new Comparator<Grid>(){

                @Override
                public int compare(Grid o1, Grid o2) {
                    if ((diffAxesBits & 1) != 0) {
                        return Double.compare(o1.getMinPoint().x(SI.METER), o2.getMinPoint().x(SI.METER));
                    }
                    if ((diffAxesBits & 2) != 0) {
                        return Double.compare(o1.getMinPoint().y(SI.METER), o2.getMinPoint().y(SI.METER));
                    }
                    if ((diffAxesBits & 4) != 0) {
                        return Double.compare(o1.getMinPoint().z(SI.METER), o2.getMinPoint().z(SI.METER));
                    }
                    return 0;
                }
            });
            byte disjoint = 0;
            for (int i = 1; i < toMerge.size(); ++i) {
                AABox m0 = toMerge.get(i - 1).getBounds();
                AABox m1 = toMerge.get(i).getBounds();
                disjoint = (byte)(disjoint | (tol < Math.abs(m1.getMinX() - m0.getMaxX()) ? (byte)1 : 0));
                disjoint = (byte)(disjoint | (tol < Math.abs(m1.getMinY() - m0.getMaxY()) ? 2 : 0));
                disjoint = (byte)(disjoint | (tol < Math.abs(m1.getMinZ() - m0.getMaxZ()) ? 4 : 0));
            }
            if ((diffAxes & disjoint) != 0) {
                JOptionPane.showMessageDialog(pySim.getMainFrame(), Intl.intl("Unable to merge meshes.\nMeshes must be adjacent."), Intl.intl("Error"), 2);
                return;
            }
            String name = String.format(Intl.intl("%s-merged"), toMerge.get(0).getName());
            Grid g = new Grid(name, (Grid.GridGeom)toMerge.get(0).getGeom().getLocalGeom());
            for (int i = 1; i < toMerge.size(); ++i) {
                Grid g0 = g;
                Grid g1 = toMerge.get(i);
                UnitDouble[] xdivs = (diffAxes & 1) == 0 ? g0.getXDivisions() : this.merge(g0.getXDivisions(), g1.getXDivisions());
                UnitDouble[] ydivs = (diffAxes & 2) == 0 ? g0.getYDivisions() : this.merge(g0.getYDivisions(), g1.getYDivisions());
                UnitDouble[] zdivs = (diffAxes & 4) == 0 ? g0.getZDivisions() : this.merge(g0.getZDivisions(), g1.getZDivisions());
                AABox bounds = this.getUnifiedBounds(Arrays.asList(g0, g1));
                UnitPoint3D min = new UnitPoint3D(bounds.getMin(), (Unit)SI.METER);
                UnitPoint3D max = new UnitPoint3D(bounds.getMax(), (Unit)SI.METER);
                g = new Grid(g.getName(), min, max, xdivs, ydivs, zdivs);
            }
            LinkedHashSet<GridList> parentGrids = new LinkedHashSet<GridList>();
            for (Grid mergeGrid : toMerge) {
                parentGrids.add((GridList)mergeGrid.getParent());
            }
            GridList firstContainer = (GridList)parentGrids.iterator().next();
            GridList deleteParent = null;
            if (parentGrids.size() == 1 && firstContainer.flatten().size() == toMerge.size()) {
                deleteParent = firstContainer;
            }
            DepSnapshot gridDS = pyMod.getDependencies(toMerge);
            ArrayList<IMeasurementStat> dependingStats = new ArrayList<IMeasurementStat>();
            for (Grid grid : toMerge) {
                dependingStats.addAll(ActionsMesh.getDependingStats(grid, gridDS));
            }
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(pyMod);
            task.addTask(Tasks.delete(toMerge));
            if (deleteParent != null && deleteParent != pyMod.getGridManager()) {
                if (pyMod.getGridManager().getAll(deleteParent.getName()).isEmpty()) {
                    g.setName(deleteParent.getName());
                }
                task.addTask(Tasks.delete(deleteParent));
            }
            task.addTask(new AddTask((IPyroObject)pyMod.getGridManager(), new IPyroObject[]{g}));
            task.addTask(new SelectTask(pyMod, g));
            dependingStats.forEach(stat -> task.addTask(new ReplaceGridReferenceTask((IMeasurementStat)stat, ((StatGeom.GridGeom)stat.getMsrGeom()).grid)));
            pyMod.getTaskManager().exec(task, Intl.intl("Merge Meshes"));
        }

        private UnitDouble[] merge(UnitDouble[] arr0, UnitDouble[] arr1) {
            UnitDouble[] merged = new UnitDouble[arr0.length + arr1.length];
            System.arraycopy(arr0, 0, merged, 0, arr0.length);
            System.arraycopy(arr1, 0, merged, arr0.length, arr1.length);
            return merged;
        }

        private AABox getUnifiedBounds(Collection<Grid> grids) {
            AABox bounds = null;
            for (Grid g : grids) {
                if (bounds == null) {
                    bounds = g.getBounds();
                    continue;
                }
                bounds.add(g.getBounds());
            }
            return bounds;
        }
    }

    public static class RefineMeshAction
    extends guiAction {
        private static final long serialVersionUID = -2817785711358139596L;
        private static final ImageIcon ICON = null;

        public RefineMeshAction() {
            super(Intl.intl("Refine Mesh..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            PyroSimSelectionModel selModel = pyMod.getSelectionModel();
            List<Grid> toRefine = ActionsMesh.getSelectedMeshes(selModel);
            LinkedHashSet<Grid> allOtherGrids = new LinkedHashSet<Grid>(pyMod.getGridManager().flatten());
            allOtherGrids.removeAll(toRefine);
            RefineMeshDlg dlg = new RefineMeshDlg((Window)pySim.getMainFrame(), toRefine, allOtherGrids);
            if (dlg.doModal() == 1) {
                if (dlg.isCoarsen()) {
                    int confirm;
                    boolean uniform = true;
                    for (Grid g : toRefine) {
                        uniform &= this.isUniform(g, 1.0E-6);
                    }
                    if (!uniform && (confirm = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to maintain non-uniform meshes after coarsen.\nMeshes will become uniform. Continue?"), Intl.intl("Warning"), 2)) != 0) {
                        return;
                    }
                }
                CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(pyMod);
                double cellCountfactor = dlg.getValue();
                for (Grid g : toRefine) {
                    task.addTask(g.taskRefine(cellCountfactor));
                }
                pyMod.getTaskManager().exec(task, Intl.intl("Refine Mesh"));
            }
        }

        private boolean isUniform(Grid g, double tol) {
            return this.isUniform(g.getXDivisions(), tol) && this.isUniform(g.getYDivisions(), tol) && this.isUniform(g.getZDivisions(), tol);
        }

        private boolean isUniform(UnitDouble[] vals, double tol) {
            for (int i = 1; i < vals.length; ++i) {
                if (!(tol < vals[i - 1].diff(vals[i]).getValue(SI.METER))) continue;
                return false;
            }
            return true;
        }
    }

    public static class PartitionMeshAction
    extends guiAction {
        private static final long serialVersionUID = 4559122283493869453L;
        private static final ImageIcon ICON = null;
        private static HashMap<Integer, List<Integer>> descendingPrimeFactors = new HashMap();

        public PartitionMeshAction() {
            super(Intl.intl("Partition Mesh..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            PyroSimSelectionModel selModel = pyMod.getSelectionModel();
            List<Grid> toSplit = ActionsMesh.getSelectedMeshes(selModel);
            HashMap<Grid, Integer> gridCellMap = new HashMap<Grid, Integer>();
            int totalCells = 0;
            for (Grid g : toSplit) {
                int numGridCells = g.getCellCount();
                gridCellMap.put(g, numGridCells);
                totalCells += numGridCells;
            }
            PartitionMeshDlg dlg = new PartitionMeshDlg((Window)pySim.getMainFrame(), toSplit.size());
            if (dlg.doModal() == 1) {
                HashMap<Grid, List<Pair<Geometry.Axis, UnitDouble>>> divisionMap = new HashMap<Grid, List<Pair<Geometry.Axis, UnitDouble>>>();
                PartitionMeshAction.divideGrids(new ArrayList<Grid>(gridCellMap.keySet()), divisionMap, totalCells, dlg.getValue());
                if (divisionMap.size() == 0) {
                    dlg.showFailureDlg();
                }
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyMod);
                for (Grid grid : divisionMap.keySet()) {
                    if (divisionMap.get(grid).size() <= 0) continue;
                    compositeTask.addTask(SplitMeshAction.taskSplitMeshes(Arrays.asList(grid), pyMod.getDependencies(grid), divisionMap.get(grid)));
                }
                pyMod.getTaskManager().exec(compositeTask, Intl.intl("Partition Mesh"));
            }
        }

        private static int divideGrids(List<Grid> grids, HashMap<Grid, List<Pair<Geometry.Axis, UnitDouble>>> divisionMap, int totalCells, int totalDesiredPartitions) {
            if (totalDesiredPartitions <= 1) {
                return totalDesiredPartitions;
            }
            int desiredPartitionSize = totalCells / totalDesiredPartitions;
            int successfulPartitions = 0;
            int GRIDS_REST = grids.size() - 1;
            int maxGridPartitions = totalDesiredPartitions - GRIDS_REST;
            for (Grid grid : grids) {
                int increment = 0;
                int gridPartitions = Math.round((float)grid.getCellCount() / (float)desiredPartitionSize);
                if (gridPartitions >= maxGridPartitions) {
                    gridPartitions -= GRIDS_REST;
                }
                List<Object> gridDivisions = new ArrayList();
                while (gridPartitions - increment > 0 && gridPartitions + increment <= maxGridPartitions) {
                    gridDivisions = PartitionMeshAction.getDivisions(grid, gridPartitions + increment);
                    if (gridDivisions.size() > 0 || gridPartitions == 1) {
                        successfulPartitions = gridPartitions + increment;
                        ArrayList<Grid> gridsRest = new ArrayList<Grid>(grids);
                        gridsRest.remove(grid);
                        int restPartitions = totalDesiredPartitions - (gridPartitions + increment);
                        int restCellCount = totalCells - grid.getCellCount();
                        if ((successfulPartitions += PartitionMeshAction.divideGrids(gridsRest, divisionMap, restCellCount, restPartitions)) == totalDesiredPartitions) {
                            divisionMap.put(grid, gridDivisions);
                            return successfulPartitions;
                        }
                    }
                    increment = increment > 0 ? increment * -1 : (increment - 1) * -1;
                }
            }
            return successfulPartitions;
        }

        private static List<Integer> descendingPrimeFactors(int num) {
            if (descendingPrimeFactors.containsKey(num)) {
                return descendingPrimeFactors.get(num);
            }
            ArrayList<Integer> factors = new ArrayList<Integer>();
            for (int i = 2; i <= num; ++i) {
                while (num % i == 0) {
                    factors.add(i);
                    num /= i;
                }
            }
            Collections.sort(factors, Collections.reverseOrder());
            descendingPrimeFactors.put(num, factors);
            return factors;
        }

        private static UnitDouble getAxisLength(Geometry.Axis axis, AABox bounds) {
            UnitDouble max = axis.getVal(bounds.getMin());
            UnitDouble min = axis.getVal(bounds.getMax());
            return max.diff(min);
        }

        private static List<Pair<Geometry.Axis, UnitDouble>> getDivisions(Grid grid, int partitionCount) {
            ArrayList<Pair<Geometry.Axis, UnitDouble>> divisions = new ArrayList<Pair<Geometry.Axis, UnitDouble>>();
            if (partitionCount == 1) {
                return divisions;
            }
            AABox bounds = grid.getGridGeom().getBoundingBox(new AABox());
            List<Division> axesDivisions = Arrays.asList(new Division(Geometry.Axis.X, grid.getXDivisions().length, PartitionMeshAction.getAxisLength(Geometry.Axis.X, bounds), grid.getXDivisionLength()), new Division(Geometry.Axis.Y, grid.getYDivisions().length, PartitionMeshAction.getAxisLength(Geometry.Axis.Y, bounds), grid.getYDivisionLength()), new Division(Geometry.Axis.Z, grid.getZDivisions().length, PartitionMeshAction.getAxisLength(Geometry.Axis.Z, bounds), grid.getZDivisionLength()));
            Iterator<Object> iterator = PartitionMeshAction.descendingPrimeFactors(partitionCount).iterator();
            while (iterator.hasNext()) {
                int newCellSegment;
                int factor = iterator.next();
                assert (axesDivisions.size() > 0);
                Collections.sort(axesDivisions, (a, b) -> {
                    if (a.partitionCellCount == b.partitionCellCount) {
                        return 0;
                    }
                    return a.partitionCellCount <= b.partitionCellCount ? 1 : -1;
                });
                Division maxLength = axesDivisions.get(0);
                if (maxLength.cellCount / 3 < maxLength.numDivisions + factor) {
                    return divisions;
                }
                UnitDouble newLength = new UnitDouble(maxLength.divisionLength.getRawValue() / (double)factor, maxLength.divisionLength.getUnit());
                maxLength.partitionCellCount = newCellSegment = (int)Math.floor(newLength.getRawValue() / maxLength.cellLength.getRawValue());
                maxLength.divisionLength = newLength;
                maxLength.numDivisions += factor;
            }
            for (Division division : axesDivisions) {
                double min = division.axis.getVal(bounds.getMin()).getRawValue();
                double max = division.axis.getVal(bounds.getMax()).getRawValue();
                double segment = division.divisionLength.getRawValue();
                double i = min;
                while (theUtil.le(i, max, 0.001)) {
                    divisions.add(new Pair<Geometry.Axis, UnitDouble>(division.axis, new UnitDouble(i + segment, division.divisionLength.getUnit())));
                    i += segment;
                }
            }
            return divisions;
        }

        private static class Division {
            public Geometry.Axis axis;
            public int cellCount;
            public int partitionCellCount;
            public UnitDouble divisionLength;
            public UnitDouble cellLength;
            public int numDivisions;

            Division(Geometry.Axis axis, int cellSegment, UnitDouble divisionLength, UnitDouble cellLength) {
                this(axis, cellSegment, divisionLength, cellLength, 0);
            }

            Division(Geometry.Axis axis, int cellCount, UnitDouble divisionLength, UnitDouble cellLength, int numDivisions) {
                this.axis = axis;
                this.cellCount = cellCount < 3 ? 3 : cellCount;
                this.partitionCellCount = cellCount;
                this.divisionLength = divisionLength;
                this.cellLength = cellLength;
                this.numDivisions = numDivisions;
            }
        }
    }

    public static class SplitMeshAction
    extends guiAction {
        private static final long serialVersionUID = 4559122283493869453L;
        private static final ImageIcon ICON = null;

        public SplitMeshAction() {
            super(Intl.intl("Split Mesh..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Task task;
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            PyroSimSelectionModel selModel = pyMod.getSelectionModel();
            List<Grid> toSplit = ActionsMesh.getSelectedMeshes(selModel);
            AABox bounds = GeomUtil.getBounds(toSplit);
            SplitMeshDlg dlg = new SplitMeshDlg((Window)pySim.getMainFrame(), pySim.getUnitSystem(), bounds);
            if (dlg.doModal() == 1 && (task = SplitMeshAction.taskSplitMeshes(toSplit, pyMod.getDependencies(toSplit), Arrays.asList(new Pair<Geometry.Axis, UnitDouble>(dlg.getAxis(), dlg.getValue())))) != null) {
                pyMod.getTaskManager().exec(task, Intl.intl("Split Mesh"));
            }
        }

        public static Task taskSplit(List<Grid> toSplit, List<Plane3d> splitPlanes, DepSnapshot deps) {
            ArrayList<Pair<Geometry.Axis, UnitDouble>> splits = new ArrayList<Pair<Geometry.Axis, UnitDouble>>(splitPlanes.size());
            for (Plane3d plane : splitPlanes) {
                Geometry.Axis axis = Geometry.Axis.values()[Util3D.getClosestAxis(plane.getNormal())];
                UnitDouble v = new UnitDouble(-plane.w, Geometry.LU);
                splits.add(new Pair<Geometry.Axis, UnitDouble>(axis, v));
            }
            return SplitMeshAction.taskSplitMeshes(toSplit, deps, splits);
        }

        public static Task taskSplitMeshes(List<Grid> toSplit, DepSnapshot gridDS, List<Pair<Geometry.Axis, UnitDouble>> splits) {
            boolean atLeastOneMeshSplit = false;
            ArrayList<NamedPyroObject> reps = new ArrayList<NamedPyroObject>();
            ArrayList<UnitDouble> xSplits = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> ySplits = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> zSplits = new ArrayList<UnitDouble>();
            for (Pair<Geometry.Axis, UnitDouble> pair : splits) {
                switch ((Geometry.Axis)((Object)pair.v1)) {
                    case X: {
                        xSplits.add((UnitDouble)pair.v2);
                        break;
                    }
                    case Y: {
                        ySplits.add((UnitDouble)pair.v2);
                        break;
                    }
                    case Z: {
                        zSplits.add((UnitDouble)pair.v2);
                    }
                }
            }
            Collections.sort(xSplits);
            Collections.sort(ySplits);
            Collections.sort(zSplits);
            ArrayList<IMeasurementStat> dependingStats = new ArrayList<IMeasurementStat>();
            for (Grid g : toSplit) {
                List<UnitDouble[]> dxsList = Arrays.asList(new UnitDouble[][]{g.getXDivisions()});
                if (!xSplits.isEmpty()) {
                    dxsList = SplitMeshAction.splitDivisions(g.getXLinePositions(), xSplits, 3);
                }
                List<UnitDouble[]> dysList = Arrays.asList(new UnitDouble[][]{g.getYDivisions()});
                if (!ySplits.isEmpty()) {
                    dysList = SplitMeshAction.splitDivisions(g.getYLinePositions(), ySplits, 3);
                }
                List<UnitDouble[]> dzsList = Arrays.asList(new UnitDouble[][]{g.getZDivisions()});
                if (!zSplits.isEmpty()) {
                    dzsList = SplitMeshAction.splitDivisions(g.getZLinePositions(), zSplits, 3);
                }
                List<Grid> newMeshes = SplitMeshAction.createMeshes(g.getName(), g.getMinPoint(), g.getMaxPoint(), dxsList, dysList, dzsList);
                assert (!newMeshes.isEmpty());
                if (newMeshes.size() == 1) {
                    reps.add(g);
                    continue;
                }
                GridList fragments = new GridList(g.getName());
                fragments.addAll(newMeshes);
                reps.add(fragments);
                atLeastOneMeshSplit = true;
                dependingStats.addAll(ActionsMesh.getDependingStats(g, gridDS));
            }
            if (atLeastOneMeshSplit) {
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(pyroMod);
                task.addTask(Tasks.replace(toSplit, reps, true));
                task.addTask(new SelectTask(pyroMod, reps));
                dependingStats.forEach(stat -> task.addTask(new ReplaceGridReferenceTask((IMeasurementStat)stat, ((StatGeom.GridGeom)stat.getMsrGeom()).grid)));
                return task;
            }
            JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to split mesh.\nEach side must have at least 3 cells."), Intl.intl("Warning"), 2);
            return null;
        }

        public static int getSplitIndex(UnitDouble[] lines, UnitDouble splitNear) {
            int splitOn = Arrays.binarySearch(lines, splitNear);
            if (splitOn < 0 && 0 < (splitOn = -(splitOn + 1)) && splitOn < lines.length && lines[splitOn - 1].diff(splitNear).compareTo(lines[splitOn].diff(splitNear)) < 0) {
                --splitOn;
            }
            return splitOn;
        }

        private static List<UnitDouble[]> splitDivisions(UnitDouble[] lines, List<UnitDouble> sortedSplits, int minCellsAlongAxis) {
            ArrayList<UnitDouble[]> result = new ArrayList<UnitDouble[]>();
            UnitDouble[] currLines = lines;
            for (int m = 0; m < sortedSplits.size(); ++m) {
                List<UnitDouble[]> splitLines = SplitMeshAction.splitLines(currLines, sortedSplits.get(m), minCellsAlongAxis);
                if (splitLines.size() <= 1) continue;
                result.add(SplitMeshAction.convertPositionsToDivs(splitLines.get(0)));
                currLines = splitLines.get(1);
            }
            result.add(SplitMeshAction.convertPositionsToDivs(currLines));
            return result;
        }

        private static UnitDouble[] convertPositionsToDivs(UnitDouble[] positions) {
            if (positions.length < 2) {
                return new UnitDouble[0];
            }
            UnitDouble[] divs = new UnitDouble[positions.length - 1];
            for (int m = 0; m < positions.length - 1; ++m) {
                UnitDouble d1 = positions[m];
                UnitDouble d2 = positions[m + 1];
                divs[m] = d2.sub(d1);
            }
            return divs;
        }

        private static List<UnitDouble[]> splitLines(UnitDouble[] lines, UnitDouble splitNear, int minCellsAlongAxis) {
            int splitOn = SplitMeshAction.getSplitIndex(lines, splitNear);
            if (minCellsAlongAxis <= splitOn && splitOn <= lines.length - 1 - minCellsAlongAxis) {
                UnitDouble[] head = new UnitDouble[splitOn + 1];
                UnitDouble[] tail = new UnitDouble[lines.length - splitOn];
                System.arraycopy(lines, 0, head, 0, head.length);
                System.arraycopy(lines, splitOn, tail, 0, tail.length);
                return Arrays.asList(head, tail);
            }
            return Arrays.asList(new UnitDouble[][]{lines});
        }

        private static List<Grid> createMeshes(String baseName, UnitPoint3D minPt, UnitPoint3D maxPt, List<UnitDouble[]> dxsList, List<UnitDouble[]> dysList, List<UnitDouble[]> dzsList) {
            ArrayList<Grid> meshes = new ArrayList<Grid>();
            int n = 1;
            UnitPoint3D ptA = minPt;
            for (UnitDouble[] dxs : dxsList) {
                UnitDouble extentX = ActionsMesh.getExtent(dxs);
                for (UnitDouble[] dys : dysList) {
                    UnitDouble extentY = ActionsMesh.getExtent(dys);
                    for (UnitDouble[] dzs : dzsList) {
                        UnitDouble extentZ = ActionsMesh.getExtent(dzs);
                        UnitPoint3D ptB = ptA.add(new UnitPoint3D(extentX, extentY, extentZ));
                        String name = String.format("%s-%02d", baseName, n++);
                        meshes.add(new Grid(name, ptA, ptB, dxs, dys, dzs));
                        ptA = new UnitPoint3D(ptA.xu(), ptA.yu(), ptA.zu().add(extentZ));
                    }
                    ptA = new UnitPoint3D(ptA.xu(), ptA.yu().add(extentY), minPt.zu());
                }
                ptA = new UnitPoint3D(ptA.xu().add(extentX), minPt.yu(), minPt.zu());
            }
            return meshes;
        }
    }
}

