/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collection;
import java.util.function.Supplier;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.SelectTask;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;

public abstract class ARunFDSValidation {
    protected final PyroMod d_pyroMod;
    protected final PyroSim d_app;

    protected ARunFDSValidation(PyroSim app, PyroMod mod) {
        this.d_pyroMod = mod;
        this.d_app = app;
    }

    public abstract Collection<IPyroObject> validateModel();

    public abstract Prompt getPrompt(Window var1, int var2);

    public Supplier<Boolean> getResponse(int button, Collection<IPyroObject> conflicts) {
        if (button == 1) {
            return () -> {
                SelectTask tsk = new SelectTask(this.d_pyroMod, conflicts);
                EventQueue.invokeLater(() -> this.d_pyroMod.getTaskManager().exec(tsk, this.getValidationDescription()));
                return false;
            };
        }
        return () -> true;
    }

    public abstract String getValidationDescription();

    public static class Prompt
    extends guiDialog {
        private static final long serialVersionUID = -170226266450598831L;

        public Prompt(Window owner, String instructions) {
            super(owner, Intl.intl("Warning"), 9);
            this.setResizable(true);
            MultiLineLabel instructLbl = new MultiLineLabel(instructions);
            instructLbl.setLineWrap(false);
            this.getDialogPane().add((Component)instructLbl, "Center");
        }

        public void overrideButtonDesc(int button, String text) {
            this.getButton(button).setText(text);
        }
    }
}

