/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JPopupMenu;
import pyrosim.PyroMod;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.actions.Actions;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class MouseSelectionLogic {
    private final PyroMod d_mediator;
    private final Component d_parentComp;
    private static final Predicate<Object> s_selectFilter = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return MouseSelectionLogic.isSelectable(o);
        }
    };

    public MouseSelectionLogic(PyroMod mediator, Component parentComp) {
        this.d_mediator = mediator;
        this.d_parentComp = parentComp;
    }

    public void handleSelectionSingle(MouseEvent event, Collection<Integer> pressedKeys, Object ... hitObjects) {
        this.handleSelectionSingle(event, pressedKeys, Arrays.asList(hitObjects));
    }

    public void handleSelectionSingle(MouseEvent event, Collection<Integer> pressedKeys, Collection<?> objs) {
        Object selGeomObj = null;
        if (!(objs = theUtil.filter(objs, s_selectFilter)).isEmpty()) {
            selGeomObj = objs.iterator().next();
        }
        if (event.getButton() == 1) {
            this.handleSelectionClick(event, pressedKeys, selGeomObj == null ? Collections.EMPTY_LIST : Arrays.asList(selGeomObj));
            if (event.getClickCount() == 2) {
                EventQueue.invokeLater(new Runnable(this){

                    @Override
                    public void run() {
                        Actions.editSelectedNode();
                    }
                });
            }
        } else if (event.isPopupTrigger()) {
            if (selGeomObj == null || !this.d_mediator.getSelectionModel().isSelected(selGeomObj)) {
                this.handleSelectionClick(event, pressedKeys, Arrays.asList(selGeomObj));
            }
            Set<?> selSet = this.d_mediator.getSelectionModel().getSelection();
            this.showPopup(event, selSet);
        }
    }

    public void handleSelectionMultiple(MouseEvent event, Collection<Integer> pressedKeys, Object ... hitObjects) {
        this.handleSelectionMultiple(event, pressedKeys, Arrays.asList(hitObjects));
    }

    public void handleSelectionMultiple(MouseEvent event, Collection<Integer> pressedKeys, Collection<?> objs) {
        objs = theUtil.filter(objs, s_selectFilter);
        this.handleSelectionClick(event, pressedKeys, objs);
        if (event.isMetaDown()) {
            this.showPopup(event, objs);
        }
    }

    private void showPopup(MouseEvent event, Collection<?> objs) {
        JPopupMenu menu = Actions.getContextMenu(objs);
        if (menu != null) {
            menu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void handleSelectionClick(MouseEvent click, Collection<Integer> pressedKeys, Collection<?> hitObjects) {
        PyroSimSelectionModel selection = this.d_mediator.getSelectionModel();
        LinkedIdentityHashSet objsToSelect = new LinkedIdentityHashSet();
        LinkedIdentityHashSet objsToDeselect = new LinkedIdentityHashSet();
        for (Object obj : hitObjects) {
            boolean select;
            if (click.isAltDown() && obj instanceof IPyroObject) {
                obj = ((IPyroObject)obj).getParent();
                assert (obj != null && !(obj instanceof PyroMod));
            }
            boolean bl = select = !click.isControlDown() || !selection.isSelected(obj);
            if (select && obj != null) {
                objsToSelect.add(obj);
                continue;
            }
            if (obj == null) continue;
            objsToDeselect.add(obj);
        }
        LinkedIdentityHashSet selParents = new LinkedIdentityHashSet();
        for (IPyroObject obj : theUtil.filter(objsToDeselect, IPyroObject.class)) {
            for (IPyroObject ancestor = obj.getParent(); ancestor != null && selection.isSelected(ancestor); ancestor = ancestor.getParent()) {
                selParents.add(ancestor);
            }
        }
        objsToDeselect.addAll(selParents);
        for (IPyroObject obj : selParents) {
            for (IPyroObject iPyroObject : obj.getMembers()) {
                if (objsToDeselect.contains(iPyroObject)) continue;
                objsToSelect.add(iPyroObject);
            }
        }
        this.d_mediator.pauseUpdates();
        if (!click.isControlDown()) {
            selection.clearSelection();
        }
        selection.deselectAll(objsToDeselect);
        selection.selectAll(objsToSelect);
        this.d_mediator.resumeUpdates();
    }

    private static boolean isSelectable(Object o) {
        return o instanceof IPyroObject;
    }
}

