/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.FDSLibraryDlg;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.InvisibleSplitPane;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.util.Util;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Sets;
import thunderheadeng.util.Task;

public class ManagerDlg<T extends IPyroObject, MgrT extends Composite<T>>
extends guiDialog
implements ListSelectionListener,
DlgListener,
Observer,
ActionListener {
    private static final long serialVersionUID = -7711774257867902856L;
    private final JFrame d_owner;
    private final guiPanel d_mgrEdPanel;
    private final guiPanel d_actPanel;
    private final guiPanel d_edPanel;
    private ListCellRenderer d_ren;
    public static final String KEY = "KEY";
    private MgrT d_mgr;
    private RecordList d_recs;
    private IEditor<T> d_editor;
    private IEditor<MgrT> d_mgrEditor;
    private FDSRecordPreviewPanel d_preview;
    private T d_tempRecord;
    private boolean d_previewLock = false;
    protected int d_edix;
    private Consumer<T> d_selectionHandler;

    public ManagerDlg(JFrame owner, String title) {
        this(owner, title, false);
    }

    public ManagerDlg(JFrame owner, String title, boolean recordPreview) {
        super((Window)owner, title, 11);
        this.d_owner = owner;
        this.d_mgr = null;
        this.d_editor = null;
        this.d_mgrEditor = null;
        this.d_ren = new ManagedListCellRen();
        this.d_recs = new RecordList();
        this.d_recs.addListener(this);
        this.d_tempRecord = null;
        this.d_preview = null;
        if (recordPreview && PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW)) {
            this.d_preview = new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT));
            this.d_preview.setEnabled(false);
            this.d_preview.setMinimumSize(this.getPreferredSize());
        }
        this.d_selectionHandler = obj -> PyroSim.getApp().getMediator().getSelectionModel().setSelection(obj);
        this.d_edix = -1;
        this.addDlgListener(this);
        CloseListener closeLis = new CloseListener();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(ks);
        this.getRootPane().registerKeyboardAction(closeLis, ks, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeLis);
        guiPanel content = this.getDialogPane();
        content.setLayout(new BorderLayout());
        this.d_mgrEdPanel = new guiPanel(new GridBagLayout());
        guiPanel left = new guiPanel(new GridBagLayout());
        this.d_edPanel = new guiPanel(new GridBagLayout());
        this.d_actPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(this.d_actPanel, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
        GridBagUtil.add(left, this.d_recs, 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0);
        GridBagUtil.add(left, this.d_actPanel, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0);
        InvisibleSplitPane splitPane = new InvisibleSplitPane(1, true, left, this.d_edPanel);
        splitPane.setDividerSize(12);
        content.add((Component)this.d_mgrEdPanel, "North");
        content.add((Component)splitPane, "Center");
        this.setResizable(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.d_status = 16;
        this.fireButtonPressed(16);
    }

    public RecordList getList() {
        return this.d_recs;
    }

    public void setSelectionHandler(Consumer<T> selectObjFunc) {
        this.d_selectionHandler = selectObjFunc;
    }

    public T getSelectedInList() {
        return this.d_edix >= 0 ? (T)this.getList().getItem(this.d_edix) : null;
    }

    public IEditor<T> getEditor() {
        return this.d_editor;
    }

    protected void setRenderer(ListCellRenderer ren) {
        this.d_ren = ren;
    }

    public final boolean preSave() {
        if (this.d_editor.isModified()) {
            int opt = this.showConfirm();
            if (opt == 1) {
                this.initItem(this.getList().getItem(this.d_edix));
            } else if (opt == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int ix = this.getList().getSelectedIx();
        if (this.d_edix == ix) {
            return;
        }
        if (-1 < this.d_edix && this.d_edix < ((Composite)this.d_mgr).flatten().size() && this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    boolean isValid = this.handleYes();
                    if (!isValid) {
                        this.handleCancel();
                        break;
                    }
                }
                case 1: {
                    this.handleNo(ix);
                    this.d_edix = ix;
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else if (ix > -1) {
            this.d_edix = ix;
            this.handleNo(ix);
        } else {
            this.d_edix = ix;
            this.initItem(null);
        }
    }

    protected boolean handleYes() {
        Object edObj = this.getList().getItem(this.d_edix);
        this.d_previewLock = true;
        boolean validated = this.d_editor.getEditorPanel().validateData(true, true);
        this.d_previewLock = false;
        if (!validated) {
            this.d_recs.select(this.d_edix);
            return false;
        }
        this.commit(edObj);
        return true;
    }

    protected void handleNo(int ix) {
        this.d_edix = ix;
        Object edItem = this.d_edix > -1 ? this.getList().getItem(this.d_edix) : null;
        this.initItem(edItem);
    }

    protected void handleCancel() {
        this.d_recs.select(this.d_edix);
    }

    public int showConfirm() {
        Object edObj = this.getList().getItem(this.d_edix);
        String msg = String.format(Intl.intl("Save changes to %s?"), Util.getName(edObj));
        return JOptionPane.showConfirmDialog(this, msg);
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.handleNo(this.d_edix);
                        this.setVisible(false);
                        break;
                    }
                    this.handleCancel();
                    break;
                }
                case 1: {
                    this.handleNo(this.d_edix);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    private void commit(T edObj) {
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).pauseUpdates();
        this.d_editor.commit(edObj);
        if (this.d_preview != null) {
            this.setPreview(edObj, false);
        }
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).resumeUpdates();
    }

    @Override
    public void applyPressed() {
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).pauseUpdates();
        if (this.d_editor.isModified()) {
            int ix = this.getList().getSelectedIx();
            Object edObj = this.getList().getItem(ix);
            this.commit((IPyroObject)edObj);
            this.getList().repaint();
        }
        if (this.d_mgrEditor != null && this.d_mgrEditor.isModified()) {
            this.d_mgrEditor.commit(this.d_mgr);
        }
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).resumeUpdates();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        this.d_previewLock = true;
        boolean result = this.d_editor.getEditorPanel().validateData(showWarn, allowModify) && (this.d_mgrEditor == null || this.d_mgrEditor.getEditorPanel().validateData(showWarn, allowModify));
        this.d_previewLock = false;
        return result;
    }

    protected void init(MgrT mgr, IEditor<T> ed, Action[] actions) {
        this.init(mgr, ed, actions, null);
    }

    protected void init(MgrT mgr, IEditor<T> ed, Action[] actions, T initSel) {
        this.init(mgr, ed, null, actions, initSel);
    }

    protected void init(MgrT mgr, IEditor<T> ed, IEditor<MgrT> mgrEditor, Action[] actions) {
        this.init(mgr, ed, mgrEditor, actions, null);
    }

    public void init(MgrT mgr, IEditor<T> ed, IEditor<MgrT> mgrEditor, Action[] actions, T initSel) {
        if (this.d_editor != null) {
            this.d_editor.removeObserver(this);
        }
        this.d_mgr = mgr;
        this.d_editor = ed;
        this.d_mgrEditor = mgrEditor;
        this.d_recs.setModel(mgr, this.d_ren);
        if (this.d_mgrEditor != null) {
            this.d_mgrEditor.init(this.d_mgr);
        }
        this.d_edix = -1;
        if (((Composite)this.d_mgr).flatten().size() > 0) {
            this.d_recs.select(0);
        }
        this.d_actPanel.removeAll();
        for (int i = 0; i < actions.length; ++i) {
            KeyStroke k = (KeyStroke)actions[i].getValue(KEY);
            if (k != null) {
                this.d_recs.d_list.getInputMap().put(k, "released");
                this.d_recs.d_list.getActionMap().put("released", actions[i]);
            }
            JButton actBtn = new JButton(actions[i]);
            int bottom = i == actions.length - 1 ? 0 : 6;
            GridBagUtil.add(this.d_actPanel, actBtn, 0, i, 1, 1, 0, 0, bottom, 0, 2, 1.0, 0.0);
        }
        this.d_mgrEdPanel.removeAll();
        if (this.d_mgrEditor != null) {
            GridBagUtil.add(this.d_mgrEdPanel, this.d_mgrEditor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 18);
        }
        this.d_edPanel.removeAll();
        if (this.d_preview == null) {
            GridBagUtil.add(this.d_edPanel, this.d_editor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        } else {
            InvisibleSplitPane splitPane = new InvisibleSplitPane(0, true, this.d_editor.getEditorPanel(), this.d_preview);
            splitPane.setDividerSize(12);
            GridBagUtil.add(this.d_edPanel, splitPane, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        }
        this.d_editor.addObserver(this);
        this.pack();
        if (initSel != null) {
            this.getList().select(initSel);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.d_preview != null && this.d_tempRecord != null && !this.d_previewLock) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IPyroObject result = (IPyroObject)ManagerDlg.this.d_editor.preview(ManagerDlg.this.d_tempRecord);
                        if (result != null) {
                            ManagerDlg.this.setPreview(result, true);
                            ManagerDlg.this.d_tempRecord = result;
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("[2293fa] FDS Preview Failed: " + t.getMessage());
                        t.printStackTrace();
                    }
                }
            });
        }
        this.d_recs.repaint();
    }

    public void setPreview(T obj, boolean showDiff) {
        this.d_preview.setRecord((IPyroObject)obj, showDiff);
    }

    protected Collection<? extends T> getModelColl(MgrT manager) {
        return Util.sort(manager);
    }

    protected void initItem(T item) {
        this.d_previewLock = true;
        this.d_editor.init(item);
        this.d_previewLock = false;
        if (this.d_preview != null) {
            this.d_preview.setEnabled(item != null);
            if (item != null) {
                this.d_tempRecord = (IPyroObject)item.clone();
                this.setPreview(this.d_tempRecord, false);
            }
        }
        if (item != null) {
            this.d_selectionHandler.accept(item);
        }
    }

    public FDSRecordPreviewPanel getPreviewPnl() {
        return this.d_preview;
    }

    public void setPreviewTypes(String ... types) {
        this.setPreviewTypes(Sets.fromArrayHS(types));
    }

    public void setPreviewTypes(Collection<String> types) {
        FDSRecordPreviewPanel preview = this.getPreviewPnl();
        if (preview != null) {
            preview.setRenderDeps(true);
            preview.setRecordFilter(rec -> types.contains(rec.getType()));
        }
    }

    public void deleteCurrentItem() {
        int ix = this.getList().getSelectedIx();
        Object sm = this.getList().getItem(ix);
        PyroMod domain = (PyroMod)((ADomainObject)this.d_mgr).getDomain();
        Task t = Actions.getDeleteTask(domain, Arrays.asList(sm));
        if (t == null) {
            return;
        }
        this.d_editor.getEditorPanel().setModified(false);
        domain.getTaskManager().exec(t, Intl.intl("Delete"));
        this.getList().updateModelView(this.d_mgr);
        int newIx = ix - 1 < 0 && !((Composite)this.d_mgr).flatten().isEmpty() ? 0 : ix - 1;
        this.getList().select(newIx);
        if (newIx == ix) {
            this.initItem(this.getList().getItem(newIx));
        }
    }

    private class ManagedListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7609602000218412444L;
        private Font d_italic = new Font("SansSerif", 2, 11);
        private Font d_plain = new Font("SansSerif", 0, 11);

        private ManagedListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, Util.getName((IPyroObject)value), index, isSelected, cellHasFocus);
            c.setEnabled(((IPyroObject)value).isEnabled());
            if (index == ManagerDlg.this.d_edix && ManagerDlg.this.d_editor.isModified()) {
                c.setFont(this.d_italic);
            } else {
                c.setFont(this.d_plain);
            }
            return c;
        }
    }

    public class RecordList
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = -579898510570858990L;
        private final JList d_list = new JList();
        private final JScrollPane d_jsp;
        private final List d_listeners;
        private boolean d_suppressNotify;

        public RecordList() {
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(120, 180));
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_jsp, "Center");
            this.d_suppressNotify = false;
            this.d_listeners = new ArrayList();
        }

        public int getSelectedIx() {
            return this.d_list.getSelectedIndex();
        }

        public T getItem(int ix) {
            return (IPyroObject)this.d_list.getModel().getElementAt(ix);
        }

        public void select(int ix) {
            this.d_list.setSelectedIndex(ix);
            this.valueChanged();
        }

        public void select(T obj) {
            this.d_list.setSelectedValue(obj, true);
            this.valueChanged();
        }

        public void setModel(MgrT mgr, ListCellRenderer ren) {
            this.d_list.setCellRenderer(ren);
            this.d_list.setModel(new DefaultListModel());
            this.updateModelView(mgr);
        }

        public void updateModelView(MgrT mgr) {
            DefaultListModel model = (DefaultListModel)this.d_list.getModel();
            Object selected = this.d_list.getSelectedValue();
            int scrIx = this.d_jsp.getVerticalScrollBar().getValue();
            this.d_suppressNotify = true;
            model.clear();
            for (IPyroObject obj : ManagerDlg.this.getModelColl(mgr)) {
                model.addElement(obj);
            }
            this.d_suppressNotify = false;
            int newScrIx = Math.min(scrIx, this.d_jsp.getVerticalScrollBar().getMaximum());
            this.d_jsp.getVerticalScrollBar().setValue(newScrIx);
            if (model.contains(selected)) {
                this.d_list.setSelectedValue(selected, false);
            } else {
                this.d_list.setSelectedIndex(0);
            }
        }

        public void addListener(ListSelectionListener listener) {
            this.d_listeners.add(listener);
        }

        public void removeListener(Object obj) {
            this.d_listeners.remove(obj);
        }

        private void valueChanged() {
            int newIx = this.d_list.getSelectedIndex();
            ListSelectionEvent evt = new ListSelectionEvent(this, newIx, newIx, false);
            this.valueChanged(evt);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.d_suppressNotify) {
                return;
            }
            for (Object obj : this.d_listeners) {
                ((ListSelectionListener)obj).valueChanged(e);
            }
        }

        public int getNumItems() {
            return this.d_list.getModel().getSize();
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            ManagerDlg.this.d_status = 16;
            ManagerDlg.this.fireButtonPressed(16);
        }
    }

    protected class LibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;
        protected final Class<T> d_type;

        public LibraryAction(Class<T> type) {
            super(Intl.intl("Add From Library") + "...");
            this.d_type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            int ix = ManagerDlg.this.getList().getSelectedIx();
            FDSLibraryDlg dlg = new FDSLibraryDlg(ManagerDlg.this.d_owner, this.d_type);
            dlg.doModal();
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
            int newIx = ix - 1 < 0 && !((Composite)ManagerDlg.this.d_mgr).flatten().isEmpty() ? 0 : ix - 1;
            if (ix >= 0) {
                ManagerDlg.this.getList().select(newIx);
                if (newIx == ix) {
                    ManagerDlg.this.initItem(ManagerDlg.this.getList().getItem(newIx));
                }
            }
        }
    }

    public class DeleteAction
    extends guiAction {
        private static final long serialVersionUID = 8607244730954836742L;

        public DeleteAction() {
            super(Intl.intl("Delete..."));
            this.putValue(ManagerDlg.KEY, KeyStroke.getKeyStroke(127, 0, true));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ManagerDlg.this.deleteCurrentItem();
        }
    }
}

