/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.HvacEditor;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.NewTypeDlg;
import pyrosim.gui.RenameAction;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;

public class HvacManagerDlg
extends ManagerDlg<IHvacObject, HvacList> {
    private static final long serialVersionUID = -3811235398216606102L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private HvacList d_mgr;
    private NewDlgHvac d_newDlg;

    public HvacManagerDlg(JFrame owner, PyroMod mod, UnitSystem usys) {
        super(owner, Intl.intl("Edit HVAC"), true);
        this.d_editor = new HvacEditor(mod, usys);
        this.d_actions = new Action[]{new NewAction(), new RenameAction<IHvacObject, HvacList>(this, Intl.intl("HVAC Component")), new ManagerDlg.DeleteAction(this)};
        this.d_mgr = null;
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(HvacList mgr, IHvacObject init) {
        this.d_mgr = mgr;
        ((RenameAction)this.d_actions[1]).init(mgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -8429755501175962407L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HvacManagerDlg.this.preSave()) {
                return;
            }
            if (HvacManagerDlg.this.d_newDlg == null) {
                HvacManagerDlg.this.d_newDlg = new NewDlgHvac((Window)HvacManagerDlg.this, HvacManagerDlg.this.d_mgr);
            }
            if (HvacManagerDlg.this.d_newDlg.doModal() != 1) {
                return;
            }
            IHvacObject rec = HvacManagerDlg.this.d_newDlg.createNewComponent();
            assert (rec != null);
            AddTask tAdd = new AddTask((IPyroObject)HvacManagerDlg.this.d_mgr, new IPyroObject[]{rec});
            PyroMod domain = (PyroMod)HvacManagerDlg.this.d_mgr.getDomain();
            domain.getTaskManager().exec(tAdd, Intl.intl("New HVAC Component"));
            HvacManagerDlg.this.getList().updateModelView(HvacManagerDlg.this.d_mgr);
            HvacManagerDlg.this.getList().select(rec);
            HvacManagerDlg.this.updateActions();
        }
    }

    private static class NewDlgHvac
    extends NewTypeDlg<IHvacObject, Type> {
        private static final long serialVersionUID = -1205262744754657282L;

        public NewDlgHvac(Window owner, HvacList mgr) {
            super(owner, Intl.intl("New HVAC Component"), mgr, Intl.intl("Type:"), new guiComboBox<Type>(Type.values()));
        }

        @Override
        protected String getNameSuggestion(PyroMod domain, Type type) {
            return domain.getNames(type.getType()).generateName();
        }

        @Override
        protected void validateName(PyroMod domain, Type type, String name) throws Exception {
            if (domain.getNames(type.getType()).isRegistered(name)) {
                throw new NewTypeDlg.NameInUseException();
            }
        }

        public IHvacObject createNewComponent() {
            return ((Type)((Object)this.getSelectedType())).createNewComponent(this.getSelectedName());
        }
    }

    protected static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type AIRCOIL = new Type("AIRCOIL");
        public static final /* enum */ Type FAN = new Type("FAN");
        public static final /* enum */ Type FILTER = new Type("FILTER");
        public static final /* enum */ Type LEAK = new Type("LEAK");
        public final String fdsKey;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String fdsKey) {
            this.fdsKey = fdsKey;
        }

        public Class<? extends IHvacObject> getType() {
            switch (this) {
                case AIRCOIL: {
                    return HvacAircoil.class;
                }
                case FAN: {
                    return HvacFan.class;
                }
                case FILTER: {
                    return HvacFilter.class;
                }
                case LEAK: {
                    return HvacLeak.class;
                }
            }
            assert (false);
            return null;
        }

        public IHvacObject createNewComponent(String name) {
            switch (this) {
                case AIRCOIL: {
                    return new HvacAircoil(name);
                }
                case FAN: {
                    return new HvacFan(name);
                }
                case FILTER: {
                    return new HvacFilter(name);
                }
                case LEAK: {
                    return new HvacLeak(name);
                }
            }
            assert (false);
            return null;
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{AIRCOIL, FAN, FILTER, LEAK};
        }

        static {
            $VALUES = Type.$values();
        }
    }
}

