/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.commons.io.FilenameUtils;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.SimParams;
import pyrosim.gui.CloudFDSDlg;
import pyrosim.gui.MpiUtil;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.CloudFDSUtil;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.Win32;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.UncUtil;
import thunderheadeng.util.Win32Native;
import thunderheadeng.util.theUtil;

public class FDSRunMonitor
extends guiFrame {
    private static final long serialVersionUID = 5227479430480854756L;
    private static final Set<FDSRunMonitor> d_fdsRunningMonitors = new IdentityHashSet<FDSRunMonitor>();
    private static boolean killFDS = false;
    private static final int s_commPort;
    private static final Map<String, FDSRunMonitor> s_runningResultsMonitors;
    private JTextArea d_textArea;
    private JScrollPane d_textScrollPane;
    private JButton d_kill = new JButton(Intl.intl("Kill"));
    private JButton d_stop = new JButton(Intl.intl("Stop"));
    private guiCheckBox d_cbRunResults = new guiCheckBox(Intl.intl("Show results when finished"));
    private JButton d_bRunResults = new JButton(Intl.intl("Show Results"));
    private JButton d_bOpenResultsFolder = new JButton(Intl.intl("Open Folder"));
    private JButton d_bSaveLog = new JButton(Intl.intl("Save Log"));
    private String d_progressStr = Intl.intl("Progress") + ": ";
    private String d_timeRemStr = Intl.intl("Time Remaining") + ": ";
    private String d_ammtProgStr;
    private guiLabel d_progressLbl = new guiLabel(this.d_progressStr);
    private guiLabel d_timeRemLbl = new guiLabel(this.d_timeRemStr);
    private guiLabel d_timeElapsedLbl = new guiLabel(Intl.intl("Time Elapsed") + ": ");
    private guiLabel d_cloudStatusLbl = new guiLabel(Intl.intl("Simulation Status: "));
    private guiLabel d_ammtRemLbl;
    private guiLabel d_ammtElapsedLbl;
    private guiLabel d_ammtProgLbl;
    private HTMLLabel d_cloudStatusLinkLbl = new HTMLLabel("");
    private Set<MonitoredProcess> d_monitoredProcesses = Collections.synchronizedSet(new HashSet());
    private Process d_fdsProcess = null;
    private boolean d_endTime = false;
    private MonitoredProcess d_process = null;
    private static final String nl;
    private PyroMod d_mediator;
    private double d_startSimTime;
    private double d_endSimTime;
    private final String d_chid;
    private final File d_datafile;
    private final File d_smvFile;
    public static final int RESULTS_PREVIEW_MODE = 0;
    public static final int RESULTS_RUN_MODE = 1;
    public static final int FDS_RUN_MODE = 2;
    public static final int FDS_MPI_RUN_MODE = 3;
    private int d_mode = 2;
    private final ActionListener d_killAction;
    private final ActionListener d_stopAction;

    private static synchronized void setFDSRunning(FDSRunMonitor monitor, boolean running) {
        if (running) {
            d_fdsRunningMonitors.add(monitor);
        } else {
            d_fdsRunningMonitors.remove(monitor);
        }
    }

    public static synchronized boolean isFDSRunning() {
        return !d_fdsRunningMonitors.isEmpty();
    }

    protected static synchronized boolean isFDSRunning(FDSRunMonitor monitor) {
        return d_fdsRunningMonitors.contains(monitor);
    }

    public FDSRunMonitor(String title, String dataFilename) {
        super(title);
        File svfile;
        this.d_textArea = new JTextArea();
        this.d_textArea.setBackground(Color.WHITE);
        this.d_textScrollPane = new JScrollPane(this.d_textArea);
        this.d_mediator = ((PyroSim)Application.getApp()).getMediator();
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        AdjustmentListener scrollAdjust = new AdjustmentListener(this){
            boolean scrolledAway = false;
            int lastView = 0;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Adjustable adj = e.getAdjustable();
                int currView = adj.getValue() + adj.getVisibleAmount();
                int bottView = adj.getMaximum() - adj.getUnitIncrement();
                if (currView < this.lastView) {
                    this.scrolledAway = true;
                }
                if (currView >= bottView || !this.scrolledAway) {
                    SwingUtilities.invokeLater(() -> adj.setValue(adj.getMaximum()));
                    this.scrolledAway = false;
                }
                this.lastView = currView;
            }
        };
        this.d_textScrollPane.getVerticalScrollBar().addAdjustmentListener(scrollAdjust);
        this.d_startSimTime = 0.0;
        this.d_endSimTime = 1000.0;
        UnitDouble currentStartTime = this.d_mediator.getSimParams().getTime().getStartTime();
        UnitDouble currentStopTime = this.d_mediator.getSimParams().getTime().getStopTime();
        if (currentStartTime != null) {
            this.d_startSimTime = currentStartTime.getValue(SI.SECOND) * 1000.0;
        }
        if (currentStopTime != null) {
            this.d_endSimTime = currentStopTime.getValue(SI.SECOND) * 1000.0;
        }
        this.d_ammtProgStr = "0.0s / " + this.d_endSimTime / 1000.0 + "s";
        this.d_ammtRemLbl = new guiLabel("");
        this.d_ammtElapsedLbl = new guiLabel("0:00:00");
        this.d_ammtProgLbl = new guiLabel(this.d_ammtProgStr);
        ImageIcon ico = PyroGuiUtil.loadPyroSimIcon("run16.png");
        this.setIconImage(ico.getImage());
        Container mainPanel = this.getContentPane();
        mainPanel.setLayout(new GridBagLayout());
        this.d_killAction = evt -> this.killFDS();
        this.d_stopAction = evt -> this.gentleStop();
        this.d_kill.addActionListener(this.d_killAction);
        this.d_stop.addActionListener(this.d_stopAction);
        this.d_kill.setEnabled(false);
        this.d_stop.setEnabled(false);
        this.d_textArea.setEditable(false);
        this.d_textScrollPane.setAutoscrolls(true);
        this.d_cbRunResults.addActionListener(evt -> PyroPrefs.set(PyroPrefs.PREF_RUNSV, this.d_cbRunResults.isSelected(), true));
        this.d_datafile = new File(dataFilename);
        this.d_chid = FilenameUtils.removeExtension(this.d_datafile.getName());
        this.d_smvFile = svfile = new File(this.d_datafile.getParent(), this.d_chid + ".smv");
        this.d_bRunResults.addActionListener(evt -> {
            Thread t = new Thread(this::showResults);
            t.start();
        });
        this.d_bOpenResultsFolder.addActionListener(evt -> {
            try {
                Win32.openExplorerToFolder(this.d_datafile.getParentFile());
            }
            catch (Exception e) {
                guiUtil.showError(this, Intl.intl("Error in Open Folder"), Intl.intl("Operation Aborted"), (Throwable)e);
                e.printStackTrace();
            }
        });
        this.d_bSaveLog.addActionListener(evt -> this.saveLog());
        this.setSize(500, 500);
        this.setResizable(true);
        int row = 0;
        GridBagUtil.add(mainPanel, new FlashyHeader(), 0, row++, 6, 1, 12, 12, 0, 12, 0, 1.0, 0.0);
        GridBagUtil.add(mainPanel, this.d_textScrollPane, 0, row++, 6, 1, 12, 12, 0, 12, 1, 1.0, 1.0, 10);
        GridBagUtil.add(mainPanel, this.d_progressLbl, 0, row, 1, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_ammtProgLbl, 1, row++, 1, 1, 12, 6, 0, 12, 2, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_timeElapsedLbl, 0, row, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_ammtElapsedLbl, 1, row++, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_timeRemLbl, 0, row, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_ammtRemLbl, 1, row++, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_cloudStatusLbl, 0, row, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_cloudStatusLinkLbl, 1, row++, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_cbRunResults, 0, row++, 6, 1, 12, 0, 0, 0, 0, 0.0, 0.0, 10);
        this.d_cloudStatusLbl.setVisible(false);
        this.d_cloudStatusLinkLbl.setVisible(false);
        guiPanel buttonPanel = new guiPanel(new FlowLayout(1, 6, 0));
        buttonPanel.add(this.d_kill);
        buttonPanel.add(this.d_stop);
        buttonPanel.add(this.d_bRunResults);
        buttonPanel.add(this.d_bOpenResultsFolder);
        buttonPanel.add(this.d_bSaveLog);
        GridBagUtil.add(mainPanel, buttonPanel, 0, row++, 6, 1, 12, 0, 12, 0, 0, 0.0, 0.0, 10);
    }

    private void setMode(int mode) {
        this.d_mode = mode;
        if (this.d_mode == 0 || this.d_mode == 1) {
            this.d_bRunResults.setEnabled(false);
        }
    }

    private void showResults() {
        FDSRunMonitor.showResults(ResultsApp.RESULTS, this, this.d_smvFile);
    }

    public static void showResults(ResultsApp app, FDSRunMonitor monitor, File resultsFile) {
        try {
            FDSRunMonitor.showResults(app, resultsFile, monitor);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location specified for the Results executable is invalid.\nPlease specify a valid file by going to \"File->Preferences.\""), Intl.intl("Invalid Results Executable Specified"), 0);
        }
        catch (Throwable t) {
            guiUtil.showError(Application.getApp().getActiveFrame(), Intl.intl("Error While Showing Results"), Intl.intl("An error ocurred while attempting to show the results."), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showResults(ResultsApp app, File resultsFile, FDSRunMonitor existingMonitor) throws FileNotFoundException, Exception {
        MonitoredProcess process;
        FDSRunMonitor runner;
        String smvPath;
        String resultsExePath = app.getExePath();
        if (resultsExePath == null) {
            return -1;
        }
        String key = smvPath = resultsFile.getAbsolutePath();
        Map<String, FDSRunMonitor> map = s_runningResultsMonitors;
        synchronized (map) {
            String resultsLoc;
            if (app == ResultsApp.RESULTS && s_runningResultsMonitors.containsKey(key)) {
                FDSRunMonitor monitor = s_runningResultsMonitors.get(key);
                MonitoredProcess mp = null;
                Set<MonitoredProcess> set = monitor.d_monitoredProcesses;
                synchronized (set) {
                    for (MonitoredProcess proc2 : monitor.d_monitoredProcesses) {
                        if (!proc2.isConnected()) continue;
                        mp = proc2;
                        break;
                    }
                }
                if (mp != null) {
                    EventQueue.invokeLater(() -> monitor.toFront());
                    mp.allowSetForegroundWindow();
                    mp.run(ClientCommand.REFRESH);
                }
                return 0;
            }
            if (existingMonitor != null) {
                runner = existingMonitor;
            } else {
                runner = new FDSRunMonitor(Intl.intl("Results") + " - " + resultsFile.getName(), resultsFile.getAbsolutePath());
                runner.setMode(1);
                runner.loadValues();
                runner.setVisible(true);
                runner.setLocationRelativeTo(runner.getParentFrame());
            }
            if (System.getProperty("unc_disable") == null) {
                try {
                    String smvFilenameLocal = UncUtil.convertToLocal(smvPath);
                    File fSmvFilenameLocal = new File(smvFilenameLocal);
                    if (fSmvFilenameLocal.isFile()) {
                        smvPath = smvFilenameLocal;
                    } else {
                        System.err.printf("Error converting SMV filename: %s -> %s%n", smvPath, smvFilenameLocal);
                        System.err.printf("Error converting SMV filename: Using original filename.%n", new Object[0]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((resultsLoc = app.getExePath()) == null) {
                throw new FileNotFoundException();
            }
            if (!new File(resultsLoc).exists()) {
                throw new FileNotFoundException(resultsLoc);
            }
            File tempFile = new File(smvPath);
            int commId = FDSRunMonitor.newCommId();
            boolean isResults = app == ResultsApp.RESULTS;
            boolean openThroughSocket = isResults && s_commPort != -1 && PyroPrefs.getBoolean(PyroPrefs.RESULTS_OPEN_THROUGH_SOCKET);
            ArrayList<String> args = new ArrayList<String>();
            args.add(resultsLoc);
            if (!isResults) {
                args.add(smvPath);
            } else {
                if (Application.isVerbose()) {
                    args.add("-debug");
                }
                if (!openThroughSocket) {
                    args.add("-r");
                    args.add(smvPath);
                }
                args.add("-locale");
                args.add(Locale.getDefault().toString());
                JFrame mainFrame = PyroSim.getApp().getMainFrame();
                Point loc = mainFrame.getLocationOnScreen();
                Dimension size = (mainFrame.getExtendedState() & 6) == 6 ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : mainFrame.getSize();
                args.add("-x");
                args.add(Integer.toString(loc.x));
                args.add("-y");
                args.add(Integer.toString(loc.y));
                args.add("-w");
                args.add(Integer.toString(size.width));
                args.add("-h");
                args.add(Integer.toString(size.height));
                if (s_commPort != -1) {
                    args.add("-commport");
                    args.add(Integer.toString(s_commPort));
                    args.add("-commid");
                    args.add(Integer.toString(commId));
                }
            }
            Process p = Runtime.getRuntime().exec(theUtil.toArray(args, String.class), null, tempFile.getParentFile());
            process = runner.monitorProcess(p, commId, app.name, resultsLoc, TextMonitor.class);
            if (app == ResultsApp.RESULTS) {
                if (openThroughSocket) {
                    process.onConnect(proc -> {
                        proc.allowSetForegroundWindow();
                        proc.openFile(tempFile, runner.d_mode == 0);
                    });
                }
                s_runningResultsMonitors.put(key, runner);
            }
        }
        try {
            int exitCode = process.d_process.waitFor();
            runner.stopMonitoring(process);
            if ((runner.d_mode == 0 || runner.d_mode == 1) && exitCode == 0) {
                runner.setVisible(false);
            }
            int n = exitCode;
            return n;
        }
        finally {
            if (app == ResultsApp.RESULTS) {
                s_runningResultsMonitors.remove(key);
                System.out.println("done showing results");
            }
        }
    }

    public void previewResults(SimParams.OpenMp omp) {
        this.setMode(0);
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        OpenMpOptions ompOpts = new OpenMpOptions(omp.getOmpNumThreadsFlag(), omp.getOmpNumThreads(), omp.getOmpStacksizeFlag(), omp.getOmpStacksize());
        this.startFDSExecution(this.d_datafile.getAbsolutePath(), 1, GridProcessUtil.PROC_COUNT.ONE_PROC, ompOpts);
    }

    @Deprecated
    public void startFDS(OpenMpOptions omp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        this.setMode(2);
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        this.startFDSExecution(this.d_datafile.getAbsolutePath(), 1, GridProcessUtil.PROC_COUNT.ONE_PROC, omp);
    }

    private Component getParentFrame() {
        return Application.getApp() != null ? Application.getApp().getMainFrame() : null;
    }

    public void startFDSmpi(int numEnabledMeshes, GridProcessUtil.PROC_COUNT processAllocRule, OpenMpOptions omp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        this.setMode(3);
        ImageIcon ico = PyroGuiUtil.loadPyroSimIcon("runparallel16.png");
        this.setIconImage(ico.getImage());
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        String fdsInputFile = this.d_datafile.getAbsolutePath();
        this.startFDSExecution(fdsInputFile, numEnabledMeshes, processAllocRule, omp);
    }

    public void startClusterFDS(Map<String, Integer> hostMap, int numGrids, File simulatorExe, OpenMpOptions omp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        ImageIcon ico = PyroGuiUtil.loadPyroSimIcon("runcluster.png");
        this.setIconImage(ico.getImage());
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        this.startClusterFDSExecution(hostMap, this.d_datafile.getAbsolutePath(), simulatorExe, omp);
    }

    public void startCloudFDS(CloudFDSDlg.CFD_FEA_Params params, FDSRenderer.Filenames filenames, File outFile) {
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        this.configureCloudFDSRun();
        this.startCloudFDSExecution(params, filenames, outFile);
    }

    public void saveLog() {
        guiJFXFileChooser chooser = new guiJFXFileChooser("log.txt", PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_TEXT);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(f));
            writer.print(this.d_textArea.getText());
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Intl.intl("An unknown error occurred trying to write the file."), Intl.intl("Error Writing File"), 0);
        }
    }

    @Override
    public boolean close() {
        if (FDSRunMonitor.isFDSRunning(this)) {
            String msg = Intl.intl("Close and terminate FDS simulation?");
            String title = Intl.intl("Simulation in Progress");
            int options = 2;
            if (JOptionPane.showConfirmDialog(this, msg, title, 2) != 0) {
                return false;
            }
            this.killFDS();
        }
        return super.close();
    }

    public void loadValues() {
        if (this.d_mode == 0) {
            this.d_cbRunResults.setSelected(true);
            return;
        }
        boolean runSV = PyroPrefs.getBoolean(PyroPrefs.PREF_RUNSV);
        this.d_cbRunResults.setSelected(runSV);
    }

    private void startFDSExecution(String dataFilename, int numEnabledMeshes, GridProcessUtil.PROC_COUNT processAllocRule, OpenMpOptions omp) {
        File stop = this.getStopFile();
        if (stop.exists()) {
            stop.delete();
        }
        int exitCode = this.runFDS(dataFilename, numEnabledMeshes, processAllocRule, omp);
        System.out.println("FDS Exit Code: " + exitCode);
        if (killFDS) {
            killFDS = false;
        } else if (!this.getStopFile().exists() && exitCode == 0 && this.d_cbRunResults.isSelected()) {
            this.showResults();
        }
    }

    private void startClusterFDSExecution(Map<String, Integer> hostMap, String dataFilename, File simulatorExe, OpenMpOptions omp) {
        File stop = this.getStopFile();
        if (stop.exists()) {
            stop.delete();
        }
        int exitCode = this.runClusterFDS(hostMap, dataFilename, simulatorExe, omp);
        System.out.println("FDS Exit Code: " + exitCode);
        if (killFDS) {
            killFDS = false;
        } else if (!this.getStopFile().exists() && exitCode == 0 && this.d_cbRunResults.isSelected()) {
            this.showResults();
        }
    }

    private void startCloudFDSExecution(CloudFDSDlg.CFD_FEA_Params params, FDSRenderer.Filenames filenames, File outFile) {
        String uploadFolder;
        String folderName = CloudFDSUtil.getFolderName(outFile);
        try {
            this.setCloudFDSStatus(Intl.intl("Starting..."));
            this.println(Intl.intl("Uploading FDS input file"));
            String uploadFolder2 = CloudFDSUtil.getUploadLocation(outFile, folderName, params);
            CloudFDSUtil.uploadFile(uploadFolder2, outFile);
        }
        catch (Exception e) {
            String message = Intl.intl("FDS input file failed to upload");
            this.setCloudFDSStatus(Intl.intl("Failed..."));
            this.println(message);
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), message, 0);
            return;
        }
        try {
            this.println(Intl.intl("Uploading PyroSim Floor file"));
            File pyroFloors = new File(filenames.dir, filenames.floors);
            uploadFolder = CloudFDSUtil.getUploadLocation(pyroFloors, folderName, params);
            CloudFDSUtil.uploadFile(uploadFolder, pyroFloors);
        }
        catch (Exception e) {
            String message = Intl.intl("PyroSim Floors failed to upload");
            this.setCloudFDSStatus(Intl.intl("Failed..."));
            this.println(message);
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), message, 0);
            return;
        }
        try {
            this.println(Intl.intl("Uploading PyroSim Geometry file"));
            File pyroGeom = new File(filenames.dir, filenames.geom);
            uploadFolder = CloudFDSUtil.getUploadLocation(pyroGeom, folderName, params);
            CloudFDSUtil.uploadFile(uploadFolder, pyroGeom);
        }
        catch (Exception e) {
            String message = Intl.intl("PyroSim Geometry failed to upload");
            this.setCloudFDSStatus(Intl.intl("Failed..."));
            this.println(message);
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), message, 0);
            return;
        }
        try {
            this.println(Intl.intl("Starting service"));
            int id = CloudFDSUtil.startSim(folderName, params);
            String simulationLink = String.format("https://cloud.cfdfeaservice.it/en/simulation/view/%1$d", id);
            this.println(String.format(Intl.intl("Simulation %1$d started, for simulation status visit:\n" + simulationLink + "\nSimulation will continue after closing this window or PyroSim."), id));
            this.setCloudFDSStatus(String.format("<a href=%1$s>%1$s</a>", simulationLink));
            this.configureCloudFDSActions(evt -> CloudFDSUtil.stopSim(params, id, true), evt -> CloudFDSUtil.stopSim(params, id, false));
        }
        catch (Exception e) {
            String message = Intl.intl("Simulation failed to start");
            this.setCloudFDSStatus(Intl.intl("Failed..."));
            this.println(message);
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), message, 0);
        }
    }

    private int runFDS(String dataFilename, int enabledMeshCount, GridProcessUtil.PROC_COUNT processAllocRule, OpenMpOptions omp) {
        String fdsLocation = PyroPrefs.getFDSLocation();
        String runfdsLocation = PyroPrefs.getRunFDSLocation();
        String mpiexecLocation = PyroPrefs.getMPIExecLocation();
        File fdsExeFile = new File(fdsLocation);
        File fdsOpenMPExeFile = new File(String.format("%s\\fds_openmp.exe", fdsExeFile.getParent()));
        if (!fdsOpenMPExeFile.exists()) {
            fdsOpenMPExeFile = fdsExeFile;
        }
        if (!fdsExeFile.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS_MPI File Specified"), 0);
            return -1;
        }
        File runfdsFile = new File(runfdsLocation);
        if (!runfdsFile.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (runfds.exe)."), Intl.intl("Error Launching FDS"), 0);
            return -1;
        }
        File mpiexecFile = new File(mpiexecLocation);
        if (!mpiexecFile.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (mpiexec.exe)."), Intl.intl("Error Launching FDS"), 0);
            return -1;
        }
        String envPath = MpiUtil.buildEnvPath("", runfdsFile.getParent(), mpiexecFile.getParent(), fdsExeFile.getParent(), System.getenv("WINDIR"), System.getenv("WINDIR") + "\\system32");
        File inputFileObj = new File(dataFilename);
        File workingDir = inputFileObj.getParentFile();
        int numProcs = MpiUtil.getNumProcs(processAllocRule, enabledMeshCount);
        int numThreads = MpiUtil.getNumOpenMPThreads(omp);
        String fdsExeArg = theUtil.equal(runfdsFile.getParent(), fdsExeFile.getParent()) ? (numThreads == 1 ? fdsExeFile.getName() : fdsOpenMPExeFile.getName()) : (numThreads == 1 ? fdsExeFile.getPath() : fdsOpenMPExeFile.getPath());
        List<String> argsList = Arrays.asList(runfdsFile.getPath(), mpiexecFile.getName(), "-localonly", "-n", Integer.toString(numProcs), fdsExeArg, inputFileObj.getName());
        if (!this.isVisible()) {
            System.out.println("launch aborted, run monitor dialog closed");
            return -1;
        }
        try {
            System.out.println();
            FDSRunMonitor.setFDSRunning(this, true);
            ProcessBuilder pBuilder = new ProcessBuilder(argsList);
            MpiUtil.scrubEnvMpi(pBuilder.environment());
            pBuilder.directory(workingDir);
            pBuilder.environment().putAll(MpiUtil.getMpiEnvEx(omp));
            pBuilder.environment().put("PATH", envPath);
            this.println("ENV:  " + String.valueOf(pBuilder.environment()));
            this.println("CMD:  " + MpiUtil.buildCmdStr(pBuilder.command()));
            this.println("WDIR: " + String.valueOf(pBuilder.directory()));
            System.out.println("ENV:  " + String.valueOf(pBuilder.environment()));
            System.out.println("CMD:  " + MpiUtil.buildCmdStr(pBuilder.command()));
            System.out.println("WDIR: " + String.valueOf(pBuilder.directory()));
            Process p = pBuilder.start();
            MonitoredProcess mp = this.monitorProcess(p, FDSRunMonitor.newCommId(), "FDS", fdsLocation, FDSTextMonitor.class);
            this.d_fdsProcess = p;
            this.d_kill.setEnabled(true);
            this.d_stop.setEnabled(true);
            int code = p.waitFor();
            this.d_kill.setEnabled(false);
            this.d_stop.setEnabled(false);
            FDSRunMonitor.setFDSRunning(this, false);
            this.stopMonitoring(mp);
            this.d_fdsProcess = null;
            return code;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run FDS."), Intl.intl("Error While Executing FDS"), 0);
            return -1;
        }
    }

    private int runClusterFDS(Map<String, Integer> hostMap, String dataFilename, File simulatorExe, OpenMpOptions omp) {
        File mpiexecLocation = new File(PyroPrefs.getMPIExecLocation());
        if (System.getProperties().containsKey("cluster_mpiexec")) {
            mpiexecLocation = new File(System.getProperty("cluster_mpiexec"));
        }
        File runfdsFile = new File(PyroPrefs.getRunFDSLocation());
        if (simulatorExe == null) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS File Specified"), 0);
            return -1;
        }
        System.out.println("testing hydra service...");
        int hydraRunning = MpiUtil.testHydraServiceReady(this, mpiexecLocation);
        if (hydraRunning != 0) {
            return -1;
        }
        System.out.println("hydra service ready");
        System.out.println("testing mpi credentials...");
        if (!MpiUtil.mpiAuth(this, mpiexecLocation)) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cluster FDS was unable to start processes on this computer."), Intl.intl("MPI Error"), 0);
            return -1;
        }
        System.out.println("credentials verified");
        if (!simulatorExe.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS_MPI has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS_MPI File Specified"), 0);
            return -1;
        }
        if (!mpiexecLocation.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (mpiexec.exe)."), Intl.intl("Error Launching FDS"), 0);
            return -1;
        }
        String uncWorkingFolder = this.d_datafile.getParent();
        if (System.getProperty("unc_disable") == null) {
            try {
                uncWorkingFolder = UncUtil.convertToUnc(uncWorkingFolder);
            }
            catch (Throwable t) {
                t.printStackTrace();
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Unable to convert FDS file to UNC format."));
                return -1;
            }
        }
        String envPath = MpiUtil.buildEnvPath("", runfdsFile.getParent(), mpiexecLocation.getParent(), simulatorExe.getParent(), System.getenv("WINDIR"), System.getenv("WINDIR") + "\\system32");
        ArrayList<String> args = new ArrayList<String>();
        args.add(runfdsFile.getPath());
        args.add(mpiexecLocation.getPath());
        if (System.getProperties().containsKey("debugcluster")) {
            System.out.println("[debugcluster] Adding -v arg to mpiexec.");
            args.add("-v");
        }
        if (System.getProperties().containsKey("cluster_delegate")) {
            System.out.println("[cluster_delegate] Adding -delegate arg to mpiexec.");
            args.add("-delegate");
        }
        args.add("-genvnone");
        args.add("-gwdir");
        args.add(uncWorkingFolder);
        args.add("-genv");
        args.add("PATH");
        args.add(envPath);
        if (System.getProperty("I_MPI_WAIT_MODE") != null) {
            args.add("-genv");
            args.add("I_MPI_WAIT_MODE");
            args.add(System.getProperty("I_MPI_WAIT_MODE"));
        } else {
            args.add("-genv");
            args.add("I_MPI_WAIT_MODE");
            args.add("1");
        }
        if (omp.numThreadsFlag) {
            args.add("-genv");
            args.add("OMP_NUM_THREADS");
            args.add(omp.numThreads);
        }
        if (omp.stacksizeFlag) {
            args.add("-genv");
            args.add("OMP_STACKSIZE");
            args.add(omp.stacksize);
        }
        String fdsExeArg = theUtil.equal(runfdsFile.getParent(), simulatorExe.getParent()) ? simulatorExe.getName() : simulatorExe.getPath();
        Set<String> hostSet = hostMap.keySet();
        Iterator<String> iter = hostSet.iterator();
        while (iter.hasNext()) {
            String host = iter.next();
            args.add("-host");
            args.add(host);
            args.add("-n");
            args.add(hostMap.get(host).toString());
            args.add(fdsExeArg);
            args.add(this.d_datafile.getName());
            if (!iter.hasNext()) continue;
            args.add(":");
        }
        if (!this.isVisible()) {
            System.out.println("fds cluster launch aborted, run monitor dialog closed");
            return -1;
        }
        try {
            FDSRunMonitor.setFDSRunning(this, true);
            ProcessBuilder pBuilder = new ProcessBuilder(args);
            MpiUtil.scrubEnvMpi(pBuilder.environment());
            pBuilder.directory(new File(uncWorkingFolder));
            pBuilder.environment().put("PATH", envPath);
            this.println("ENV:  " + String.valueOf(pBuilder.environment()));
            this.println("CMD:  " + MpiUtil.buildCmdStr(pBuilder.command()));
            this.println("WDIR: " + String.valueOf(pBuilder.directory()));
            System.out.println("ENV:  " + String.valueOf(pBuilder.environment()));
            System.out.println("CMD:  " + MpiUtil.buildCmdStr(pBuilder.command()));
            System.out.println("WDIR: " + String.valueOf(pBuilder.directory()));
            Process p = pBuilder.start();
            MonitoredProcess mp = this.monitorProcess(p, FDSRunMonitor.newCommId(), "FDS", simulatorExe.getName(), FDSTextMonitor.class);
            this.d_fdsProcess = p;
            this.d_kill.setEnabled(true);
            this.d_stop.setEnabled(true);
            int code = p.waitFor();
            this.d_kill.setEnabled(false);
            this.d_stop.setEnabled(false);
            FDSRunMonitor.setFDSRunning(this, false);
            this.stopMonitoring(mp);
            this.d_fdsProcess = null;
            return code;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run FDS."), Intl.intl("Error While Executing FDS"), 0);
            return -1;
        }
    }

    private MonitoredProcess monitorProcess(Process runningProcess, int commId, String name, String location, Class<? extends TextMonitor> monitorType) {
        TextMonitor errorMonitor;
        TextMonitor outputMonitor;
        try {
            Constructor<? extends TextMonitor> constructor = monitorType.getConstructor(FDSRunMonitor.class, InputStream.class, Color.class, Boolean.TYPE);
            boolean print = this.d_process == null;
            outputMonitor = constructor.newInstance(this, runningProcess.getInputStream(), Color.BLUE, print);
            errorMonitor = constructor.newInstance(this, runningProcess.getErrorStream(), Color.RED, print);
            outputMonitor.startMonitoring();
            errorMonitor.startMonitoring();
        }
        catch (Exception e) {
            e.printStackTrace();
            assert (false);
            errorMonitor = null;
            outputMonitor = null;
        }
        MonitoredProcess mp = new MonitoredProcess(runningProcess, commId, outputMonitor, errorMonitor, new ProcessDestroyer());
        this.d_monitoredProcesses.add(mp);
        if (this.d_process == null) {
            this.d_process = mp;
        }
        return mp;
    }

    private static int newCommId() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public void killFDS() {
        killFDS = true;
        if (this.d_fdsProcess == null) {
            return;
        }
        try {
            this.d_fdsProcess.getOutputStream().write(3);
            this.d_fdsProcess.getOutputStream().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getStopFile() {
        File dir = this.d_datafile.getParentFile();
        String stopFn = this.d_chid + ".stop";
        return new File(dir, stopFn);
    }

    public void gentleStop() {
        this.beginWaitCursor();
        try {
            final ProgressMonitor pm = new ProgressMonitor(this, "Stopping FDS Run", "", 0, 2);
            pm.setProgress(0);
            pm.setMillisToDecideToPopup(0);
            pm.setMillisToPopup(0);
            final SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() throws Exception {
                    FDSRunMonitor.this.getStopFile().createNewFile();
                    this.setProgress(1);
                    FDSRunMonitor.this.d_fdsProcess.waitFor();
                    this.setProgress(2);
                    return null;
                }

                @Override
                public void done() {
                    pm.setProgress(0);
                    pm.close();
                }
            };
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress" == evt.getPropertyName()) {
                        if (pm.isCanceled()) {
                            worker.cancel(true);
                            FDSRunMonitor.this.getStopFile().delete();
                        } else {
                            int progress = (Integer)evt.getNewValue();
                            pm.setProgress(progress);
                        }
                    }
                }
            });
            worker.execute();
        }
        catch (Exception e) {
            this.endWaitCursor();
            return;
        }
        this.endWaitCursor();
    }

    @Override
    public void beginWaitCursor() {
        this.getRootPane().setEnabled(false);
        super.beginWaitCursor();
    }

    @Override
    public void endWaitCursor() {
        super.endWaitCursor();
        this.getRootPane().setEnabled(true);
    }

    private void stopMonitoring(MonitoredProcess mp) {
        this.d_monitoredProcesses.remove(mp);
        if (this.d_process == mp) {
            this.d_process = null;
        }
        mp.close();
    }

    private void configureCloudFDSActions(ActionListener cloudKill, ActionListener cloudStop) {
        this.d_kill.setEnabled(true);
        this.d_stop.setEnabled(true);
        this.d_kill.removeActionListener(this.d_killAction);
        this.d_stop.removeActionListener(this.d_stopAction);
        this.d_kill.addActionListener(cloudKill);
        this.d_stop.addActionListener(cloudStop);
    }

    private void configureCloudFDSRun() {
        this.d_cbRunResults.setVisible(false);
        this.d_bRunResults.setVisible(false);
        this.d_timeElapsedLbl.setVisible(false);
        this.d_ammtElapsedLbl.setVisible(false);
        this.d_progressLbl.setVisible(false);
        this.d_ammtProgLbl.setVisible(false);
        this.d_timeRemLbl.setVisible(false);
        this.d_ammtRemLbl.setVisible(false);
        this.d_cloudStatusLbl.setVisible(true);
        this.d_cloudStatusLinkLbl.setVisible(true);
    }

    private void setCloudFDSStatus(String statusLink) {
        this.d_cloudStatusLinkLbl.setText(statusLink);
    }

    public static boolean redirectStream(OutputStream outStream, InputStream inStream) {
        try {
            InputStreamReader readStream = new InputStreamReader(inStream);
            BufferedReader reader = new BufferedReader(readStream);
            PrintWriter writer = new PrintWriter(outStream);
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void println(String text) {
        this.print(text);
        this.print(nl);
    }

    public void print(String text) {
        this.d_textArea.append(text);
    }

    static {
        s_runningResultsMonitors = Collections.synchronizedMap(new HashMap());
        ClientListener clientListener = new ClientListener();
        s_commPort = clientListener.getCommPort();
        if (s_commPort != -1) {
            new Thread(clientListener).start();
        }
        nl = System.getProperty("line.separator");
    }

    private static class MonitoredProcess {
        public final Process d_process;
        public final Thread destroyer;
        public final TextMonitor d_outputMonitor;
        public final TextMonitor d_errorMonitor;
        public final int commId;
        public Socket resultsSocket;
        public DataOutputStream out;
        public DataInputStream in;
        public List<Consumer<MonitoredProcess>> onConnect;

        public MonitoredProcess(Process p, int commId, TextMonitor outputMonitor, TextMonitor errorMonitor, Thread destroyer) {
            this.d_process = p;
            this.d_outputMonitor = outputMonitor;
            this.d_errorMonitor = errorMonitor;
            this.commId = commId;
            this.destroyer = destroyer;
            this.onConnect = new ArrayList<Consumer<MonitoredProcess>>();
            Runtime.getRuntime().addShutdownHook(destroyer);
        }

        public synchronized boolean isConnected() {
            return this.resultsSocket != null;
        }

        public synchronized void onConnect(Consumer<MonitoredProcess> func) {
            if (this.resultsSocket != null) {
                func.accept(this);
            } else {
                this.onConnect.add(func);
            }
        }

        public synchronized boolean connect(Socket resultsSocket) {
            if (this.resultsSocket != null) {
                return false;
            }
            try {
                this.out = new DataOutputStream(new BufferedOutputStream(resultsSocket.getOutputStream()));
                this.in = new DataInputStream(resultsSocket.getInputStream());
                this.resultsSocket = resultsSocket;
                for (Consumer<MonitoredProcess> proc : this.onConnect) {
                    proc.accept(this);
                }
                this.onConnect.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.out = null;
                this.in = null;
                return false;
            }
            return true;
        }

        public synchronized void close() {
            if (this.destroyer.getState() == Thread.State.NEW) {
                Runtime.getRuntime().removeShutdownHook(this.destroyer);
            }
            if (this.d_errorMonitor != null) {
                this.d_errorMonitor.stopMonitoring();
            }
            if (this.d_outputMonitor != null) {
                this.d_outputMonitor.stopMonitoring();
            }
            if (this.resultsSocket != null) {
                try {
                    this.resultsSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.resultsSocket = null;
                this.out = null;
                this.in = null;
            }
        }

        public synchronized void run(ClientCommand method) {
            if (this.resultsSocket == null) {
                return;
            }
            try {
                this.out.writeInt(method.id);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public synchronized void openFile(File file, boolean preview) {
            if (this.resultsSocket == null) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            try {
                ClientCommand command = preview ? ClientCommand.PREVIEW_RESULTS : ClientCommand.LOAD_RESULTS;
                this.out.writeInt(command.id);
                this.out.writeUTF(file.getPath());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public synchronized Integer call(ClientCommand method) {
            if (this.resultsSocket == null) {
                return null;
            }
            try {
                this.out.writeInt(method.id);
                this.out.flush();
                return this.in.readInt();
            }
            catch (IOException e) {
                return null;
            }
        }

        public void allowSetForegroundWindow() {
            Integer pid = this.call(ClientCommand.GET_PID);
            if (pid != null) {
                Win32Native.allowSetForegroundWindow(pid);
            }
        }
    }

    private class FlashyHeader
    extends JPanel {
        private static final long serialVersionUID = -4104573031898867922L;

        public FlashyHeader() {
            super(new GridBagLayout());
            ImageIcon fdsLogo = new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/fds_dlg_logo.gif"));
            JLabel logo = new JLabel(fdsLogo);
            logo.setBorder(BorderFactory.createRaisedBevelBorder());
            guiLabel header = new guiLabel("<html><b>Fire Dynamics Simulator (FDS)</b>");
            guiLabel middle = new guiLabel("NIST Engineering Laboratory");
            guiLabel under = new guiLabel("National Institute of Standards and Technology (NIST)");
            GridBagUtil.add(this, logo, 0, 0, 1, 5, 0, 0, 0, 0);
            GridBagUtil.add(this, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0);
            GridBagUtil.add(this, header, 1, 1, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, middle, 1, 2, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, under, 1, 3, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, Box.createGlue(), 1, 4, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0);
        }
    }

    public static final class ResultsApp
    extends Enum<ResultsApp> {
        public static final /* enum */ ResultsApp SMOKEVIEW = new ResultsApp("Smokeview");
        public static final /* enum */ ResultsApp RESULTS = new ResultsApp("Results");
        public final String name;
        private static final /* synthetic */ ResultsApp[] $VALUES;

        public static ResultsApp[] values() {
            return (ResultsApp[])$VALUES.clone();
        }

        public static ResultsApp valueOf(String name) {
            return Enum.valueOf(ResultsApp.class, name);
        }

        private ResultsApp(String name) {
            this.name = name;
        }

        public String getExePath() {
            switch (this) {
                case SMOKEVIEW: {
                    return PyroPrefs.getSmokeviewLocation();
                }
                case RESULTS: {
                    return PyroPrefs.getResultsLocation();
                }
            }
            assert (false);
            return null;
        }

        private static /* synthetic */ ResultsApp[] $values() {
            return new ResultsApp[]{SMOKEVIEW, RESULTS};
        }

        static {
            $VALUES = ResultsApp.$values();
        }
    }

    private static enum ClientCommand {
        REFRESH(0),
        GET_PID(1),
        LOAD_RESULTS(2),
        PREVIEW_RESULTS(3);

        public final int id;

        private ClientCommand(int id) {
            this.id = id;
        }
    }

    public class TextMonitor
    extends Thread {
        private InputStream d_stream;
        protected volatile boolean d_running = true;
        private boolean d_print;

        public TextMonitor(InputStream stream, Color textColor, boolean print) {
            this.d_stream = stream;
            this.d_print = print;
        }

        public void startMonitoring() {
            this.d_running = true;
            this.start();
        }

        public void stopMonitoring() {
        }

        public boolean isRunning() {
            return this.d_running;
        }

        protected void parseLine(String line) {
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader inputReader = new InputStreamReader(this.d_stream);
                BufferedReader bufferedInput = new BufferedReader(inputReader);
                while ((line = bufferedInput.readLine()) != null) {
                    if (this.d_print) {
                        FDSRunMonitor.this.println(line);
                    }
                    this.parseLine(line);
                }
                if (this.d_print) {
                    FDSRunMonitor.this.println("");
                }
                this.d_running = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class OpenMpOptions {
        public final boolean numThreadsFlag;
        public final String numThreads;
        public final boolean stacksizeFlag;
        public final String stacksize;

        public OpenMpOptions(boolean numThreadsFlag, String numThreads, boolean stacksizeFlag, String stacksize) {
            this.numThreadsFlag = numThreadsFlag;
            this.numThreads = numThreads;
            this.stacksizeFlag = stacksizeFlag;
            this.stacksize = stacksize;
        }
    }

    public class FDSTextMonitor
    extends TextMonitor
    implements ActionListener {
        private long d_remainingTime;
        private int d_timeElapsed;
        private StringTokenizer d_token;
        private long d_startTime;
        private long d_checkTime;
        private long d_prevTime;
        private double d_requiredTotal;
        private double d_required;
        private double d_prevSimTime;
        private double d_currentSimTime;

        public FDSTextMonitor(InputStream stream, Color textColor, boolean print) {
            super(stream, textColor, print);
            this.d_prevTime = this.d_startTime = System.currentTimeMillis();
            this.d_requiredTotal = 0.0;
            this.d_prevSimTime = 0.0;
            this.d_timeElapsed = 0;
            new Timer(1000, this).start();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String displayText;
            long mins;
            long hrs;
            long tempTime;
            if (this.d_remainingTime >= 0L) {
                tempTime = this.d_remainingTime--;
                hrs = tempTime / 3600L;
                tempTime -= hrs * 3600L;
                if ((tempTime -= (mins = tempTime / 60L) * 60L) < 0L) {
                    tempTime = 0L;
                }
                displayText = hrs + ":";
                displayText = mins >= 10L ? displayText + mins + ":" : displayText + "0" + mins + ":";
                displayText = tempTime >= 10L ? displayText + tempTime : displayText + "0" + tempTime;
                FDSRunMonitor.this.d_ammtRemLbl.setText(displayText);
            }
            if (!FDSRunMonitor.this.d_endTime) {
                tempTime = this.d_timeElapsed++;
                hrs = tempTime / 3600L;
                mins = (tempTime -= hrs * 3600L) / 60L;
                displayText = hrs + ":";
                displayText = mins >= 10L ? displayText + mins + ":" : displayText + "0" + mins + ":";
                displayText = tempTime >= 10L ? displayText + tempTime : displayText + "0" + (tempTime -= mins * 60L);
                FDSRunMonitor.this.d_ammtElapsedLbl.setText(displayText);
            }
        }

        @Override
        public void stopMonitoring() {
            this.d_running = false;
            FDSRunMonitor.this.d_endTime = true;
            this.d_remainingTime = 0L;
        }

        @Override
        protected void parseLine(String line) {
            this.d_token = new StringTokenizer(line, ",\t s:");
            if (this.d_token.hasMoreTokens()) {
                String check = this.d_token.nextToken();
                if (check.equals("Time")) {
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    try {
                        this.d_checkTime = System.currentTimeMillis();
                        this.d_currentSimTime = Double.valueOf(this.d_token.nextToken()) * 1000.0;
                        long clockTime = this.d_checkTime - this.d_prevTime;
                        double simTimeLength = FDSRunMonitor.this.d_endSimTime - FDSRunMonitor.this.d_startSimTime;
                        FDSRunMonitor.this.d_ammtProgStr = this.d_currentSimTime / 1000.0 + "s / " + FDSRunMonitor.this.d_endSimTime / 1000.0 + "s";
                        FDSRunMonitor.this.d_ammtProgLbl.setText(FDSRunMonitor.this.d_ammtProgStr);
                        this.d_requiredTotal = this.d_required = (double)clockTime * simTimeLength / (this.d_currentSimTime - this.d_prevSimTime);
                        this.d_remainingTime = (long)((this.d_requiredTotal - (double)(this.d_checkTime - this.d_startTime)) / 1000.0);
                        this.d_prevSimTime = this.d_currentSimTime;
                        this.d_prevTime = this.d_checkTime;
                    }
                    catch (Exception i) {
                        System.out.println("Line in incorrect format\n" + line);
                    }
                } else if (check.equals("STOP")) {
                    FDSRunMonitor.this.d_endTime = true;
                }
            }
        }
    }

    private class ProcessDestroyer
    extends Thread {
        private ProcessDestroyer() {
        }

        @Override
        public void run() {
            FDSRunMonitor.this.killFDS();
        }
    }

    private static class ClientListener
    implements Runnable {
        private final int d_commPort;
        private final ServerSocket d_serverSkt;

        public ClientListener() {
            ServerSocket serverSkt = null;
            int commPort = -1;
            try {
                serverSkt = new ServerSocket(0, 0, InetAddress.getByName(null));
                commPort = serverSkt.getLocalPort();
            }
            catch (IOException e) {
                System.err.println("[0x23489f] Failed creating a ServerSocket for results refreshing.");
                e.printStackTrace();
            }
            this.d_serverSkt = serverSkt;
            this.d_commPort = commPort;
        }

        public int getCommPort() {
            return this.d_commPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean connectToProcess(int commId, Socket clientSkt) throws Exception {
            Map<String, FDSRunMonitor> map = s_runningResultsMonitors;
            synchronized (map) {
                for (FDSRunMonitor monitor : s_runningResultsMonitors.values()) {
                    Set<MonitoredProcess> set = monitor.d_monitoredProcesses;
                    synchronized (set) {
                        for (MonitoredProcess proc : monitor.d_monitoredProcesses) {
                            if (proc.commId != commId || !proc.connect(clientSkt)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket clientSkt = this.d_serverSkt.accept();
                        DataInputStream din = new DataInputStream(clientSkt.getInputStream());
                        int commId = din.readInt();
                        this.connectToProcess(commId, clientSkt);
                    }
                }
                catch (Exception e) {
                    System.err.println("[0x6723f] Failed trying to accept a results client. Trying again in 1 second.");
                    e.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
    }
}

