/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.Grid;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UncUtil;

public class ClusterFDSDlg
extends guiDialog {
    private static final long serialVersionUID = 2262726238112569914L;
    private final List<Grid> d_grids;
    private final guiTextField d_locationTF;
    private final JButton d_locationBtn;
    private final guiTableEditor d_tableEditor;
    private final guiTable d_table;
    private File d_outFile;

    public ClusterFDSDlg(JFrame owner, List<Grid> grids, PyroMod pymod) {
        super((Window)owner, Intl.intl("Cluster FDS Parameters"), 9);
        this.d_grids = grids;
        GridBagHelper gb = new GridBagHelper(this.getDialogPane(), true);
        this.d_locationTF = new guiTextField();
        this.d_locationTF.setEditable(false);
        this.d_locationTF.setColumns(30);
        this.d_locationBtn = new JButton(PyroGuiUtil.loadTeciIcon("Open16.gif"));
        this.d_locationBtn.setToolTipText(Intl.intl("Click to save FDS file."));
        this.d_locationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                guiJFXFileChooser chooser = new guiJFXFileChooser(ClusterFDSDlg.this.d_outFile != null ? ClusterFDSDlg.this.d_outFile.getName() : null, ClusterFDSDlg.this.d_outFile != null ? ClusterFDSDlg.this.d_outFile.getAbsolutePath() : null, null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_FDS6);
                File f = chooser.showOpenDialog();
                if (f == null) {
                    return;
                }
                ClusterFDSDlg.this.d_outFile = f;
                if (System.getProperty("unc_disable") == null) {
                    try {
                        ClusterFDSDlg.this.d_outFile = new File(UncUtil.convertToUnc(f.getAbsolutePath()));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                ClusterFDSDlg.this.d_locationTF.setText(ClusterFDSDlg.this.d_outFile.getAbsolutePath());
                System.out.println(ClusterFDSDlg.this.d_outFile.getPath());
            }
        });
        guiLabel noteLbl = new guiLabel(Intl.intl("Note: FDS file should be saved in a shared location"));
        String[] columnHeaders = new String[]{Intl.intl("Host"), Intl.intl("Number of Processes"), Intl.intl("Assigned Meshes")};
        this.d_tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(columnHeaders, new Class[]{String.class, Integer.class, String.class}), 0);
        this.d_table = this.d_tableEditor.getTable();
        this.d_table.setColumnEditable(2, false);
        this.d_table.setNullValuesAllowed(false);
        guiTextField numMeshTF = new guiTextField();
        numMeshTF.setEditable(false);
        numMeshTF.setText(Integer.toString(this.d_grids.size()));
        guiTextField localHostTF = new guiTextField();
        localHostTF.setEditable(false);
        guiLabel localHostLbl = null;
        try {
            String localHost = this.getHostname();
            localHostTF.setText(localHost);
            localHostLbl = new guiLabel(Intl.intl("Local Host:"));
        }
        catch (IOException localHost) {
            // empty catch block
        }
        gb.addRow(Intl.intl("FDS File Location:"), this.d_locationTF, 1.0, 2, this.d_locationBtn);
        gb.addRow(noteLbl, 0);
        gb.addRow(this.d_tableEditor, new double[]{1.0, 1.0}, 0);
        if (localHostLbl != null) {
            gb.addRow(localHostLbl, 2, localHostTF);
        }
        gb.addRow(Intl.intl("Number of meshes: "), 2, numMeshTF);
        gb.finalizeRows();
        this.d_table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() < 2) {
                    ClusterFDSDlg.this.updateAssignedMeshes();
                }
            }
        });
        this.setResizable(true);
        this.setHostsToTable(this.getHostsFromPrefs());
        this.d_table.autoSizeColumns(100);
        this.updateAssignedMeshes();
        FDSClusterOptions opts = pymod.getClusterOptions();
        if (opts != null && opts.hasFileChanged) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int answer = JOptionPane.showConfirmDialog(ClusterFDSDlg.this, Intl.intl("Update FDS file location to match new save location?"), Intl.intl("PSM File Moved"), 0);
                    if (answer == 0) {
                        PyroSim app = (PyroSim)Application.getApp();
                        PyroMod pyMod = app.getMediator();
                        String chid = FDSRenderer.generateChid(app.getFilename(), FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios()));
                        ClusterFDSDlg.this.d_outFile = new File(chid + ".fds");
                        if (System.getProperty("unc_disable") == null) {
                            try {
                                ClusterFDSDlg.this.d_outFile = new File(UncUtil.convertToUnc(ClusterFDSDlg.this.d_outFile.getAbsolutePath()));
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        ClusterFDSDlg.this.d_locationTF.setText(ClusterFDSDlg.this.d_outFile.toString());
                    }
                }
            });
        }
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            this.saveHostsToPrefs(this.getHostsFromTable());
        }
        return result;
    }

    private List<Pair<String, Integer>> getHostsFromPrefs() {
        int numHosts = PyroPrefs.getInt(PyroPrefs.PREF_CLUSTER_NUMHOSTS);
        ArrayList<Pair<String, Integer>> hosts = new ArrayList<Pair<String, Integer>>(numHosts);
        for (int i = 0; i < numHosts; ++i) {
            String hostKey = "mpi_host_" + i;
            String procKey = "mpi_proc_" + i;
            String host = PyroPrefs.instance().getString(hostKey, null);
            int num = PyroPrefs.instance().getInt(procKey, -1);
            if (host == null || num < 0) continue;
            hosts.add(new Pair<String, Integer>(host, num));
        }
        return hosts;
    }

    private void saveHostsToPrefs(List<Pair<String, Integer>> hosts) {
        PyroPrefs.set(PyroPrefs.PREF_CLUSTER_NUMHOSTS, hosts.size(), true);
        int i = 0;
        for (Pair<String, Integer> host : hosts) {
            String hostKey = "mpi_host_" + i;
            String procKey = "mpi_proc_" + i;
            PyroPrefs.instance().set(hostKey, host.v1);
            PyroPrefs.instance().set(procKey, host.v2);
            ++i;
        }
    }

    private List<Pair<String, Integer>> getHostsFromTable() {
        ArrayList<Pair<String, Integer>> hosts = new ArrayList<Pair<String, Integer>>();
        TableModel tm = this.d_table.getModel();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            Integer count = (Integer)this.d_table.getValueAt(i, 1);
            String host = (String)this.d_table.getValueAt(i, 0);
            if (host != null) {
                host = host.toLowerCase();
            }
            hosts.add(new Pair<String, Integer>(host, count));
        }
        return hosts;
    }

    private void setHostsToTable(List<Pair<String, Integer>> hosts) {
        guiDefaultTableModel tm = (guiDefaultTableModel)this.d_table.getModel();
        tm.setRowCount(hosts.size());
        for (int row = 0; row < hosts.size(); ++row) {
            Pair<String, Integer> host = hosts.get(row);
            tm.setValueAt(host.v1, row, 0);
            tm.setValueAt(host.v2, row, 1);
        }
    }

    private Map<String, List<Grid>> getMeshAssignments() {
        if (this.d_grids.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        List<Pair<String, Integer>> hosts = this.getHostsFromTable();
        ArrayList<Pair<String, ArrayList<Object>>> assignments = new ArrayList<Pair<String, ArrayList<Object>>>();
        String firstHost = null;
        ArrayDeque<Grid> remainingGrids = new ArrayDeque<Grid>(this.d_grids);
        for (Pair<String, Integer> host : hosts) {
            String string = (String)host.v1;
            if (firstHost == null) {
                firstHost = string;
            }
            Integer numProcs = (Integer)host.v2;
            if (string == null || numProcs == null || numProcs <= 0) continue;
            ArrayList<Grid> grids = new ArrayList<Grid>();
            for (int n = 0; n < numProcs && !remainingGrids.isEmpty(); ++n) {
                Grid grid = (Grid)remainingGrids.removeFirst();
                grids.add(grid);
            }
            if (grids.isEmpty()) continue;
            assignments.add(new Pair(string, grids));
        }
        if (!remainingGrids.isEmpty()) {
            if (!assignments.isEmpty()) {
                ((List)((Pair)assignments.get((int)(assignments.size() - 1))).v2).addAll(remainingGrids);
            } else if (firstHost != null) {
                assignments.add(new Pair<String, ArrayList<Grid>>(firstHost, new ArrayList<Grid>(this.d_grids)));
            }
        }
        LinkedHashMap<String, List<Grid>> result = new LinkedHashMap<String, List<Grid>>();
        for (Pair pair : assignments) {
            result.put((String)pair.v1, (List)pair.v2);
        }
        return result;
    }

    private void updateAssignedMeshes() {
        Map<String, List<Grid>> assignments = this.getMeshAssignments();
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        for (int m = 0; m < model.getRowCount(); ++m) {
            String host = (String)model.getValueAt(m, 0);
            Object meshStr = "";
            if (host != null && assignments.containsKey(host)) {
                List<Grid> grids = assignments.get(host);
                for (Grid grid : grids) {
                    if (!((String)meshStr).isEmpty()) {
                        meshStr = (String)meshStr + "; ";
                    }
                    meshStr = (String)meshStr + grid.getName();
                }
            }
            model.setValueAt(meshStr, m, 2);
        }
    }

    public void setFDSFile(File fileName) {
        this.d_outFile = fileName;
        if (System.getProperty("unc_disable") == null) {
            try {
                this.d_outFile = new File(UncUtil.convertToUnc(this.d_outFile.getAbsolutePath()));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.d_locationTF.setText(this.d_outFile.getAbsolutePath());
    }

    public File getOutFile() {
        return this.d_outFile;
    }

    public Map<String, Integer> getHosts() {
        List<Pair<String, Integer>> hostsList = this.getHostsFromTable();
        LinkedHashMap<String, Integer> hosts = new LinkedHashMap<String, Integer>(hostsList.size());
        for (Pair<String, Integer> host : hostsList) {
            hosts.put((String)host.v1, (Integer)host.v2);
        }
        return hosts;
    }

    public void setHosts(Map<String, Integer> hosts) {
        Map<String, Integer> current = this.getHosts();
        LinkedHashMap<String, Integer> allHosts = new LinkedHashMap<String, Integer>();
        for (String hostName : current.keySet()) {
            allHosts.put(hostName, 0);
        }
        allHosts.putAll(hosts);
        ArrayList<Pair<String, Integer>> hostsList = new ArrayList<Pair<String, Integer>>(allHosts.size());
        for (Map.Entry host : allHosts.entrySet()) {
            hostsList.add(new Pair(host.getKey(), host.getValue()));
        }
        this.setHostsToTable(hostsList);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        List<Pair<String, Integer>> hosts = this.getHostsFromTable();
        if (hosts.isEmpty()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("Enter at least one host."));
            }
            return false;
        }
        for (Pair<String, Integer> pair : hosts) {
            if ((Integer)pair.v2 >= 0) continue;
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("The number of processes must be positive."));
            }
            return false;
        }
        HashSet<String> encounteredNames = new HashSet<String>();
        for (Pair<String, Integer> pair : hosts) {
            if (encounteredNames.add((String)pair.v1)) continue;
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("Duplicate host names"));
            }
            return false;
        }
        try {
            String string = this.getHostname();
            String string2 = this.d_outFile.getAbsolutePath();
            if (!string2.startsWith("\\\\") && (hosts.size() > 1 || hosts.size() == 1 && !((String)hosts.get((int)0).v1).equalsIgnoreCase(string))) {
                int sel;
                String errorMsg = null;
                if (!UncUtil.isShared(string2)) {
                    errorMsg = Intl.intl("FDS file may not be visible to other hosts.\nWould you like to continue with the chosen path?");
                }
                if (errorMsg != null && showWarn && (sel = JOptionPane.showConfirmDialog(this, errorMsg, Intl.intl("Warning"), 0, 2)) != 0) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println(Intl.intl("Error validating FDS output folder."));
            throwable.printStackTrace();
        }
        return true;
    }

    private String getHostname() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getHostName();
        return hostname;
    }
}

