/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.apache.http.HttpException;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.gui.actions.CloudFDSUtil;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.SearchField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;

public class CloudFDSJobsDlg
extends guiDialog {
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 500;

    public CloudFDSJobsDlg(JFrame owner, ArrayList<CloudFDSJob> jobs) {
        super((Window)owner, Intl.intl("Cloud FDS Jobs"), 1);
        guiPanel panel = this.getDialogPane();
        guiPanel listPanel = new guiPanel();
        JScrollPane scrollPane = new JScrollPane(listPanel);
        SearchField<Component> searchField = new SearchField<Component>(() -> Arrays.stream(listPanel.getComponents()), c -> ((CloudFDSJobPanel)c).getJob().name);
        searchField.addObserver((o, e) -> {
            for (Component c : listPanel.getComponents()) {
                c.setVisible(searchField.getFilter().test(c));
            }
        });
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        panel.setLayout(new BoxLayout(panel, 1));
        searchField.setMaximumSize(new Dimension(400, 25));
        searchField.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        for (CloudFDSJob job : jobs) {
            listPanel.add(new CloudFDSJobPanel(job));
        }
        panel.add(searchField);
        panel.add(scrollPane);
        this.setSize(400, 500);
        EventQueue.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
    }

    public static class CloudFDSJob {
        public static final String FDS_EXT = ".fds_";
        public final String name;
        public final String folder;
        public final CloudFDSUtil.FDS_FEA_STATUS status;
        public final String viewURL;
        public final long id;

        public CloudFDSJob(String folder, long id, CloudFDSUtil.FDS_FEA_STATUS status) {
            int extensionIndex = folder.lastIndexOf(FDS_EXT);
            String modelName = folder;
            if (extensionIndex > 0) {
                modelName = folder.substring(0, extensionIndex);
            }
            this.name = String.format("%s (%d)", modelName, id);
            this.status = status;
            this.id = id;
            this.folder = folder;
            this.viewURL = String.format("%s/en/simulation/view/%d", CloudFDSUtil.CLOUD_PROVIDERS.CFD_FEA.URI, id);
        }
    }

    private static class CloudFDSJobPanel
    extends guiPanel {
        public final HTMLLabel nameLbl;
        public final guiLabel statusLbl;
        public final JButton downloadBtn;
        public final CloudFDSJob job;

        public CloudFDSJobPanel(CloudFDSJob j) {
            this.job = j;
            this.nameLbl = new HTMLLabel(String.format("<a href=%s/>%s</a>", this.job.viewURL, this.job.name));
            this.statusLbl = new guiLabel(this.job.status.name());
            this.downloadBtn = new JButton(Intl.intl("Download..."));
            this.statusLbl.setOpaque(true);
            this.downloadBtn.setEnabled(this.job.status == CloudFDSUtil.FDS_FEA_STATUS.COMPLETED || this.job.status == CloudFDSUtil.FDS_FEA_STATUS.STOPPED);
            this.downloadBtn.addActionListener(l -> ForkJoinPool.commonPool().execute(() -> {
                this.getWaitCursorMgr().beginWaitCursor();
                this.downloadBtn.setEnabled(false);
                try {
                    JSONObject result = CloudFDSUtil.getSimulationResults(this.job.folder);
                    if (result == null) {
                        throw new NullPointerException();
                    }
                    JSONObject error = (JSONObject)result.get("error");
                    if (error != null) {
                        long code = (Long)error.get("code");
                        String message = (String)error.get("message");
                        throw new HttpException(code + " - " + message);
                    }
                    long id = (Long)result.get("id");
                    JSONObject download = CloudFDSUtil.getDownloadMetadata(id);
                    String url = (String)download.get("url");
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (Exception e) {
                    guiUtil.showError(this, Intl.intl("Error While Downloading Results"), Intl.intl("An error occured while downloading results for " + this.job.name + "."), (Throwable)e);
                }
                finally {
                    this.getWaitCursorMgr().endWaitCursor();
                    this.downloadBtn.setEnabled(true);
                }
            }));
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.nameLbl);
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(this.statusLbl);
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(this.downloadBtn);
            this.setBorder(BorderFactory.createEtchedBorder(0));
            this.setMaximumSize(new Dimension(400, 25));
        }

        public CloudFDSJob getJob() {
            return this.job;
        }
    }
}

