/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PropertyObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.view.ViewMode;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;

public class View
extends PropertyObject {
    static final long serialVersionUID = 1L;
    public static final int MAX_CLIP_PLANES = 4;
    public static final List<ChildProp<? extends IPyroObject>> CHILD_PROPS = new ArrayList<ChildProp<? extends IPyroObject>>();
    private static final IPropertySet.Prop<Set<ClipPlane>> PROP_CLIP_PLANES = new IPropertySet.Prop<Set>(5002, Collections.EMPTY_SET);
    public static final IPropertySet.Prop<CameraState> PROP_CAMERA = new ChildProp<Object>(5004, null);
    public static final IPropertySet.Prop<SectionBox> PROP_SECTION_BOX = new ChildProp<Object>(5003, null);
    public static final IPropertySet.Prop<NavTool> PROP_NAV_TOOL = new IPropertySet.Prop<NavTool>(5005, NavTool.SELECT);
    public static final Set<IPropertySet.Prop<?>> ALL_PROPS = Sets.fromArrayHS(PROP_SECTION_BOX, PROP_CAMERA, PROP_NAV_TOOL);

    public View(String name) {
        super(name);
    }

    @Override
    public View clone() {
        View clone = (View)super.clone();
        for (ChildProp<? extends IPyroObject> cprop : CHILD_PROPS) {
            IPyroObject cval = this.get(cprop);
            if (cval == null) continue;
            IPyroObject newVal = (IPyroObject)cval.clone();
            clone.removeFromProps(cprop);
            clone.setToProps(cprop, newVal);
        }
        return clone;
    }

    private <T> void removeFromProps(IPropertySet.Prop<T> prop) {
        super.remove(prop);
    }

    private <T> void setToProps(IPropertySet.Prop<T> prop, T val) {
        super.set(prop, val);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof View && super.equals(obj);
    }

    @Override
    public <T> T set(IPropertySet.Prop<T> prop, T value) {
        this.pauseUpdates();
        T old = super.set(prop, value);
        if (prop instanceof ChildProp && old != value) {
            if (old != null) {
                this.removeChild((IPyroObject)old);
            }
            if (value != null) {
                this.addChild((IPyroObject)value);
            }
        }
        this.resumeUpdates();
        return old;
    }

    @Override
    public <T> T remove(IPropertySet.Prop<T> prop) {
        this.pauseUpdates();
        T old = super.remove(prop);
        if (prop instanceof ChildProp && old != null) {
            this.removeChild((IPyroObject)old);
        }
        this.resumeUpdates();
        return old;
    }

    protected void addChild(IPyroObject obj) {
        obj.setDomain((PyroMod)this.getDomain(), this);
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
    }

    protected void removeChild(IPyroObject obj) {
        obj.setDomain(null, this);
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
    }

    public boolean isDefinedClipPlanes() {
        return this.isDefined(PROP_CLIP_PLANES);
    }

    public void addClipPlane(ClipPlane plane) {
        Set<ClipPlane> planes = this.get(PROP_CLIP_PLANES);
        if (planes.contains(plane)) {
            return;
        }
        if (planes.isEmpty()) {
            planes = new LinkedIdentityHashSet<ClipPlane>();
            planes.add(plane);
            this.set(PROP_CLIP_PLANES, planes);
        } else {
            planes.add(plane);
        }
        this.addChild(plane);
    }

    public void removeClipPlane(ClipPlane plane) {
        Set<ClipPlane> planes = this.get(PROP_CLIP_PLANES);
        if (!planes.remove(plane)) {
            return;
        }
        if (planes.isEmpty()) {
            this.remove(PROP_CLIP_PLANES);
        }
        this.removeChild(plane);
    }

    public Set<ClipPlane> getClipPlanes() {
        return this.get(PROP_CLIP_PLANES);
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        Set<ClipPlane> clipPlanes = this.getClipPlanes();
        ArrayList<IPyroObject> members = new ArrayList<IPyroObject>(clipPlanes.size());
        members.addAll(clipPlanes);
        for (ChildProp<? extends IPyroObject> cprop : CHILD_PROPS) {
            IPyroObject child = this.get(cprop);
            if (child == null) continue;
            members.add(child);
        }
        return members;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public Optional<ViewMode> getViewMode() {
        CameraState cs = this.get(PROP_CAMERA);
        if (cs == null) {
            return Optional.empty();
        }
        return Optional.of(cs.getViewMode());
    }

    public static boolean isCamChanged(PyroMod mediator, Events events) {
        if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED) || events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW)) {
            return true;
        }
        View aview = mediator.getViews().getActiveView();
        if (events.getEvents(View.class, new Class[0]).getChangedObjs(PROP_CAMERA).contains(aview)) {
            return true;
        }
        IEventRecord<CameraState> activeCamEvts = events.getEvents(CameraState.class, new Class[0]).filter(cs -> cs.getParent() == aview);
        return activeCamEvts.hasChangedObjs(EventChannel.EVT_GENERAL, PyroMod.EVT_PARENT_CHANGED) || activeCamEvts.hasAddedObjs();
    }

    public static class ChildProp<T extends IPyroObject>
    extends IPropertySet.Prop<T> {
        public ChildProp(Object key, T defVal) {
            super(key, defVal);
            CHILD_PROPS.add(this);
        }
    }

    public static enum NavTool {
        SELECT,
        PAN,
        ZOOM,
        ZOOM_BOX,
        ORBIT,
        ROAM;

    }
}

