/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroDataContainer;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theTimer;

public abstract class TransformTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private List<IGeomNode> d_oldGeom = null;
    private Task d_copyTask = null;
    private final int d_n;

    public abstract ITransform getXFormForIteration(int var1);

    public TransformTask(PyroMod pyMod, Collection<? extends IPyroObject> objs, int numCopies) {
        this.d_mediator = pyMod;
        this.d_objs = new ArrayList<IPyroObject>(objs);
        this.d_n = numCopies;
    }

    @Override
    public int getEst() {
        return 1;
    }

    private static String generateName(INamed obj, int copyIx) {
        return obj.getName() + "[" + (copyIx + 1) + "]";
    }

    private void runCopyTask() {
        if (this.d_copyTask != null) {
            this.d_copyTask.run();
            return;
        }
        theTimer timer = new theTimer();
        System.out.print("Transforming/Copying...");
        CompositeTask<PyroMod> copies = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<IPyroObject> selObjs = new ArrayList<IPyroObject>();
        selObjs.addAll(this.d_objs);
        for (int i = 0; i < this.d_n; ++i) {
            TransformInfo ti = this.getXFormForIteration(i + 1).getInfo();
            try {
                ObjectSelection copy = Actions.copyObjects(this.d_mediator, this.d_objs, true, Actions.PYRO_DATA_FLAVOR);
                PyroDataContainer data = (PyroDataContainer)copy.getTransferData(Actions.PYRO_DATA_FLAVOR);
                Collection<? extends IPyroObject> copiedObjs = data.getObjects();
                Map<IPyroObject, IPyroObject> copyMap = TransformTask.getCopyMap(this.d_objs, copiedObjs);
                for (IPyroGeomSrc newObject : Hierarchy.flatten(copiedObjs, IPyroGeomSrc.class)) {
                    IGeomNode node = newObject.getGeom();
                    newObject.setGeom(node.transform(ti));
                }
                Task task = Actions.taskPasteObjects((PyroMod)this.d_mediator, data.getObjects(), (String)"", (int)0, (Actions.IPasteCallback)new PasteCallback(copyMap)).task;
                copies.addTask(task);
                selObjs.addAll(data.getObjects());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        double time = timer.curr();
        System.out.printf("done (%g s)%n", time);
        SelectTask wrapper = new SelectTask(this.d_mediator, selObjs);
        wrapper.addTask(copies);
        this.d_copyTask = wrapper;
        this.d_copyTask.run();
    }

    private static Map<IPyroObject, IPyroObject> getCopyMap(Collection<? extends IPyroObject> originalObjs, Collection<? extends IPyroObject> copiedObjs) {
        assert (copiedObjs.size() >= originalObjs.size());
        IdentityHashMap<IPyroObject, IPyroObject> copyMap = new IdentityHashMap<IPyroObject, IPyroObject>();
        Iterator<? extends IPyroObject> copyit = copiedObjs.iterator();
        Iterator<? extends IPyroObject> objit = originalObjs.iterator();
        while (objit.hasNext()) {
            copyMap.put(copyit.next(), objit.next());
        }
        return copyMap;
    }

    private boolean isKeyedByName(Object o) {
        return Util.isKeyedByName(this.d_mediator, o);
    }

    private void undoCopyTask() {
        assert (this.d_copyTask != null);
        this.d_copyTask.undo();
    }

    private void runMoveTask() {
        Collection<IPyroGeomSrc> geoms = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        if (this.d_oldGeom == null) {
            this.d_oldGeom = new ArrayList<IGeomNode>(geoms.size());
            for (IPyroGeomSrc obj : geoms) {
                this.d_oldGeom.add(obj.getGeom());
            }
        }
        TransformInfo xform = this.getXFormForIteration(1).getInfo();
        for (IPyroGeomSrc o : geoms) {
            IGeomNode newGeom = o.getGeom().transform(xform);
            o.setGeom(newGeom);
        }
    }

    private void undoMoveTask() {
        assert (this.d_oldGeom != null);
        int ix = 0;
        Collection<IPyroGeomSrc> geoms = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        for (IPyroGeomSrc o : geoms) {
            o.setGeom(this.d_oldGeom.get(ix++));
        }
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.runMoveTask();
        } else {
            this.runCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.undoMoveTask();
        } else {
            this.undoCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    private static class PasteCallback
    extends Actions.APasteCallback {
        private final Map<IPyroObject, IPyroObject> d_copyMap;

        public PasteCallback(Map<IPyroObject, IPyroObject> copyMap) {
            super(new Object[0]);
            this.d_copyMap = copyMap;
        }

        @Override
        public Actions.PasteOverwrite getReplaceModelObject(IPyroObject modelObj, IPyroObject pasteObj) throws CancellationException {
            return Actions.PasteOverwrite.KEEP_EXISTING;
        }

        @Override
        public Object getPasteLocation(PyroMod pasteMod, Object pasteObj) {
            IPyroObject parent;
            IPyroObject original = this.d_copyMap.get(pasteObj);
            if (original != null && TVEntryPoints.ep(parent = original.getParent()).canPaste(pasteMod, parent, pasteObj)) {
                return parent;
            }
            return super.getPasteLocation(pasteMod, pasteObj);
        }

        @Override
        public List<Reaction> getActiveReactions(Collection<Reaction> oldReactions, Map<Reaction, Actions.PasteCommand> newReactions, List<Reaction> oldActives) throws CancellationException {
            return oldActives;
        }
    }
}

