/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class RotateTask
extends TransformTask {
    private final Point3d d_base;
    private final Vector3d d_rotateAxis;
    private final double d_angle;

    public RotateTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitPoint3D base, Vector3d rotateAxis, UnitDouble angle) {
        super(mediator, objects, n);
        this.d_base = base.getPoint3dValue(Geometry.LU);
        this.d_rotateAxis = new Vector3d(rotateAxis);
        this.d_angle = angle.getValue(SI.RADIAN);
    }

    @Override
    public ITransform getXFormForIteration(int i) {
        double angle = this.d_angle * (double)i;
        ITransform xform = TransformUtil.translate(this.d_base.x, this.d_base.y, this.d_base.z);
        xform = xform.concatenate(TransformUtil.rotate(this.d_rotateAxis.x, this.d_rotateAxis.y, this.d_rotateAxis.z, angle));
        xform = xform.concatenate(TransformUtil.translate(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return xform;
    }
}

