/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pyrosim.Intl;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.scenario.Scenario;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class EditScenariosEditor
implements IEditor<Scenario> {
    private final guiPanel d_rootPanel = new guiPanel(new GridBagLayout());
    private final JTextArea d_descriptionArea = new JTextArea(5, 0);
    private final guiTextField d_scenarioName;
    private final JTextArea d_objsArea;

    public EditScenariosEditor() {
        this.d_descriptionArea.setLineWrap(true);
        this.d_descriptionArea.setWrapStyleWord(true);
        this.d_descriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                EditScenariosEditor.this.d_rootPanel.setModified(true);
            }
        });
        this.d_scenarioName = new guiTextField();
        this.d_scenarioName.setEditable(false);
        this.d_objsArea = new JTextArea(5, 0);
        this.d_objsArea.setEditable(false);
        GridBagHelper gbh = new GridBagHelper(this.d_rootPanel);
        gbh.addRow(Intl.intl("Scenario ID:"), this.d_scenarioName, 100.0, 2);
        gbh.addFilledRow(new TitleSeparator(Intl.intl("Description:")));
        gbh.addFilledRow(new JScrollPane(this.d_descriptionArea));
        gbh.addFilledRow(new TitleSeparator(Intl.intl("Disabled Objects")));
        gbh.addFilledRow(new JScrollPane(this.d_objsArea));
        gbh.addFilledRow(Box.createHorizontalStrut(300));
        gbh.finalizeRows();
    }

    @Override
    public void init(Scenario dataObj) {
        this.d_scenarioName.setValue(dataObj.getName());
        this.d_descriptionArea.setText(dataObj.getDescription());
        this.d_descriptionArea.setCaretPosition(0);
        List<String> paths = this.getScenarioObjectPaths(dataObj);
        this.d_objsArea.setText(String.join((CharSequence)"\n", paths));
        this.d_objsArea.setCaretPosition(0);
        this.getEditorPanel().setModified(false);
    }

    private List<String> getScenarioObjectPaths(Scenario dataObj) {
        ArrayList<String> paths = new ArrayList<String>();
        for (IPyroObject obj : dataObj.getDisabledObjs()) {
            StringBuffer sb = new StringBuffer();
            IPyroObject[] path = Hierarchy.getPath(obj);
            for (int i = 1; i < path.length; ++i) {
                TVEntryPoint<IPyroObject> ep;
                String name;
                IPyroObject pathObj = path[i];
                if (i > 1) {
                    sb.append("/");
                }
                if ((name = (ep = TVEntryPoints.ep(pathObj)).getDisplayName(pathObj)) != null) {
                    sb.append(name);
                    continue;
                }
                sb.append(pathObj.getClass().getName());
            }
            paths.add(sb.toString());
        }
        Collections.sort(paths);
        return paths;
    }

    @Override
    public Scenario commit(Scenario dataObj) {
        dataObj.setDescription(this.d_descriptionArea.getText());
        this.d_rootPanel.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this.d_rootPanel;
    }

    @Override
    public boolean isModified() {
        return this.d_rootPanel.isModified();
    }

    @Override
    public void addObserver(Observer o) {
        this.d_rootPanel.addObserver(o);
    }

    @Override
    public void removeObserver(Observer o) {
        this.d_rootPanel.removeObserver(o);
    }
}

