/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.Grid;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class StatGeom {

    public static class LinearVolumeArrayGeom
    extends LinearArrayGeom
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final Point3d d_delta;

        public LinearVolumeArrayGeom(Point3d p1, Point3d p2, Point3d delta, int numPoints) {
            super(p1, p2, numPoints);
            this.d_delta = delta;
        }

        public Point3d getDelta() {
            return this.d_delta;
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            super.generateManipHandles(handle -> handles.accept(new LinearArrayGeom.Handle(this, seg -> new LinearVolumeArrayGeom(seg.p1, seg.p2, this.d_delta, this.d_numPoints), (IHandle)handle)));
        }
    }

    public static class LinearPointArrayGeom
    extends LinearArrayGeom
    implements Serializable {
        static final long serialVersionUID = 1L;

        public LinearPointArrayGeom(Point3d p1, Point3d p2, int numPoints) {
            super(p1, p2, numPoints);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            super.generateManipHandles(handle -> handles.accept(new LinearArrayGeom.Handle(this, seg -> new LinearPointArrayGeom(seg.p1, seg.p2, this.d_numPoints), (IHandle)handle)));
        }
    }

    public static class LinearArrayGeom
    extends LineSeg
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int d_numPoints;

        public LinearArrayGeom(Point3d p1, Point3d p2, int numPoints) {
            super(p1, p2);
            this.d_numPoints = numPoints;
        }

        protected static class Handle
        implements IHandle {
            private LinearArrayGeom d_geom;
            private Function<LineSeg, LinearArrayGeom> d_geomBuilder;
            private IHandle d_lineSegHandle;

            public Handle(LinearArrayGeom geom, Function<LineSeg, LinearArrayGeom> geomBuilder, IHandle handle) {
                this.d_geom = geom;
                this.d_lineSegHandle = handle;
                this.d_geomBuilder = geomBuilder;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof Handle;
            }

            @Override
            public IGeomNode getGeom() {
                return this.d_lineSegHandle.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.d_lineSegHandle.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.d_lineSegHandle.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.d_lineSegHandle.begin(handleLoc, constraint);
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                Object handleMod = this.d_lineSegHandle.modify(newLoc);
                if (handleMod instanceof LineSeg) {
                    LineSeg seg = (LineSeg)handleMod;
                    this.d_geom = this.d_geomBuilder.apply(seg);
                }
                return this.d_geom;
            }

            @Override
            public Object end() {
                Object handleEnd = this.d_lineSegHandle.end();
                if (handleEnd instanceof LineSeg) {
                    LineSeg seg = (LineSeg)handleEnd;
                    this.d_geom = this.d_geomBuilder.apply(seg);
                }
                return this.d_geom;
            }
        }
    }

    public static class GridGeom
    implements IGeom,
    Serializable {
        static final long serialVersionUID = 1L;
        public final Grid grid;

        public GridGeom(Grid grid) {
            this.grid = grid;
        }

        public int hashCode() {
            return this.grid.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GridGeom && ((GridGeom)obj).grid.equals(this.grid);
        }

        protected AABoxGeom toBox() {
            if (this.grid != null) {
                return new AABoxGeom(this.grid.getGeom().getBoundingBox(new AABox()));
            }
            return new AABoxGeom(new AABox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.toBox());
            return prims;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.grid.getGeom().getBoundingBox(new AABox());
        }

        @Override
        public int getNumPrims(int types) {
            if ((types & 1) != 0) {
                return 6;
            }
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return theUtil.iterate((byte)1, 6 - offset);
        }

        @Override
        public boolean isShell() {
            return Boolean.FALSE;
        }

        @Override
        public IGeom optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.NONE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.NONE;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return true;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            return this;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            this.toBox().pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
            this.toBox().pickBox(source, visFaceEdges, filter, region, isects);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
            this.toBox().find(test, result);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            this.toBox().getAll(result);
        }
    }
}

