/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.INamed;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;

public class PlanarSlice
extends Slice
implements INamed {
    static final long serialVersionUID = 1L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private int d_plane;
    private UnitDouble d_location;

    public PlanarSlice(int plane, UnitDouble location, IQuantity measurement, boolean includeFlowVector, boolean cellCentered, String name) {
        super(measurement, includeFlowVector, cellCentered, PlanarSlice.getDefaultName(plane, location, measurement));
        if (name != null) {
            this.setName(name);
        }
        this.d_plane = plane;
        this.d_location = location;
    }

    public PlanarSlice(int plane, UnitDouble location, IQuantity measurement, boolean includeFlowVector, boolean cellCentered) {
        super(measurement, includeFlowVector, cellCentered, PlanarSlice.getDefaultName(plane, location, measurement));
        this.d_plane = plane;
        this.d_location = location;
    }

    public PlanarSlice(PlanarSurface geom, IQuantity quantity, boolean includeFlowVector, boolean cellCentered, String name) {
        super(quantity, includeFlowVector, cellCentered, name);
        Pair<Integer, UnitDouble> plane = PlanarSlice.convert(geom.plane);
        this.d_plane = (Integer)plane.v1;
        this.d_location = (UnitDouble)plane.v2;
    }

    public int getPlane() {
        return this.d_plane;
    }

    public UnitDouble getLocation() {
        return this.d_location;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlanarSlice rec = (PlanarSlice)obj;
        return super.equals(rec) && this.d_plane == rec.d_plane && this.d_location.equals(rec.d_location);
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private static Pair<Integer, UnitDouble> convert(Plane3d plane) {
        Vector3d adir;
        Vector3d normal = plane.getNormal();
        int axis = Util3D.getClosestAxis(normal);
        int saxis = switch (axis) {
            case 0 -> {
                adir = GeomConstants.VEC3D_XPOS;
                yield 0;
            }
            case 1 -> {
                adir = GeomConstants.VEC3D_YPOS;
                yield 1;
            }
            default -> {
                adir = GeomConstants.VEC3D_ZPOS;
                yield 2;
            }
        };
        double val = adir.dot(normal) < 0.0 ? plane.w : -plane.w;
        return new Pair<Integer, UnitDouble>(saxis, new UnitDouble(val, Geometry.LU));
    }

    @Override
    public IGeom getSliceGeom() {
        PyroMod domain = (PyroMod)this.getDomain();
        if (domain == null) {
            domain = PyroSim.getApp().getMediator();
        }
        List grids = domain != null ? domain.getGridManager().flatten() : Collections.EMPTY_LIST;
        return new SliceGeom(this.d_plane, this.d_location.getValue(Geometry.LU), grids);
    }

    @Override
    public void setGeom(IGeom geom) {
        if (geom instanceof SliceGeom) {
            SliceGeom sg = (SliceGeom)geom;
            this.d_plane = sg.plane;
            this.d_location = new UnitDouble(sg.loc, Geometry.LU);
            this.changedEvt(new Object[0]);
        } else if (geom instanceof PlanarSurface) {
            PlanarSurface ps = (PlanarSurface)geom;
            Pair<Integer, UnitDouble> plane = PlanarSlice.convert(ps.plane);
            this.d_plane = (Integer)plane.v1;
            this.d_location = (UnitDouble)plane.v2;
            this.changedEvt(new Object[0]);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isSetNameSupported() {
        return true;
    }

    public String getDefaultName() {
        return PlanarSlice.getDefaultName(this.getPlane(), this.getLocation(), this.getQuantity());
    }

    public static String getDefaultName(int plane, UnitDouble location, IQuantity quantity) {
        Object defaultName = "";
        switch (plane) {
            case 0: {
                defaultName = Intl.intl("X");
                break;
            }
            case 1: {
                defaultName = Intl.intl("Y");
                break;
            }
            case 2: {
                defaultName = Intl.intl("Z");
            }
        }
        defaultName = (String)defaultName + " = " + Global.format(location);
        defaultName = (String)defaultName + ": " + quantity.getDescription();
        return defaultName;
    }

    public static class SliceGeom
    extends GeomGroup {
        private static final long serialVersionUID = -4738852155242983374L;
        public final Collection<? extends Grid> grids;
        public final int plane;
        public final double loc;

        public SliceGeom(int plane, double loc, Collection<? extends Grid> grids) {
            this(SliceGeom.getQuads(plane, loc, grids), plane, loc, grids);
        }

        private SliceGeom(List<? extends IGeom> quads, int plane, double loc, Collection<? extends Grid> grids) {
            super(quads);
            this.plane = plane;
            this.loc = loc;
            this.grids = grids;
        }

        private static List<AARectangle> getQuads(int plane, double loc, Collection<? extends Grid> grids) {
            ArrayList<AARectangle> quads = new ArrayList<AARectangle>();
            for (Grid grid : grids) {
                AABox bounds = grid.getGeom().getBoundingBox(new AABox());
                switch (plane) {
                    case 0: {
                        if (!(bounds.getMinX() <= loc) || !(loc <= bounds.getMaxX())) break;
                        quads.add(new AARectangle(0, loc, bounds.getMinY(), bounds.getMinZ(), bounds.getMaxY(), bounds.getMaxZ(), false));
                        break;
                    }
                    case 1: {
                        if (!(bounds.getMinY() <= loc) || !(loc <= bounds.getMaxY())) break;
                        quads.add(new AARectangle(1, loc, bounds.getMinX(), bounds.getMinZ(), bounds.getMaxX(), bounds.getMaxZ(), false));
                        break;
                    }
                    case 2: {
                        if (!(bounds.getMinZ() <= loc) || !(loc <= bounds.getMaxZ())) break;
                        quads.add(new AARectangle(2, loc, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), false));
                    }
                }
            }
            return quads;
        }

        @Override
        public GeomGroup optimize(IPointOptimizer pool) {
            GeomGroup optimized = super.optimize(pool);
            return optimized == this ? this : new SliceGeom(optimized.children, this.plane, this.loc, this.grids);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Plane3d plane = switch (this.plane) {
                case 0 -> new Plane3d(1.0, 0.0, 0.0, -this.loc);
                case 1 -> new Plane3d(0.0, 1.0, 0.0, -this.loc);
                case 2 -> new Plane3d(0.0, 0.0, 1.0, -this.loc);
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
            plane = plane.transformBy(xform);
            Point3d pOnPlane = new Point3d(-plane.x * plane.w, -plane.y * plane.w, -plane.z * plane.w);
            Vector3d newNorm = plane.getNormal();
            int newAxis = Util.getClosestAxis(newNorm);
            switch (newAxis) {
                case 0: {
                    return new SliceGeom(0, pOnPlane.x, this.grids);
                }
                case 1: {
                    return new SliceGeom(1, pOnPlane.y, this.grids);
                }
                case 2: {
                    return new SliceGeom(2, pOnPlane.z, this.grids);
                }
            }
            return this;
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle(this));
        }

        private static class Handle
        extends APlaneHandle<SliceGeom> {
            public Handle(SliceGeom geom) {
                super(geom);
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj) && obj instanceof Handle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode((IGeom)this.getManipGeom());
            }

            @Override
            protected Vector3d getPlaneNormal(SliceGeom geom) {
                switch (geom.plane) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 2: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                }
                return null;
            }

            @Override
            protected SliceGeom modify(SliceGeom origGeom, double offset) {
                return new SliceGeom(origGeom.plane, origGeom.loc + offset, origGeom.grids);
            }
        }
    }

    public static class PlanarSliceHash {
        private final Integer d_plane;
        private final UnitDouble d_loc;
        private final IQuantity d_measurement;
        private final String d_name;

        public PlanarSliceHash(int plane, UnitDouble loc, IQuantity measurement, String name) {
            this.d_plane = plane;
            this.d_loc = loc;
            this.d_measurement = measurement;
            this.d_name = name;
        }

        public int hashCode() {
            return this.d_plane.hashCode() + this.d_loc.hashCode() + this.d_measurement.hashCode() + this.d_name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PlanarSliceHash)) {
                return false;
            }
            PlanarSliceHash hash2 = (PlanarSliceHash)obj;
            return hash2.d_plane.equals(this.d_plane) && hash2.d_loc.equals(this.d_loc) && hash2.d_measurement.equals(this.d_measurement) && hash2.d_name.equals(this.d_name);
        }
    }
}

