/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import java.util.Objects;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class AAPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Axis axis;
    public final double val;
    public final boolean pnormal;

    public AAPlane(Axis axis, double val, boolean pnormal) {
        this.axis = axis;
        this.val = val;
        this.pnormal = pnormal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AAPlane)) {
            return false;
        }
        AAPlane p = (AAPlane)obj;
        return p.axis == this.axis && p.pnormal == this.pnormal && p.val == this.val;
    }

    public int hashCode() {
        return 0x23498FA ^ Objects.hash(new Object[]{this.axis, this.val, this.pnormal});
    }

    @Override
    public Plane3d get() {
        double n = this.pnormal ? 1.0 : -1.0;
        double v = -n * this.val;
        switch (this.axis) {
            case X: {
                return new Plane3d(n, 0.0, 0.0, v);
            }
            case Y: {
                return new Plane3d(0.0, n, 0.0, v);
            }
        }
        return new Plane3d(0.0, 0.0, n, v);
    }

    @Override
    public String toString(Unit lu) {
        char c = this.pnormal ? (char)'+' : '-';
        String normal = String.format("%c%s", new Object[]{Character.valueOf(c), this.axis});
        return String.format(Intl.intl("%s=%s, normal=%s"), this.axis.toString(), Global.format(UnitDouble.convert(this.val, Geometry.LU, lu), lu), normal);
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

