/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class TexOrigin
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final UnitPoint3D DEF_LOC = Geometry.UP3D_ZERO;
    public static final TexOrigin DEF_WORLD = new TexOrigin(DEF_LOC, false);
    public static final TexOrigin DEF_LOCAL = new TexOrigin(DEF_LOC, true);
    private final UnitPoint3D d_loc;
    private final boolean d_relativeToObj;

    public TexOrigin(UnitPoint3D loc, boolean relToObj) {
        this.d_loc = loc;
        this.d_relativeToObj = relToObj;
    }

    public static TexOrigin defaultWorld() {
        return DEF_WORLD;
    }

    public static TexOrigin defaultLocal() {
        return DEF_LOCAL;
    }

    public static TexOrigin getAbsolute(Point3d loc) {
        return loc.x == 0.0 && loc.y == 0.0 && loc.z == 0.0 ? DEF_WORLD : new TexOrigin(new UnitPoint3D(loc, Geometry.LU), false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TexOrigin)) {
            return false;
        }
        TexOrigin to = (TexOrigin)obj;
        return this.d_relativeToObj == to.d_relativeToObj && this.d_loc.equals(to.d_loc);
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_relativeToObj) + this.d_loc.hashCode();
    }

    public TexOrigin toWorld(IPyroGeomSrc obj) {
        if (!this.d_relativeToObj) {
            return this;
        }
        return new TexOrigin(this.getWorld(obj), false);
    }

    public UnitPoint3D getLocal() {
        return this.d_loc;
    }

    public UnitPoint3D getWorld(IPyroGeomSrc obj) {
        return this.getWorld(obj.getGeom());
    }

    public UnitPoint3D getWorld(IGeomNode obj) {
        if (this.d_relativeToObj) {
            AABox bounds = new AABox();
            obj.getBoundingBox(bounds);
            return this.d_loc.add(new UnitPoint3D(bounds.getMin(), Geometry.LU));
        }
        return this.d_loc;
    }

    public boolean isRelativeToObj() {
        return this.d_relativeToObj;
    }
}

