/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.function.Predicate;
import pyrosim.domain.devices.IAABoxDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitAABox;

public class AABoxMeasurer
extends AMeasuringDevc
implements IAABoxDevice {
    static final long serialVersionUID = 1L;
    private UnitAABox d_box;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, 2);

    public AABoxMeasurer(String name, IQuantity measurment, UnitAABox box) {
        super(name, measurment);
        this.d_box = box;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AABoxMeasurer && super.equals(obj) && this.d_box.equals(((AABoxMeasurer)obj).d_box);
    }

    @Override
    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox box) {
        this.d_box = box;
        this.changedEvt(new Object[0]);
    }

    public static long getOutputType() {
        return 4L;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity o) {
                return QuantityUtil.canOutputAll(o, AABoxMeasurer.getOutputType());
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public AABoxGeom getBoxGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            AABoxGeom bg = (AABoxGeom)geom;
            this.setBox(new UnitAABox(bg.min, bg.max, Geometry.LU));
        }
    }
}

