/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.ALogicOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.controls.ControlDesc;
import thunderheadeng.units.UnitDouble;

public class Util {
    public static boolean deleteWires(IInPin inPin) {
        if (inPin == null) {
            return false;
        }
        boolean modified = false;
        ArrayList<? extends IOutPin> currOutPins = new ArrayList<IOutPin>(inPin.getConnections());
        block0: for (IOutPin iOutPin : currOutPins) {
            IControl ctrl;
            if (iOutPin.getAttachedSource() instanceof ISignalSink) {
                ISignalSink sink = (ISignalSink)((Object)iOutPin.getAttachedSource());
                modified |= Util.deleteWires(sink.getInputPin());
            }
            if (!(iOutPin.getAttachedSource() instanceof IControl) || !(ctrl = (IControl)iOutPin.getAttachedSource()).isWire() || ctrl instanceof ControlBridge) continue;
            modified = true;
            inPin.disconnect(iOutPin);
            for (IOutPin iOutPin2 : ctrl.getInputPin().getConnections()) {
                if (!inPin.isCompatible(iOutPin2)) continue;
                inPin.connect(iOutPin2);
                continue block0;
            }
        }
        return modified;
    }

    public static boolean isComplete(IOutPin pin) {
        ISignalSource src = pin.getAttachedSource();
        return !(src instanceof IControl) || ((IControl)src).isComplete();
    }

    public static boolean isWire(IOutPin pin) {
        ISignalSource src = pin.getAttachedSource();
        return src instanceof IControl && ((IControl)src).isWire();
    }

    public static int countNumCompleteInputs(IInPin inPin) {
        int numValid = 0;
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (!Util.isComplete(iOutPin)) continue;
            ++numValid;
        }
        return numValid;
    }

    public static boolean inputLatches(IInPin inPin) {
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            return ((ILogicOutPin)iOutPin).latches();
        }
        return false;
    }

    public static Set<ILogicOutPin> getLogicPins(PyroMod pyMod) {
        TreeSet<ILogicOutPin> pins = new TreeSet<ILogicOutPin>((o1, o2) -> ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2)));
        for (IDevice devc : pyMod.getDevices().flatten()) {
            if (!(devc instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                if (!(iOutPin instanceof ILogicOutPin)) continue;
                pins.add((ILogicOutPin)iOutPin);
            }
        }
        for (ControlBridge bridge : pyMod.getControls().flatten()) {
            if (!bridge.isLogicWire()) continue;
            pins.add(bridge.getLogicOutPin());
        }
        return pins;
    }

    public static List<IDoubleOutPin> getDblSrcPins(PyroMod pyMod) {
        ArrayList<IDoubleOutPin> pins = new ArrayList<IDoubleOutPin>();
        for (IDevice devc : pyMod.getDevices().flatten()) {
            if (!(devc instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                if (!(iOutPin instanceof IDoubleOutPin)) continue;
                pins.add((IDoubleOutPin)iOutPin);
            }
        }
        for (ControlBridge ctrl : pyMod.getControls().flatten()) {
            if (!ctrl.isMathControl()) continue;
            pins.add(ctrl.getDoubleOutPin());
        }
        return pins;
    }

    public static Map<AControl, ControlBridgeAsSinkHelper> getValidControlsAsSinks(PyroMod pyMod) {
        HashMap<AControl, ControlBridgeAsSinkHelper> mapping = new HashMap<AControl, ControlBridgeAsSinkHelper>();
        for (ControlBridge cb : pyMod.getControls().flatten()) {
            ControlBridgeAsSinkHelper helper = Util.tryBuildHelper(cb);
            if (helper == null) continue;
            mapping.put(helper.root, helper);
        }
        return mapping;
    }

    public static void replaceLinks(ControlBridge cb, Class<? extends AControl> toRemove, Supplier<AControl> newControlSupplier) {
        for (Map.Entry<IOutPin, IInPin> toConnect : Util.findSignalsAcrossClass(cb, toRemove).entrySet()) {
            IOutPin origin = toConnect.getKey();
            IInPin destination = toConnect.getValue();
            AControl replaceObj = (AControl)destination.getConnectedSources().iterator().next();
            replaceObj.getInputPin().disconnectAll();
            destination.disconnectAll();
            destination.connect(origin);
            AControl newCtrl = newControlSupplier.get();
            newCtrl.getInputPin().connect(origin);
            destination.connect(newCtrl.getOutputPins().get(0));
        }
    }

    public static void removeLinks(ControlBridge cb, Class<? extends AControl> toRemove) {
        for (Map.Entry<IOutPin, IInPin> toConnect : Util.findSignalsAcrossClass(cb, toRemove).entrySet()) {
            IOutPin origin = toConnect.getKey();
            IInPin destination = toConnect.getValue();
            AControl extractedObj = (AControl)destination.getConnectedSources().iterator().next();
            extractedObj.getInputPin().disconnectAll();
            destination.disconnectAll();
            destination.connect(origin);
        }
    }

    private static Map<IOutPin, IInPin> findSignalsAcrossClass(ControlBridge cb, Class<? extends AControl> searchClass) {
        IInPin inPinForDA = cb.getInputPin();
        DupAccumulation da = Util.accumulateDuplicates(inPinForDA.getConnections());
        AControl previousLink = cb;
        HashMap<IOutPin, IInPin> connections = new HashMap<IOutPin, IInPin>();
        boolean isFinished = false;
        while (!isFinished) {
            boolean isInstance;
            ISignalSink currentSink = da.getCurrentSink();
            if (currentSink == null && previousLink == cb) {
                isFinished = true;
                continue;
            }
            if (currentSink == null) {
                ISignalSource potentialSink = previousLink.getInputPin().getConnectedSources().iterator().next();
                if (potentialSink instanceof ISignalSink) {
                    currentSink = (ISignalSink)((Object)potentialSink);
                } else {
                    return connections;
                }
            }
            if (isInstance = searchClass.isInstance(currentSink)) {
                boolean hasSingleInput;
                AControl currentControl = (AControl)currentSink;
                boolean hasNoInputs = currentControl.getInputPin().getConnections().isEmpty();
                if (hasNoInputs) {
                    connections.put(null, previousLink.getInputPin());
                    previousLink = currentControl;
                    isFinished = true;
                    continue;
                }
                boolean bl = hasSingleInput = currentControl.getInputPin().getConnections().size() == 1;
                if (hasSingleInput) {
                    connections.put(currentControl.getInputPin().getConnections().iterator().next(), previousLink.getInputPin());
                    previousLink = currentControl;
                    ISignalSource incoming = da.d_nextInputs.iterator().next().getAttachedSource();
                    if (incoming instanceof IDevice) {
                        isFinished = true;
                        continue;
                    }
                    if (incoming instanceof ControlBridge) {
                        isFinished = true;
                        continue;
                    }
                    if (incoming instanceof AControl) {
                        previousLink = (AControl)currentSink;
                        da = Util.accumulateDuplicates(currentSink.getInputPin().getConnections());
                        continue;
                    }
                    assert (false) : String.format("Unknown signal type: ", incoming.getClass().toString());
                    continue;
                }
                assert (false) : "Neither removelinks nor replaceLinks is codedto handle multi in control replacements.";
                isFinished = true;
                continue;
            }
            if (da.d_nextInputs.isEmpty()) {
                isFinished = true;
                continue;
            }
            if (da.d_nextInputs.size() > 1) {
                isFinished = true;
                continue;
            }
            ISignalSource incoming = da.d_nextInputs.iterator().next().getAttachedSource();
            if (incoming instanceof IDevice) {
                isFinished = true;
                continue;
            }
            if (incoming instanceof ControlBridge) {
                isFinished = true;
                continue;
            }
            if (incoming instanceof AControl) {
                previousLink = (AControl)currentSink;
                da = Util.accumulateDuplicates(currentSink.getInputPin().getConnections());
                continue;
            }
            assert (false) : String.format("Unknown signal type: ", incoming.getClass().toString());
        }
        return connections;
    }

    public static ControlBridgeAsSinkHelper tryBuildHelper(ControlBridge cb) {
        ISignalSource source;
        DupAccumulation da = Util.accumulateDuplicates(cb.getInputPin().getConnections());
        if (da.d_nextInputs.isEmpty()) {
            return null;
        }
        AControl root = null;
        while (!(root != null || da.d_nextInputs.isEmpty() || (source = da.d_nextInputs.iterator().next().getAttachedSource()) instanceof IDevice || source instanceof ControlBridge || source instanceof AMathOp || source instanceof CustomCtrl || source instanceof ManualCtrl || source instanceof DeadbandCtrl)) {
            if (source instanceof TimeDelayCtrl) {
                da = Util.accumulateDuplicates(((TimeDelayCtrl)source).getInputPin().getConnections());
                continue;
            }
            if (source instanceof NotOp) {
                da = Util.accumulateDuplicates(((NotOp)source).getInputPin().getConnections());
                continue;
            }
            if (source instanceof AIntCompareOp) {
                root = (AControl)source;
                da = Util.accumulateDuplicates(((AIntCompareOp)source).getInputPin().getConnections());
                continue;
            }
            if (source instanceof ALogicOp) {
                root = (AControl)source;
                da = Util.accumulateDuplicates(((ALogicOp)source).getInputPin().getConnections());
                continue;
            }
            assert (false) : "Unrecognized type";
        }
        if (root == null) {
            return null;
        }
        boolean isInversion = da.isOldInversion();
        return new ControlBridgeAsSinkHelper(root, cb, isInversion);
    }

    public static DupAccumulation accumulateDuplicates(Collection<? extends IOutPin> inputs) {
        DupAccumulation accum = new DupAccumulation(inputs);
        Util.accumulateDuplicates(accum);
        return accum;
    }

    public static void accumulateDuplicates(DupAccumulation accum) {
        if (accum.d_nextInputs.size() != 1) {
            return;
        }
        ISignalSource src = accum.d_nextInputs.iterator().next().getAttachedSource();
        if (src instanceof LatchCtrl) {
            if (!accum.isOldBoring() && !accum.isOldLatch()) {
                return;
            }
            accum.d_latch = true;
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            accum.d_currentSink = (ISignalSink)((Object)src);
            Util.accumulateDuplicates(accum);
            return;
        }
        if (src instanceof NotOp) {
            if (!accum.isOldBoring() && !accum.isOldInversion()) {
                return;
            }
            ++accum.d_invertCount;
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            accum.d_currentSink = (ISignalSink)((Object)src);
            Util.accumulateDuplicates(accum);
            return;
        }
        if (src instanceof TimeDelayCtrl) {
            if (!accum.isOldBoring() && !accum.isOldTimeDelay()) {
                return;
            }
            accum.d_delay = accum.d_delay.add(((TimeDelayCtrl)src).getTimeDelay());
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            accum.d_currentSink = (ISignalSink)((Object)src);
            Util.accumulateDuplicates(accum);
            return;
        }
    }

    public static Map<IOutPin, IInPin> markFirstClassControls(Collection<ControlBridge> bridges) {
        HashSet<IInPin> insertionPoints = new HashSet<IInPin>();
        HashMap<IOutPin, IInPin> mappedInsertions = new HashMap<IOutPin, IInPin>();
        for (ControlBridge cb : bridges) {
            ISignalSource incomingSrc;
            Set<ISignalSource> srcs = cb.getInputPin().getConnectedSources();
            if (srcs.isEmpty() || srcs.size() > 1 || !((incomingSrc = srcs.iterator().next()) instanceof AControl)) continue;
            boolean isFinished = false;
            ArrayList<AControl> nodesToExplore = new ArrayList<AControl>();
            nodesToExplore.add((AControl)incomingSrc);
            int ix = 0;
            ArrayList<AControl> exploredNodes = new ArrayList<AControl>();
            while (!isFinished) {
                AControl root = (AControl)nodesToExplore.get(ix);
                block2: for (ISignalSource enteringRoot : root.getInputPin().getConnectedSources()) {
                    ISignalSource firstClassControl = Util.findFirstClassControls(enteringRoot);
                    if (firstClassControl == null) continue;
                    if (firstClassControl instanceof Timer) {
                        Timer devc = (Timer)firstClassControl;
                        mappedInsertions.put(devc.getAlarmPin(), root.getInputPin());
                        continue;
                    }
                    if (!(firstClassControl instanceof AControl)) continue;
                    nodesToExplore.add((AControl)firstClassControl);
                    insertionPoints.add(root.getInputPin());
                    for (IOutPin iOutPin : enteringRoot.getOutputPins()) {
                        if (!(iOutPin instanceof ILogicOutPin)) continue;
                        mappedInsertions.put(iOutPin, root.getInputPin());
                        continue block2;
                    }
                }
                exploredNodes.add(root);
                isFinished = exploredNodes.size() == nodesToExplore.size();
                ++ix;
            }
        }
        return mappedInsertions;
    }

    public static ISignalSource findFirstClassControls(ISignalSource start) {
        if (Util.isFirstClassControl(start)) {
            return start;
        }
        if (start instanceof Clock || start instanceof Timer) {
            return start;
        }
        if (!(start instanceof AControl)) {
            return null;
        }
        Set<ISignalSource> srcs = ((AControl)start).getInputPin().getConnectedSources();
        if (srcs.isEmpty()) {
            return null;
        }
        ISignalSource incomingSrc = srcs.iterator().next();
        if (start instanceof TimeDelayCtrl) {
            if (incomingSrc instanceof IDevice || incomingSrc instanceof ControlBridge) {
                return start;
            }
            return Util.findFirstClassControls(incomingSrc);
        }
        if (incomingSrc instanceof Clock || incomingSrc instanceof Timer) {
            return incomingSrc;
        }
        if (!(incomingSrc instanceof AControl)) {
            return null;
        }
        return Util.findFirstClassControls(incomingSrc);
    }

    private static boolean isFirstClassControl(ISignalSource ctrl) {
        return ctrl instanceof ALogicOp || ctrl instanceof AIntCompareOp || ctrl instanceof CustomCtrl || ctrl instanceof DeadbandCtrl;
    }

    public static class ControlBridgeAsSinkHelper
    implements ISignalSink {
        public final AControl root;
        public final ControlBridge end;
        public final boolean needsInvert;
        public final String displayName;

        public ControlBridgeAsSinkHelper(AControl root, ControlBridge end, boolean needsInversion) {
            this.root = root;
            this.end = end;
            this.needsInvert = needsInversion;
            this.displayName = end.getName();
        }

        @Override
        public IInPin getInputPin() {
            return this.root.getInputPin();
        }

        @Override
        public boolean changedEvt(Object ... changes) {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return this.end.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public void setDomain(PyroMod domain) {
        }

        @Override
        public PyroMod getDomain() {
            return (PyroMod)this.end.getDomain();
        }

        @Override
        public void setDomain(PyroMod domain, IPyroObject parent) {
        }

        @Override
        public IPyroObject getParent() {
            return this.end.getParent();
        }

        @Override
        public Collection<? extends IPyroObject> getMembers() {
            return this.end.getMembers();
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this.root == obj || this.end == obj;
        }

        @Override
        public Object clone() {
            return null;
        }
    }

    public static class DupAccumulation {
        private static final int ACCUM_LATCH = 0;
        private static final int ACCUM_INVERT = 1;
        private static final int ACCUM_TDELAY = 2;
        private static final int ACCUM_NONE = 3;
        public boolean d_latch = false;
        public int d_invertCount = 0;
        public UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
        public Collection<? extends IOutPin> d_nextInputs;
        private ISignalSink d_currentSink;

        public DupAccumulation(Collection<? extends IOutPin> nextInputs) {
            this.d_nextInputs = nextInputs;
        }

        public int getOldAccumType() {
            if (this.d_latch) {
                return 0;
            }
            if (this.d_invertCount > 0) {
                return 1;
            }
            if (this.d_delay.getValueNoUnit() > 0.0) {
                return 2;
            }
            return 3;
        }

        public boolean isOldLatch() {
            return this.getOldAccumType() == 0;
        }

        public boolean isOldInversion() {
            return this.getOldAccumType() == 1;
        }

        public boolean isOldTimeDelay() {
            return this.getOldAccumType() == 2;
        }

        public boolean isOldBoring() {
            return this.getOldAccumType() == 3;
        }

        public boolean isLatch() {
            return this.d_latch;
        }

        public boolean isInversion() {
            return this.d_invertCount > 0;
        }

        public boolean isTimeDelay() {
            return this.d_delay.getValueNoUnit() > 0.0;
        }

        public boolean isBoring() {
            return !this.isLatch() && !this.isInversion() && !this.isTimeDelay();
        }

        public ISignalSink getCurrentSink() {
            return this.d_currentSink;
        }
    }
}

