/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.signals.AInPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.LogicOutPin;

public class ManualCtrl
extends AControl {
    static final long serialVersionUID = 1L;
    private final IInPin d_inPin;
    private final LogicOutPin d_outPin;
    private final String d_fdsText;

    public ManualCtrl(String fdsText, String ctrlName) {
        super(ctrlName);
        this.d_fdsText = fdsText;
        this.d_outPin = new LogicOutPin(this);
        this.d_inPin = new NullInPin(this);
    }

    @Override
    protected String getDefaultName() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    public String getFDSText() {
        return this.d_fdsText;
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public boolean isWire() {
        return this.d_fdsText.isEmpty() || this.getName() == null;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this == obj;
    }

    private static class NullInPin
    extends AInPin {
        static final long serialVersionUID = 1L;

        public NullInPin(ISignalSink sink) {
            super(sink);
        }

        @Override
        public boolean disconnectAll() {
            return true;
        }

        @Override
        public Set<? extends IOutPin> getConnections() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean isCompatible(IOutPin pin2) {
            return false;
        }
    }
}

