/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.auditing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public abstract class ModelCheckFilter<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    private ModelCheck.Op d_op;
    private String d_record;
    private String d_field;
    private ModelCheck.Condition d_condition;
    private T d_value;

    public ModelCheckFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, T value) {
        this.d_op = op;
        this.d_record = record;
        this.d_field = field;
        this.d_condition = condition;
        this.d_value = value;
    }

    public Collection<FDSRenderRecord> filter(Collection<FDSRenderRecord> records) {
        return records.stream().filter((? super T r) -> r.getType().equals(this.d_record) && this.compare(this.d_condition, r.get(this.d_field), this.d_value)).collect(Collectors.toCollection(ArrayList::new));
    }

    protected abstract boolean compare(ModelCheck.Condition var1, T var2, Object var3);

    protected boolean nullCheck(ModelCheck.Condition condition, Object obj) {
        if (condition.equals((Object)ModelCheck.Condition.EQ)) {
            return obj == null;
        }
        if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
            return obj != null;
        }
        return false;
    }

    public ModelCheck.Op getOp() {
        return this.d_op;
    }

    public String getRecord() {
        return this.d_record;
    }

    public String getField() {
        return this.d_field;
    }

    public ModelCheck.Condition getCondition() {
        return this.d_condition;
    }

    public Object getValue() {
        return this.d_value;
    }

    public static class ArrayFilter
    extends ModelCheckFilter<FDSArray> {
        public ArrayFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, FDSArray value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, FDSArray arr1, Object obj2) {
            if (arr1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof FDSArray)) {
                return false;
            }
            FDSArray arr2 = (FDSArray)obj2;
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return arr1.equals(arr2);
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return !arr1.equals(arr2);
            }
            return false;
        }
    }

    public static class ListFilter
    extends ModelCheckFilter<List> {
        public ListFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, List value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, List list1, Object obj2) {
            if (list1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof List)) {
                return false;
            }
            List list2 = (List)obj2;
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return list1.equals(list2);
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return !list1.equals(list2);
            }
            return false;
        }
    }

    public static class UnitDoubleFilter
    extends ModelCheckFilter<UnitDouble> {
        public UnitDoubleFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, UnitDouble value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, UnitDouble ud1, Object obj2) {
            if (ud1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof UnitDouble)) {
                return false;
            }
            UnitDouble ud2 = (UnitDouble)obj2;
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return ud1.eq(ud2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return !ud1.eq(ud2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.GT)) {
                return ud1.gt(ud2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.LT)) {
                return ud1.lt(ud2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.GTE)) {
                return ud1.ge(ud2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.LTE)) {
                return ud1.le(ud2, 0.001);
            }
            return false;
        }
    }

    public static class DoubleFilter
    extends ModelCheckFilter<Double> {
        public DoubleFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, Double value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, Double d1, Object obj2) {
            if (d1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof Double)) {
                return false;
            }
            Double d2 = (Double)obj2;
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return theUtil.eq(d1, d2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return !theUtil.eq(d1, d2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.GT)) {
                return theUtil.gt(d1, d2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.LT)) {
                return theUtil.lt(d1, d2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.GTE)) {
                return theUtil.ge(d1, d2, 0.001);
            }
            if (condition.equals((Object)ModelCheck.Condition.LTE)) {
                return theUtil.le(d1, d2, 0.001);
            }
            return false;
        }
    }

    public static class IntegerFilter
    extends ModelCheckFilter<Integer> {
        public IntegerFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, Integer value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, Integer i1, Object obj2) {
            if (i1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof Integer)) {
                return false;
            }
            Integer i2 = (Integer)obj2;
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return i1 == i2;
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return i1 != i2;
            }
            if (condition.equals((Object)ModelCheck.Condition.GT)) {
                return i1 > i2;
            }
            if (condition.equals((Object)ModelCheck.Condition.LT)) {
                return i1 < i2;
            }
            if (condition.equals((Object)ModelCheck.Condition.GTE)) {
                return i1 >= i2;
            }
            if (condition.equals((Object)ModelCheck.Condition.LTE)) {
                return i1 <= i2;
            }
            return false;
        }
    }

    public static class BooleanFilter
    extends ModelCheckFilter<Boolean> {
        public BooleanFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, Boolean value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, Boolean bool1, Object obj2) {
            if (bool1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof Boolean)) {
                return false;
            }
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return bool1 == obj2;
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return bool1 != obj2;
            }
            return false;
        }
    }

    public static class StringFilter
    extends ModelCheckFilter<String> {
        public StringFilter(ModelCheck.Op op, String record, String field, ModelCheck.Condition condition, String value) {
            super(op, record, field, condition, value);
        }

        @Override
        protected boolean compare(ModelCheck.Condition condition, String obj1, Object obj2) {
            if (obj1 == null) {
                return this.nullCheck(condition, obj2);
            }
            if (!(obj2 instanceof String)) {
                return false;
            }
            if (condition.equals((Object)ModelCheck.Condition.EQ)) {
                return obj1.equals(obj2);
            }
            if (condition.equals((Object)ModelCheck.Condition.NEQ)) {
                return !obj1.equals(obj2);
            }
            return false;
        }
    }
}

