/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroNamesDB;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckManager;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.IEvacObj;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.HvacDuctOutput;
import pyrosim.domain.output.HvacNodeOutput;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.scenario.Scenario;
import pyrosim.domain.scenario.ScenarioList;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.NameGenerator;

public class Serialized
implements Serializable {
    static final long serialVersionUID = 1L;
    public SimParams simParams;
    public ScenarioList scenarios;
    public NameGenerator scenarioNames;
    public final NameGenerator groupNames;
    public ModelComposite obstructions;
    public final NameGenerator ventNames;
    public final NameGenerator obstNames;
    public final NameGenerator holeNames;
    public final NameGenerator initRegionNames;
    public final NameGenerator partCloudNames;
    public GridList grids;
    public final NameGenerator gridNames;
    public ZoneMgr zones;
    public final NameGenerator zoneNames;
    public FloorManager floors;
    public ParticleList particles;
    public final NameGenerator partNames;
    public MaterialManager matmgr;
    public final NameGenerator matNames;
    public SurfaceManager surfmgr;
    public final NameGenerator modelCheckNames;
    public ModelCheckManager modelCheckManager;
    public final NameGenerator surfNames;
    public ReactionList reactions;
    public final NameGenerator reacNames;
    public ExSpecList exSpecs;
    public final NameGenerator specNames;
    public HvacList hvacSystem;
    public final NameGenerator hvacDuctNames;
    public final NameGenerator hvacNodeNames;
    public final NameGenerator hvacFanNames;
    public final NameGenerator hvacFilterNames;
    public final NameGenerator hvacAircoilNames;
    public final NameGenerator hvacLeakNames;
    public BridgeList bridges;
    public boolean enableFdsEvac;
    public PersList perss;
    public ExitList exits;
    public EvacList evacs;
    public EntrList entrs;
    public EvhoList evhos;
    public CorrList corrs;
    public EvssList evsss;
    public DoorList doors;
    public final NameGenerator evacNames;
    public ControlMgr controls;
    public final NameGenerator ctrlNames;
    public HeatLinkModelMgr heatLinkModels;
    public final NameGenerator heatLinkModelNames;
    public SmokeLinkModelMgr smokeLinkModels;
    public final NameGenerator smokeLinkModelNames;
    public SprinklerLinkModelMgr sprkLinkModels;
    public final NameGenerator sprkLinkModelNames;
    public SprayModelMgr sprayModels;
    public final NameGenerator sprayModelNames;
    public DeviceManager devices;
    public final NameGenerator devcNames;
    public Boundaries boundaryOutput;
    public IsosurfaceMgr isosurfaces;
    public Plot3d plot3d;
    public HvacNodeOutput hvacNodeOut;
    public HvacDuctOutput hvacDuctOut;
    public SliceList slices;
    public Slice3dList slices3d;
    public final NameGenerator slice3dNames;
    public final NameGenerator sliceNames;
    public ProfList profs;
    public final NameGenerator profNames;
    public StatisticMgr msrStats;
    public final NameGenerator msrStatNames;
    public MaterialDB appearances;
    public final NameGenerator appearanceNames;
    public ViewMgr views;
    public final NameGenerator viewNames;
    public RasterizationOptions rastProps = new RasterizationOptions();
    public String unprocessedRecords;
    public FDSRun lastFDSRun;
    @Nullable
    public FDSClusterOptions clusterOptions;
    public ResultsArchive resultsArchive;
    public boolean d_protect;
    public byte[] d_protectPassHash;

    public Serialized(boolean initDefaults) {
        this.groupNames = new NameGenerator(Intl.intl("Group"), 2, true);
        this.obstructions = new ModelComposite(Intl.intl("Model"));
        this.ventNames = new NameGenerator(Intl.intl("Vent"));
        this.obstNames = new NameGenerator(Intl.intl("Obstruction"), 4, true);
        this.holeNames = new NameGenerator(Intl.intl("Hole"), 2, true);
        this.initRegionNames = new NameGenerator(Intl.intl("Init Region"), 2, true);
        this.partCloudNames = new NameGenerator(Intl.intl("Part Cloud"), 2, true);
        this.grids = new GridList();
        this.gridNames = new NameGenerator(Intl.intl("Mesh"));
        this.zones = new ZoneMgr();
        this.zones.addDefaults();
        this.zoneNames = new NameGenerator(Intl.intl("Zone"));
        this.floors = new FloorManager();
        this.particles = new ParticleList();
        this.partNames = new NameGenerator(Intl.intl("Particle"));
        this.matmgr = new MaterialManager();
        this.matNames = new NameGenerator(Intl.intl("Material"));
        this.surfmgr = new SurfaceManager();
        this.surfmgr.addPredefined();
        this.surfNames = new NameGenerator(Intl.intl("Surface"));
        this.modelCheckManager = new ModelCheckManager();
        this.modelCheckNames = new NameGenerator(Intl.intl("Model Check"));
        this.reactions = new ReactionList();
        this.reacNames = new NameGenerator(Intl.intl("Reaction"), 1, false);
        this.exSpecs = new ExSpecList();
        this.specNames = new NameGenerator(Intl.intl("Species"));
        this.hvacSystem = new HvacList();
        this.hvacDuctNames = new NameGenerator(Intl.intl("Duct"));
        this.hvacNodeNames = new NameGenerator(Intl.intl("Node"));
        this.hvacAircoilNames = new NameGenerator(Intl.intl("Aircoil"));
        this.hvacFanNames = new NameGenerator(Intl.intl("Fan"));
        this.hvacFilterNames = new NameGenerator(Intl.intl("Filter"));
        this.hvacLeakNames = new NameGenerator(Intl.intl("Leak"));
        this.bridges = new BridgeList();
        this.enableFdsEvac = false;
        this.perss = new PersList();
        this.exits = new ExitList();
        this.evacs = new EvacList();
        this.entrs = new EntrList();
        this.evhos = new EvhoList();
        this.corrs = new CorrList();
        this.evsss = new EvssList();
        this.doors = new DoorList();
        this.evacNames = new NameGenerator(Intl.intl("Evac"));
        this.heatLinkModels = new HeatLinkModelMgr();
        this.heatLinkModelNames = new NameGenerator(Intl.intl("HDMod"));
        this.smokeLinkModels = new SmokeLinkModelMgr();
        this.smokeLinkModelNames = new NameGenerator(Intl.intl("SDMod"));
        this.sprkLinkModels = new SprinklerLinkModelMgr();
        this.sprkLinkModelNames = new NameGenerator(Intl.intl("SLINKMod"));
        this.sprayModels = new SprayModelMgr();
        this.sprayModelNames = new NameGenerator(Intl.intl("SprayMod"));
        this.devices = new DeviceManager();
        this.devcNames = new NameGenerator(Intl.intl("Device"));
        this.controls = new ControlMgr();
        this.ctrlNames = new NameGenerator(Intl.intl("Control"));
        this.boundaryOutput = new Boundaries(new IQuantity[0]);
        this.isosurfaces = new IsosurfaceMgr();
        this.slices = new SliceList();
        this.slices3d = new Slice3dList();
        this.sliceNames = new NameGenerator(Intl.intl("Slice2D"));
        this.slice3dNames = new NameGenerator(Intl.intl("Slice3D"));
        this.plot3d = new Plot3d();
        this.hvacNodeOut = new HvacNodeOutput();
        this.hvacDuctOut = new HvacDuctOutput();
        this.profs = new ProfList();
        this.profNames = new NameGenerator(Intl.intl("Profile"));
        this.msrStats = new StatisticMgr();
        this.msrStatNames = new NameGenerator(Intl.intl("Statistic"));
        this.views = new ViewMgr();
        this.viewNames = new NameGenerator(Intl.intl("View"));
        this.simParams = new SimParams(this.surfmgr);
        this.scenarios = new ScenarioList();
        this.scenarioNames = new NameGenerator(Intl.intl("Scenario"));
        this.appearances = new MaterialDB();
        this.appearanceNames = new NameGenerator(Intl.intl("Appearance"), 2, true);
        this.unprocessedRecords = "";
        this.lastFDSRun = new FDSRun();
        this.clusterOptions = null;
        this.resultsArchive = new ResultsArchive();
        this.d_protect = false;
        this.d_protectPassHash = new byte[0];
        if (initDefaults) {
            this.initDefaults();
        }
    }

    public void initNewFields(boolean includeDefaults, String ... fieldNames) {
        Serialized[] def = new Serialized[]{null};
        Supplier<Serialized> defser = () -> {
            if (def[0] == null) {
                def[0] = new Serialized(includeDefaults);
            }
            return def[0];
        };
        BiConsumer<Field, Boolean> fieldInit = (field, forceInit) -> {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !forceInit.booleanValue() && field.isAnnotationPresent(Nullable.class)) {
                return;
            }
            try {
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                try {
                    if (!forceInit.booleanValue() && field.get(this) != null) {
                        return;
                    }
                    System.out.println("Initializing Serialized." + field.getName());
                    field.set(this, field.get(defser.get()));
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        };
        if (fieldNames.length == 0) {
            for (Field field2 : Serialized.class.getDeclaredFields()) {
                fieldInit.accept(field2, false);
            }
        } else {
            for (String fname : fieldNames) {
                try {
                    Field field3 = Serialized.class.getDeclaredField(fname);
                    fieldInit.accept(field3, true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public PyroNamesDB generateNamesDB() {
        PyroNamesDB db = new PyroNamesDB();
        db.registerType(Composite.class, this.groupNames);
        db.registerType(Vent.class, this.ventNames);
        db.registerType(IObstruction.class, this.obstNames);
        db.registerType(IHole.class, this.holeNames);
        db.registerType(PartCloud.class, this.partCloudNames);
        db.registerType(InitRegion.class, this.initRegionNames);
        db.registerType(Grid.class, this.gridNames);
        db.registerType(Zone.class, this.zoneNames);
        db.registerType(Particle.class, this.partNames);
        db.registerType(pyrosim.domain.boundcond.mat.Material.class, this.matNames);
        db.registerType(Surface.class, this.surfNames);
        db.registerType(Reaction.class, this.reacNames);
        db.registerType(ExSpec.class, this.specNames);
        db.registerType(HvacDuct.class, this.hvacDuctNames);
        db.registerType(HvacNode.class, this.hvacNodeNames);
        db.registerType(HvacFan.class, this.hvacFanNames);
        db.registerType(HvacFilter.class, this.hvacFilterNames);
        db.registerType(HvacAircoil.class, this.hvacAircoilNames);
        db.registerType(HvacLeak.class, this.hvacLeakNames);
        db.registerType(ModelCheck.class, this.modelCheckNames);
        db.registerType(IEvacObj.class, this.evacNames);
        db.registerType(ControlBridge.class, this.ctrlNames);
        db.registerType(HeatLinkModel.class, this.heatLinkModelNames);
        db.registerType(SmokeLinkModel.class, this.smokeLinkModelNames);
        db.registerType(SprinklerLinkModel.class, this.sprkLinkModelNames);
        db.registerType(SprayModel.class, this.sprayModelNames);
        db.registerType(IDevice.class, this.devcNames);
        db.registerType(View.class, this.viewNames);
        db.registerType(PlanarSlice.class, this.sliceNames);
        db.registerType(VolumeSlice.class, this.slice3dNames);
        db.registerType(ProfRec.class, this.profNames);
        db.registerType(IMeasurementStat.class, this.msrStatNames);
        db.registerType(Material.class, this.appearanceNames);
        db.registerType(Scenario.class, this.scenarioNames);
        return db;
    }

    public void initDefaults() {
        this.heatLinkModels.addDefaults();
        this.smokeLinkModels.addDefaults();
        this.sprkLinkModels.addDefaults();
        this.floors.addDefaults();
        this.exSpecs.addDefaults();
        this.particles.addDefaults(this.exSpecs);
        this.sprayModels.addDefaults(this.particles);
        this.views.addDefaults();
        this.scenarios.addDefaults();
    }

    public void setDomain(PyroMod domain) {
        block6: {
            try {
                for (Field field : Serialized.class.getFields()) {
                    Object o = field.get(this);
                    if (!field.getName().equals("clusterOptions") && o == null) {
                        System.out.println("ZOOM");
                        field.get(this);
                    }
                    assert (field.getName().equals("clusterOptions") || o != null) : "Someone forgot to initialize Serialized." + field.getName();
                    if (o instanceof IPyroObject) {
                        ((IPyroObject)o).setDomain(domain, domain);
                        continue;
                    }
                    if (!(o instanceof IDomainObject)) continue;
                    ((IDomainObject)o).setDomain(domain);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Nullable {
    }
}

