/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class Hierarchy {
    public static <T extends IPyroObject> Iterator<T> iterateParents(Class<T> parentType, IPyroObject child) {
        return new ParentIterator<T>(parentType, child);
    }

    public static Set<IPyroObject> getParents(Collection<? extends IPyroObject> objs) {
        LinkedIdentityHashSet<IPyroObject> parents = new LinkedIdentityHashSet<IPyroObject>();
        for (IPyroObject iPyroObject : objs) {
            parents.add(iPyroObject);
        }
        return parents;
    }

    public static boolean isDescendent(IPyroObject parent, IPyroObject child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public static IPyroObject getCommonParent(Collection<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return null;
        }
        Iterator<? extends IPyroObject> it = objs.iterator();
        IPyroObject[] path = Hierarchy.getPath(it.next());
        int best = path.length - 2;
        while (it.hasNext() && best >= 0) {
            IPyroObject node = it.next();
            while (best >= 0 && !Hierarchy.isDescendent(path[best], node)) {
                --best;
            }
        }
        return best >= 0 ? path[best] : null;
    }

    public static IPyroObject[] getPath(IPyroObject child) {
        return Hierarchy.getPath(child, null, false);
    }

    public static IPyroObject[] getPath(IPyroObject child, IPyroObject stopParent, boolean includeStopParent) {
        ArrayList<IPyroObject> path = new ArrayList<IPyroObject>();
        Hierarchy.getPath(path, child, stopParent, includeStopParent);
        return path.toArray(new IPyroObject[path.size()]);
    }

    private static void getPath(List<IPyroObject> path, IPyroObject child, IPyroObject stopParent, boolean includeStopParent) {
        if (child != stopParent) {
            IPyroObject parent = child.getParent();
            if (parent != null) {
                Hierarchy.getPath(path, parent, stopParent, includeStopParent);
            }
            path.add(child);
        }
        if (child == stopParent && includeStopParent) {
            path.add(child);
        }
    }

    public static <T extends IPyroObject> IPyroObject getCategoryRoot(T o) {
        Object obj = o;
        IPyroObject parent = obj.getParent();
        while (parent != null) {
            if (parent instanceof PyroMod) {
                return obj;
            }
            obj = parent;
            parent = obj.getParent();
        }
        return null;
    }

    public static Collection<IPyroObject> flattenComposites(Collection<?> objs) {
        return Hierarchy.flatten(objs, IPyroObject.class, CompositeFilter.INSTANCE);
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type) {
        return new DeepCollection<T>(objs, type, Predicates.alwaysTrue());
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type, Predicate<? super T> filter) {
        return new DeepCollection<T>(objs, type, filter);
    }

    public static class ParentIterator<T extends IPyroObject>
    implements Iterator<T> {
        private Class<T> d_parentType;
        private T d_nextParent = null;

        public ParentIterator(Class<T> parentType, IPyroObject o) {
            this.d_parentType = parentType;
            this.prefetchNext(o);
        }

        private void prefetchNext(IPyroObject o) {
            IPyroObject next;
            for (next = o.getParent(); next != null && !this.d_parentType.isInstance(next); next = next.getParent()) {
            }
            this.d_nextParent = next == null ? null : next;
        }

        @Override
        public boolean hasNext() {
            return this.d_nextParent != null;
        }

        @Override
        public T next() {
            T next = this.d_nextParent;
            this.prefetchNext((IPyroObject)next);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CompositeFilter<T>
    implements Predicate<T> {
        public static final CompositeFilter INSTANCE = new CompositeFilter();

        @Override
        public boolean test(T o) {
            return !(o instanceof Composite);
        }
    }

    public static class DeepCollection<T>
    extends AbstractCollection<T> {
        private int d_size = -1;
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Collection<?> d_objs;

        public DeepCollection(Object root, Class<T> typeFilter, Predicate<? super T> filter) {
            this(Arrays.asList(root), typeFilter, filter);
        }

        public DeepCollection(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_objs = objs;
        }

        @Override
        public Iterator<T> iterator() {
            return new DeepIterator<T>(this.d_objs, this.d_typeFilter, this.d_filter);
        }

        @Override
        public int size() {
            if (this.d_size == -1) {
                this.d_size = 0;
                Iterator<T> it = this.iterator();
                while (it.hasNext()) {
                    ++this.d_size;
                    it.next();
                }
            }
            return this.d_size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object o) {
            if (!this.d_typeFilter.isInstance(o) || !this.d_filter.test(o)) {
                return false;
            }
            if (this.d_objs instanceof Set) {
                if (this.d_objs.contains(o)) {
                    return true;
                }
                for (Object obj : this.d_objs) {
                    if (!DeepCollection.containsDeep(obj, o)) continue;
                    return true;
                }
            } else {
                for (Object obj : this.d_objs) {
                    if (obj != o && !DeepCollection.containsDeep(obj, o)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean containsDeep(Object parent, Object child) {
            if (!(child instanceof IPyroObject)) {
                return false;
            }
            if (parent instanceof Composite) {
                return ((Composite)parent).containsDeep((IPyroObject)child);
            }
            if (parent instanceof IPyroObject) {
                for (IPyroObject iPyroObject : ((IPyroObject)parent).getMembers()) {
                    if (!DeepCollection.containsDeep(iPyroObject, child)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return super.containsAll(c);
        }
    }

    private static class DeepIterator<T>
    implements Iterator<T> {
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Deque<Iterator<?>> d_iteratorStack;
        private T d_nextObj;

        public DeepIterator(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_iteratorStack = new ArrayDeque();
            this.d_iteratorStack.push(objs.iterator());
            this.prefetchNext();
        }

        private void prefetchNext() {
            while (!this.d_iteratorStack.isEmpty()) {
                Iterator<Object> curIt = this.d_iteratorStack.peek();
                while (curIt.hasNext()) {
                    List children;
                    boolean found = false;
                    Object next = curIt.next();
                    if (this.d_typeFilter.isInstance(next) && this.d_filter.test(next)) {
                        this.d_nextObj = next;
                        found = true;
                    }
                    Collection<Object> collection = children = next instanceof IPyroObject ? ((IPyroObject)next).getMembers() : Collections.EMPTY_LIST;
                    if (!children.isEmpty()) {
                        curIt = children.iterator();
                        this.d_iteratorStack.push(curIt);
                    }
                    if (!found) continue;
                    return;
                }
                this.d_iteratorStack.pop();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.d_iteratorStack.isEmpty();
        }

        @Override
        public T next() {
            T next = this.d_nextObj;
            this.prefetchNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

