/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.PyroToolHooks;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawWallGeomTool
extends ADrawTool
implements MouseHistory.IListener {
    private WallGeom d_wall;
    private WallGeom.Alignment d_alignment = WallGeom.Alignment.LEFT;

    public DrawWallGeomTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                DrawWallGeomTool.this.incrementAlignment();
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> {
            if (this.getClickHistory().committedSize() >= 2) {
                builder.add(new FinishAction());
            }
            if (this.getClickHistory().committedSize() >= 3) {
                builder.add(new CloseAction());
            }
            builder.addSeparator();
            builder.addMutuallyExclusive(new AlignmentAction(Intl.intl("Align wall to left"), WallGeom.Alignment.LEFT), new AlignmentAction(Intl.intl("Align wall to right"), WallGeom.Alignment.RIGHT), new AlignmentAction(Intl.intl("Align wall to center"), WallGeom.Alignment.CENTER));
        });
    }

    public Class getGeomType() {
        return WallGeom.class;
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.update();
        if (p.committed && p.dragged && history.getHistory().size() == 2 && this.d_wall != null) {
            this.finish();
            return;
        }
        if (p.committed) {
            this.finishIfClosed();
        }
    }

    private void finishIfClosed() {
        Deque<MouseHistory.Point> refPoints = this.getClickHistory().getHistory();
        if (refPoints.size() >= 3 && refPoints.peekFirst().equals(refPoints.peekLast())) {
            this.finish();
        }
    }

    @Override
    public void finish() {
        this.getClickHistory().finalizePoints();
        this.update();
        this.fireFinish(this.d_wall != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_wall = null;
        super.reset();
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        switch (e.getKeyCode()) {
            case 10: {
                this.finish();
            }
        }
        this.resumeRepaint(true);
    }

    protected void incrementAlignment() {
        WallGeom.Alignment newAlign;
        switch (this.d_alignment) {
            case LEFT: {
                newAlign = WallGeom.Alignment.RIGHT;
                break;
            }
            case RIGHT: {
                newAlign = WallGeom.Alignment.CENTER;
                break;
            }
            default: {
                newAlign = WallGeom.Alignment.LEFT;
            }
        }
        this.setAlignment(newAlign);
    }

    protected void setAlignment(WallGeom.Alignment alignment) {
        this.d_alignment = alignment;
        this.update();
    }

    private void update() {
        if (this.d_wall != null) {
            this.fireRemove(0);
            this.d_wall = null;
        }
        if (this.getClickHistory().size() >= 2) {
            WallGeom geom;
            this.d_wall = geom = this.newWall(this.getClickHistory().getAllPoints());
            this.fireUpdate(0, GeomNodeUtil.newNode(geom), null);
        }
        this.updateStatusMessage();
        this.repaintSurface();
    }

    private WallGeom newWall(Collection<Point3d> points) {
        DrawProps props = this.getProps();
        Iterator<Point3d> pit = points.iterator();
        ACurve curve = points.size() == 2 ? new LineSeg(pit.next(), pit.next()) : new PolyLine(points.toArray(new Point3d[points.size()]));
        WallGeom geom = new WallGeom(curve, this.d_alignment, Math.abs(props.get(DrawProps.THICKNESS).getValue(Geometry.LU)), props.get(DrawProps.HEIGHT).getValue(Geometry.LU), 0);
        return geom;
    }

    protected class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -7182806987253734853L;

        public FinishAction() {
            super(Intl.intl("&Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrawWallGeomTool.this.finish();
        }
    }

    protected class AlignmentAction
    extends BooleanAction {
        private static final long serialVersionUID = 1071723952695168321L;
        private final WallGeom.Alignment d_alignment;

        public AlignmentAction(String desc, WallGeom.Alignment alignment) {
            super(desc, alignment == DrawWallGeomTool.this.d_alignment);
            this.d_alignment = alignment;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawWallGeomTool.this.setAlignment(this.d_alignment);
            }
        }
    }

    protected class CloseAction
    extends guiAction {
        private static final long serialVersionUID = -1783748032522181284L;

        public CloseAction() {
            super(Intl.intl("&Close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrawWallGeomTool.this.getClickHistory().addPoint(((DrawWallGeomTool)DrawWallGeomTool.this).getClickHistory().getHistory().getFirst().snap, true);
        }
    }
}

