/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import pyrosim.PyroSim;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DefaultIsectFilter;
import pyrosim.mv.tools.DrawProps;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.tools.AdvancedTool;

public abstract class ADrawTool
extends APyroTool
implements ValueEditor.IListener {
    private final List<Listener> d_listeners = new ArrayList<Listener>();

    public ADrawTool(IToolController mv, DrawProps toolProps, DrawProps.GeomSpace geomSpace) {
        this(mv, toolProps, new AdvancedTool.ToolFunc(), geomSpace);
    }

    public ADrawTool(IToolController mv, DrawProps toolProps, IToolFunction func, DrawProps.GeomSpace geomSpace) {
        super(mv, toolProps, func);
        toolProps.set(DrawProps.GEOM_SPACE, geomSpace);
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, ADrawTool.getDefaultFilter());
        toolProps.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ADrawTool.this.fireUpdateProps();
            }
        });
    }

    public static DefaultIsectFilter getDefaultFilter() {
        DefaultIsectFilter filter = new DefaultIsectFilter();
        filter.obj = obj -> TVEntryPoints.ep(obj).isDrawingSnappable(PyroSim.getApp().getMediator(), obj);
        return filter;
    }

    public abstract Class<? extends IGeom> getGeomType();

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    public void addListener(Listener listener) {
        if (!this.d_listeners.contains(listener)) {
            this.d_listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.d_listeners.remove(listener);
    }

    protected void fireRemove(int id) {
        for (Listener listener : this.d_listeners) {
            listener.remove(id);
        }
    }

    protected void fireUpdate(int id, IGeomNode geom, IPropsSrc displayProps) {
        for (Listener listener : this.d_listeners) {
            listener.updateGeom(id, geom, displayProps);
        }
    }

    protected void fireUpdateProps() {
        for (Listener listener : this.d_listeners) {
            listener.updateProps();
        }
    }

    protected void fireFinish(boolean commit) {
        for (Listener listener : this.d_listeners) {
            listener.finish(commit);
        }
    }

    protected boolean useQuickRepaint() {
        return true;
    }

    @Override
    public void finish() {
        this.reset();
        super.finish();
    }

    @Override
    public boolean cancel() {
        this.reset();
        return super.cancel();
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        ValueEditorUtil.configure(editor, "LOCATION", "OFFSET");
    }

    @Override
    protected String getStatusMessage() {
        return this.getValueEditor().getStatusMessage();
    }

    @Override
    public void valueEditorChanged(ValueEditor editor, boolean commit) {
        this.valueEditorChangedHelper(editor, commit);
    }

    public static interface Listener {
        public void updateGeom(int var1, IGeomNode var2, IPropsSrc var3);

        public void updateProps();

        public void remove(int var1);

        public void finish(boolean var1);
    }
}

