/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import pyrosim.PyroMod;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.transformpreview.BasicTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;

public abstract class APyroDisplayMgr<T, D extends IPyroDisplay>
implements IPyroDisplayMgr<T>,
Observer {
    private final PyroMod d_mediator;
    private final ModelView d_mv;
    private TargetSceneMap d_scenes;
    private final Map<T, D> d_displayMap;
    private final Map<Class<?>, Count> d_typeCounts;
    private final DisplayFilter d_displayFilter;
    private final IPyroDisplayMgr.ObjFilter<T> d_filter;
    private Optional<RTreef<T>> d_search = Optional.empty();

    protected abstract D createDisplay(T var1, boolean var2, boolean var3);

    protected abstract boolean isVisible(T var1);

    public static TargetSceneMap newSceneMap(ModelScene normalScene) {
        return t -> {
            switch (t) {
                case NORMAL: {
                    return Optional.of(normalScene);
                }
            }
            return Optional.empty();
        };
    }

    public APyroDisplayMgr(PyroMod mod, ModelView mv, TargetSceneMap scenes, Class<T> type, DisplayFilter dispFilter) {
        this(mod, mv, scenes, dispFilter, new IPyroDisplayMgr.ObjFilter<T>(type));
    }

    public APyroDisplayMgr(PyroMod mod, ModelView mv, TargetSceneMap scenes, DisplayFilter dispFilter, IPyroDisplayMgr.ObjFilter<T> filter) {
        this.d_mediator = mod;
        this.d_mv = mv;
        this.d_scenes = scenes;
        this.d_displayMap = new IdentityHashMap<T, D>();
        this.d_typeCounts = new HashMap();
        this.d_displayFilter = dispFilter;
        if (this.d_displayFilter != null) {
            this.d_displayFilter.addWeakObserver(this);
        }
        this.d_filter = filter;
    }

    public void setSearchTreeEnabled(boolean enabled, boolean updateAllObjsOnEnable) {
        if (enabled && !this.d_search.isPresent()) {
            this.d_search = Optional.of(new RTreef());
            if (updateAllObjsOnEnable) {
                for (Map.Entry<T, D> entry : this.getDisplayMap().entrySet()) {
                    this.addSearch(entry.getKey(), (IPyroDisplay)entry.getValue());
                }
            }
        } else if (!enabled) {
            this.d_search = Optional.empty();
        }
    }

    @Override
    public Optional<RTreef<T>> getSearchTree() {
        return this.d_search;
    }

    protected void addSearch(T obj, D disp) {
        this.d_search.ifPresent(r -> r.insert(disp.getBounds().toAABoxf(), obj));
    }

    protected void removeSearch(T obj, D disp) {
        this.d_search.ifPresent(r -> r.remove(obj));
    }

    protected void updateSearch(T obj, D disp) {
        this.d_search.ifPresent(r -> {
            r.remove(obj);
            r.insert(disp.getBounds().toAABoxf(), obj);
        });
    }

    @Override
    public IPickable getPicker(T obj) {
        if (this.d_search.isPresent()) {
            return this.getDisplay(obj);
        }
        return obj instanceof IPickable ? (IPickable)obj : null;
    }

    @Override
    public IPyroDisplayMgr.ObjFilter<T> getObjFilter() {
        return this.d_filter;
    }

    @Override
    public void updateClipping(ClippingManager clipMgr) {
    }

    protected Collection<? extends Class<?>> getFilterTypes() {
        return this.d_typeCounts.keySet();
    }

    public ModelView getMV() {
        return this.d_mv;
    }

    protected void repaint() {
        this.d_mv.getRenderComp().repaint();
    }

    protected List<D> getDisplays(Collection<? extends T> objs) {
        ArrayList<IPyroDisplay> displays = new ArrayList<IPyroDisplay>(objs.size());
        for (T obj : objs) {
            IPyroDisplay disp = (IPyroDisplay)this.d_displayMap.get(obj);
            if (disp == null) continue;
            displays.add(disp);
        }
        return displays;
    }

    protected List<IDisplayable> getDisplays(RenderTarget target, Collection<D> disps) {
        ArrayList<IDisplayable> displays = new ArrayList<IDisplayable>(disps.size());
        for (IPyroDisplay obj : disps) {
            obj.getDisplayObjs(target, displays);
        }
        return displays;
    }

    @Override
    public void addToScene(Collection<? extends T> objs) {
        this.addDisplays(this.d_scenes, objs, (Collection<D>)this.getDisplays(objs));
    }

    @Override
    public void removeFromScene(Collection<? extends T> objs) {
        this.removeDisplays(this.d_scenes, (Collection<D>)this.getDisplays(objs));
    }

    protected void addDisplays(Function<RenderTarget, Optional<ModelScene>> scenes, Collection<? extends T> objs, Collection<D> disps) {
        for (RenderTarget target : RenderTarget.values()) {
            scenes.apply(target).ifPresent(scene -> scene.addObjects(this.getDisplays(target, disps)));
        }
    }

    protected void removeDisplays(Function<RenderTarget, Optional<ModelScene>> scenes, Collection<D> disps) {
        for (RenderTarget target : RenderTarget.values()) {
            scenes.apply(target).ifPresent(scene -> scene.removeObjects(this.getDisplays(target, disps)));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.d_displayFilter != null && o == this.d_displayFilter && arg != null) {
            Class affectedClass = (Class)arg;
            for (Class<?> filterType : this.getFilterTypes()) {
                if (!affectedClass.isAssignableFrom(filterType) && !filterType.isAssignableFrom(affectedClass)) continue;
                this.filterChanged(this.d_displayFilter, affectedClass);
                break;
            }
        }
    }

    protected void filterChanged(DisplayFilter filter, Class type) {
        for (Map.Entry<T, D> entry : this.d_displayMap.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey().getClass())) continue;
            this.updateVisibility(entry.getKey(), (IPyroDisplay)entry.getValue());
        }
    }

    protected DisplayFilter getFilter() {
        return this.d_displayFilter;
    }

    protected boolean isFiltered(Object obj) {
        return this.d_displayFilter != null && this.d_displayFilter.filter(obj);
    }

    public D getDisplay(T obj) {
        return (D)((IPyroDisplay)this.d_displayMap.get(obj));
    }

    public PyroMod getMediator() {
        return this.d_mediator;
    }

    @Override
    public Function<RenderTarget, Optional<ModelScene>> getScenes() {
        return this.d_scenes;
    }

    protected Map<T, D> getDisplayMap() {
        return this.d_displayMap;
    }

    public void setScene(TargetSceneMap scenes) {
        if (scenes == this.d_scenes) {
            return;
        }
        this.removeDisplays(this.d_scenes, this.d_displayMap.values());
        this.d_scenes = scenes;
        this.addDisplays(this.d_scenes, (Collection<? extends T>)this.d_displayMap.keySet(), this.d_displayMap.values());
    }

    @Override
    public void removeAll() {
        this.removeDisplays(this.d_scenes, this.d_displayMap.values());
        this.disposeDisplays(this.d_displayMap.values());
        this.d_displayMap.clear();
        this.d_typeCounts.clear();
    }

    private void disposeDisplays(Collection<D> displays) {
        ArrayList disps = new ArrayList(1);
        for (RenderTarget t : RenderTarget.values()) {
            ((Optional)this.d_scenes.apply(t)).ifPresent(scene -> {
                for (IPyroDisplay disp : displays) {
                    disp.getDisplayObjs(t, disps);
                    for (IDisplayable dispObj : disps) {
                        dispObj.dispose();
                    }
                    disps.clear();
                }
            });
        }
    }

    @Override
    public void updateAll() {
        this.updateDisplays(this.getObjs());
    }

    public Collection<T> getObjs() {
        return this.d_displayMap.keySet();
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        IEventRecord objEvts = events.getEvents(this.d_filter.acceptType, this.d_filter.rejectTypes).filter(this.d_filter.filter);
        Set added = objEvts.getAddedObjs();
        Set removed = objEvts.getRemovedObjs();
        this.addDisplays(added);
        this.removeDisplays(removed);
        this.updateDisplays(events, objEvts);
    }

    public void addDisplays(T ... objs) {
        this.addDisplays((Collection<? extends T>)Arrays.asList(objs));
    }

    @Override
    public void addDisplays(Collection<? extends T> objs) {
        if (objs.isEmpty()) {
            return;
        }
        ArrayList<D> newDisplays = new ArrayList<D>(objs.size());
        for (T obj : objs) {
            D display = this.createDisplay(obj, this.isVisible(obj), this.isSelected(obj));
            if (display == null) continue;
            this.addDisplay(obj, display);
            newDisplays.add(display);
        }
        this.addDisplays(this.d_scenes, (Collection<? extends T>)objs, (Collection<D>)newDisplays);
    }

    public void removeDisplays(T ... objs) {
        this.removeDisplays((Collection<? extends T>)Arrays.asList(objs));
    }

    @Override
    public void removeDisplays(Collection<? extends T> objs) {
        if (objs.isEmpty()) {
            return;
        }
        ArrayList<D> toDelete = new ArrayList<D>(objs.size());
        for (T obj : objs) {
            D disp = this.removeDisplay(obj);
            if (disp == null) continue;
            toDelete.add(disp);
        }
        this.removeDisplays(this.d_scenes, (Collection<D>)toDelete);
        this.disposeDisplays(toDelete);
    }

    protected void addDisplay(T obj, D display) {
        IPyroDisplay oldVal = (IPyroDisplay)this.d_displayMap.put(obj, display);
        if (oldVal == null) {
            this.addSearch(obj, display);
            this.incrementCount(obj.getClass());
        } else {
            this.updateSearch(obj, display);
        }
    }

    protected D removeDisplay(T obj) {
        IPyroDisplay disp = (IPyroDisplay)this.d_displayMap.remove(obj);
        if (disp != null) {
            this.removeSearch(obj, disp);
            this.decrementCount(obj.getClass());
        }
        return (D)disp;
    }

    private void incrementCount(Class<?> type) {
        Count count = this.d_typeCounts.get(type);
        if (count == null) {
            count = new Count();
            this.d_typeCounts.put(type, count);
        }
        ++count.val;
    }

    private void decrementCount(Class<?> type) {
        Count count = this.d_typeCounts.get(type);
        if (count != null) {
            --count.val;
            if (count.val <= 0) {
                this.d_typeCounts.remove(type);
            }
        }
    }

    protected void updateDisplays(Events gevents, IEventRecord<T> events) {
        Set<T> visObjs = events.getChangedObjs(PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_ENABLED_CHANGED);
        Set<T> selObjs = events.getChangedObjs(PyroMod.EVT_SEL);
        Set<T> genObjs = this.getUpdateObjs(gevents, events);
        if (!genObjs.isEmpty()) {
            IdentityHashSet<T> tobjs = new IdentityHashSet<T>(visObjs);
            tobjs.removeAll(genObjs);
            visObjs = tobjs;
            tobjs = new IdentityHashSet<T>(selObjs);
            tobjs.removeAll(genObjs);
            selObjs = tobjs;
        }
        this.updateVisibility(visObjs);
        this.updateSelection(selObjs);
        this.updateDisplays(genObjs);
        if (events.isModified() || !genObjs.isEmpty()) {
            this.repaint();
        }
    }

    protected Set<? extends T> getUpdateObjs(Events gevents, IEventRecord<T> events) {
        return events.getChangedNotOfType(PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_SEL);
    }

    @Override
    public void updateDisplays(Collection<? extends T> objs) {
        for (T obj : objs) {
            D disp = this.getDisplay(obj);
            if (disp == null) continue;
            this.updateDisplay(obj, disp);
        }
    }

    protected void updateDisplay(T obj, D disp) {
        disp.update();
        this.updateSelection(obj, disp);
        this.updateVisibility(obj, disp);
        this.updateSearch(obj, disp);
    }

    @Override
    public void updateVisibility(Collection<? extends T> objs) {
        for (T obj : objs) {
            D display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateVisibility(obj, display);
        }
    }

    protected void updateVisibility(T obj, D display) {
        display.setVisible(this.isVisible(obj));
    }

    protected void updateSelection(Collection<? extends T> objs) {
        for (T obj : objs) {
            D display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateSelection(obj, display);
        }
    }

    protected void updateSelection(T obj, D display) {
        display.setSelected(this.isSelected(obj));
    }

    protected boolean isSelected(T obj) {
        return this.d_mediator.getSelectionModel().isSelected(obj) || !this.isVisible(obj) && this.d_mv != null && this.d_mv.isInteractive(obj);
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super T> copyMgr, Collection<? extends T> objs, boolean copyMode) {
        return new BasicTransformPreview<T>(this, copyMgr, objs, copyMode);
    }

    private static class Count {
        public int val = 0;

        private Count() {
        }

        public String toString() {
            return Integer.toString(this.val);
        }
    }

    public static interface TargetSceneMap
    extends Function<RenderTarget, Optional<ModelScene>> {
    }
}

