/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;

public class SetMetrics
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Hashtable<Class, Set<Object>> d_hash = new Hashtable();
    private final boolean d_identityHashes;

    public SetMetrics() {
        this(Collections.EMPTY_SET);
    }

    public SetMetrics(Collection s) {
        this(s, true);
    }

    public SetMetrics(boolean identityHashes) {
        this(Collections.EMPTY_SET, identityHashes);
    }

    public SetMetrics(Collection s, boolean identityHashes) {
        this.d_identityHashes = identityHashes;
        for (Object o : s) {
            this.add(o);
        }
    }

    protected <T> Set<T> newSet() {
        return this.d_identityHashes ? new LinkedIdentityHashSet() : new LinkedHashSet();
    }

    public boolean add(Object obj) {
        return this.addEntry(obj.getClass(), obj);
    }

    public boolean contains(Object obj) {
        Set<Object> vals = this.d_hash.get(obj.getClass());
        if (vals != null) {
            return vals.contains(obj);
        }
        return false;
    }

    public boolean remove(Object obj) {
        return this.removeEntry(obj.getClass(), obj);
    }

    public void clear() {
        this.d_hash.clear();
    }

    private boolean removeEntry(Class clazz, Object obj) {
        Set<Object> vals = this.d_hash.get(clazz);
        if (vals == null) {
            return false;
        }
        boolean removed = vals.remove(obj);
        if (vals.isEmpty()) {
            this.d_hash.remove(clazz);
        }
        return removed;
    }

    private boolean addEntry(Class clazz, Object obj) {
        Set<Object> objs = this.d_hash.get(clazz);
        if (objs == null) {
            objs = this.newSet();
            this.d_hash.put(clazz, objs);
        }
        return objs.add(obj);
    }

    public <T> Set<T> filter(Class<? extends T> ... clazzes) {
        return this.filter(new DefFilter<T>(clazzes));
    }

    public <T> Set<T> filter(IFilter<T> c) {
        Set<T> found = this.newSet();
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    T obj = clazz.cast(o);
                    if (!c.objectPasses(obj)) continue;
                    found.add(obj);
                }
            }
        }
        return found;
    }

    public <T> boolean isEmpty(IFilter<T> c) {
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    if (!c.objectPasses(clazz.cast(o))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public <T> int count(IFilter<T> c) {
        int count = 0;
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    if (!c.objectPasses(clazz.cast(o))) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public int getNum(Class ... clazzes) {
        return this.count(new DefFilter(clazzes));
    }

    public boolean isEmpty() {
        for (Set<Object> set : this.d_hash.values()) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isExclusiveSingle(Class clazz) {
        return this.getNum(Object.class) == 1 && this.getNum(clazz) == 1;
    }

    public boolean isExclusive(Class ... clazzes) {
        boolean isPresent = false;
        for (Class key : this.d_hash.keySet()) {
            boolean keyIsPresent = false;
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(key)) continue;
                keyIsPresent = true;
                break;
            }
            if (!keyIsPresent) {
                return false;
            }
            isPresent = true;
        }
        return isPresent;
    }

    public static final class DefFilter<T>
    extends AFilter<T> {
        public DefFilter(Class<? extends T> ... clazzes) {
            super(clazzes);
        }

        @Override
        public final boolean objectPasses(T obj) {
            return true;
        }

        @Override
        public boolean reset() {
            return false;
        }
    }

    public static abstract class AFilter<T>
    implements IFilter<T> {
        private final Class<? extends T>[] d_clazzes;

        public AFilter(Class<? extends T> ... clazzes) {
            this.d_clazzes = clazzes;
        }

        @Override
        public Class<? extends T>[] getClazzes() {
            return this.d_clazzes;
        }
    }

    public static interface IFilter<T> {
        public boolean objectPasses(T var1);

        public Class<? extends T>[] getClazzes();

        public boolean reset();
    }
}

