/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ListMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Object[] s_emptyList = new Object[0];
    private Object[] d_list = s_emptyList;

    public ListMap() {
        this(Collections.EMPTY_MAP);
    }

    public ListMap(Map<K, V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.d_list.length / 2;
    }

    @Override
    public void clear() {
        this.d_list = s_emptyList;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIndex(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int m = 1; m < this.d_list.length; m += 2) {
            Object v = this.d_list[m];
            if (!theUtil.equal(v, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            return (ListMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.d_list.length == 0;
    }

    @Override
    public V get(Object key) {
        int ki = this.keyIndex(key);
        return (V)(ki != -1 ? this.d_list[ki + 1] : null);
    }

    @Override
    public V put(K key, V value) {
        int ki = this.keyIndex(key);
        if (ki == -1) {
            this.add(key, value);
            return null;
        }
        Object old = this.d_list[ki + 1];
        this.d_list[ki + 1] = value;
        return (V)old;
    }

    private void add(K key, V value) {
        Object[] newList = new Object[this.d_list.length + 2];
        for (int m = 0; m < this.d_list.length; ++m) {
            newList[m] = this.d_list[m];
        }
        newList[newList.length - 2] = key;
        newList[newList.length - 1] = value;
        this.d_list = newList;
    }

    @Override
    public V remove(Object key) {
        int ki = this.keyIndex(key);
        if (ki != -1) {
            Object old = this.d_list[ki + 1];
            this.remove(ki);
            if (this.d_list.length == 0) {
                this.d_list = s_emptyList;
            }
            return (V)old;
        }
        return null;
    }

    private void remove(int keyIndex) {
        int m;
        Object[] newList = new Object[this.d_list.length - 2];
        for (m = 0; m < keyIndex; ++m) {
            newList[m] = this.d_list[m];
        }
        for (m = keyIndex + 2; m < this.d_list.length; ++m) {
            newList[m - 2] = this.d_list[m];
        }
        this.d_list = newList;
    }

    private int keyIndex(Object key) {
        for (int m = 0; m < this.d_list.length; m += 2) {
            Object k = this.d_list[m];
            if (!theUtil.equal(k, key)) continue;
            return m;
        }
        return -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        return new VSet(0);
    }

    @Override
    public Collection<V> values() {
        return new VSet(1);
    }

    private class VIterator<ValT>
    implements Iterator<ValT>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int d_index;

        public VIterator(int offset) {
            this.d_index = offset;
        }

        @Override
        public boolean hasNext() {
            return this.d_index < ListMap.this.d_list.length;
        }

        @Override
        public ValT next() {
            Object v = ListMap.this.d_list[this.d_index];
            this.d_index += 2;
            return (ValT)v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class VSet<ValT>
    extends AbstractSet<ValT>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int d_offset;

        public VSet(int offset) {
            this.d_offset = offset;
        }

        @Override
        public Iterator<ValT> iterator() {
            return new VIterator(this.d_offset);
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }
    }

    private static class Entry<K, V>
    extends Pair<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public Entry(K v1, V v2) {
            super(v1, v2);
        }

        @Override
        public K getKey() {
            return (K)this.v1;
        }

        @Override
        public V getValue() {
            return (V)this.v2;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int d_index = 0;

        @Override
        public boolean hasNext() {
            return this.d_index < ListMap.this.d_list.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = ListMap.this.d_list[this.d_index++];
            Object val = ListMap.this.d_list[this.d_index++];
            return new Entry<Object, Object>(key, val);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }
    }
}

