/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilterMgr {
    public static final IObjectFilter FILTER_ALL = FilterAll.INSTANCE;
    private final Events d_events;
    private final Map<Class, IObjectFilter> d_filters = new HashMap<Class, IObjectFilter>();
    private final Map<Class, IObjectFilter> d_cachedFilters = new HashMap<Class, IObjectFilter>();

    public FilterMgr(Events evts) {
        this.d_events = evts;
    }

    protected void changed(Class type) {
        this.d_cachedFilters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, type);
        }
    }

    public <T> void registerFilter(Class<T> clazz, IObjectFilter<? extends T> filter) {
        IObjectFilter<? extends T> old;
        assert (filter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        if (filter.equals(FILTER_ALL) && !filter.equals(old = this.d_filters.put(clazz, filter))) {
            this.changed(clazz);
            return;
        }
        IObjectFilter oldFilter = this.d_filters.get(clazz);
        if (oldFilter instanceof CompositeFilter) {
            if (((CompositeFilter)oldFilter).add(filter)) {
                this.changed(clazz);
            }
        } else if (oldFilter != null && !filter.equals(oldFilter)) {
            CompositeFilter newFilter = new CompositeFilter(oldFilter, filter);
            this.d_filters.put(clazz, newFilter);
            this.changed(clazz);
        } else {
            this.d_filters.put(clazz, filter);
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> type) {
        this.registerFilter(type, FilterAll.INSTANCE);
    }

    public <T> void removeFilter(Class<T> clazz, IObjectFilter<T> filter) {
        IObjectFilter existing = this.d_filters.get(clazz);
        if (existing instanceof CompositeFilter) {
            CompositeFilter cf = (CompositeFilter)existing;
            if (cf.remove(filter)) {
                if (cf.d_filters.size() == 1) {
                    this.d_filters.put(clazz, cf.d_filters.get(0));
                }
                this.changed(clazz);
            }
        } else if (filter.equals(existing)) {
            this.d_filters.remove(clazz);
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class type) {
        IObjectFilter filter = this.getFilter(type);
        return filter instanceof FilterAll;
    }

    public boolean filter(Object obj) {
        IObjectFilter filter = this.getFilter(obj.getClass());
        if (filter == null) {
            return false;
        }
        return filter.shouldFilter(obj);
    }

    private IObjectFilter getFilter(Class clazz) {
        if (this.d_cachedFilters.containsKey(clazz)) {
            return this.d_cachedFilters.get(clazz);
        }
        IObjectFilter filter = this.calculateFilter(clazz);
        this.d_cachedFilters.put(clazz, filter);
        return filter;
    }

    private IObjectFilter calculateFilter(Class clazz) {
        IObjectFilter filter = this.d_filters.get(clazz);
        if (filter != null) {
            return filter;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (filter = this.calculateFilter(superClass)) != null) {
            return filter;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            filter = this.calculateFilter(iface);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public void reset() {
        this.d_filters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, new Object[0]);
        }
    }

    private static class FilterAll<T>
    implements IObjectFilter<T> {
        public static final FilterAll INSTANCE = new FilterAll();

        private FilterAll() {
        }

        @Override
        public boolean shouldFilter(T o) {
            return true;
        }
    }

    private static class CompositeFilter<T>
    implements IObjectFilter<T> {
        private final List<IObjectFilter<T>> d_filters;

        public CompositeFilter(IObjectFilter<T> ... filters) {
            this.d_filters = new ArrayList<IObjectFilter<T>>(Arrays.asList(filters));
        }

        public boolean add(IObjectFilter<T> filter) {
            int ix = this.d_filters.indexOf(filter);
            if (ix < 0) {
                this.d_filters.add(filter);
                return true;
            }
            return false;
        }

        public boolean remove(IObjectFilter<T> filter) {
            return this.d_filters.remove(filter);
        }

        @Override
        public boolean shouldFilter(T o) {
            for (IObjectFilter<T> filter : this.d_filters) {
                if (!filter.shouldFilter(o)) continue;
                return true;
            }
            return false;
        }
    }
}

