/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.license;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.AbstractCommand;
import pyrosim.legacy_2012_1.thunderheadeng.gui.CmdButton;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiTFWithButton;
import pyrosim.legacy_2012_1.thunderheadeng.license.ClipboardTextArea;
import pyrosim.legacy_2012_1.thunderheadeng.license.LMReturn;
import pyrosim.legacy_2012_1.thunderheadeng.license.LicenseManager;
import thunderheadeng.gui.Application;

public class KillLicenseDlg
extends guiDialog {
    private static final long serialVersionUID = 7706245650674597916L;
    private guiTFWithButton d_confCode;
    private CmdButton d_killButton;
    private LicenseManager d_ck;
    private boolean d_killed;

    public KillLicenseDlg(LicenseManager mgr) {
        super((Window)null, Intl.intl("Remove License"), 0x10 | (Application.getApp().getDocument() == null ? 0 : 32));
        this.setHelpIDString("kill_license");
        this.d_ck = mgr;
        this.d_killed = false;
    }

    @Override
    public int doModal() {
        guiPanel c = this.getDialogPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(c, new MultiLineLabel(this.d_ck.getLicenseDesc()), 0, row++, 2, 1, 6, 0, 0, 0);
        MultiLineLabel msg = new MultiLineLabel(Intl.intl("ATTENTION! Clicking 'Remove Now' will destroy the license on this computer.  You will not be able to run the program again until you obtain a new license from Thunderhead Engineering Consultants. You MUST provide Thunderhead with the Confirmation Code (shown after removing the license) to receive a new Site Key."));
        GridBagUtil.add(c, msg, 0, row++, 2, 1, 12, 0, 0, 0);
        this.d_killButton = new CmdButton(new KillNowCmd());
        GridBagUtil.add(c, this.d_killButton, 0, row++, 3, 1, 18, 0, 0, 0, 0, 0.0, 0.0, 10);
        GridBagUtil.add(c, new guiLabel(Intl.intl("Confirmation Code")), 0, row, 1, 1, 18, 0, 0, 0, 3, 0.0, 1.0, 17);
        this.d_confCode = new guiTFWithButton(new ClipboardTextArea());
        this.d_confCode.getTextField().setEditable(false);
        this.d_confCode.setButtonCommand(new guiTFWithButton.CopyCmd(this.d_confCode.getTextField()));
        int h = (int)this.d_confCode.getPreferredSize().getHeight();
        this.d_confCode.setPreferredSize(new Dimension(250, h));
        GridBagUtil.add(c, this.d_confCode, 1, row, 1, 1, 18, 12, 0, 0, 2, 1.0, 0.0, 17);
        this.pack();
        int ret = super.doModal();
        if (ret == 16 && this.d_killed) {
            Application.getApp().quit(false);
        }
        return ret;
    }

    class KillNowCmd
    extends AbstractCommand {
        public KillNowCmd() {
            super(Intl.intl("Remove Now"), "");
        }

        @Override
        public String helpText() {
            return Intl.intl("Destroy authorization to run the software on this computer");
        }

        @Override
        public boolean isEnabled() {
            return !KillLicenseDlg.this.d_killed;
        }

        @Override
        public void execute() {
            boolean really;
            boolean bl = really = JOptionPane.showConfirmDialog(KillLicenseDlg.this, Intl.intl("Permenantly Terminate this Installation of Petrasim?"), Intl.intl("Remove License"), 2) == 0;
            if (!really) {
                return;
            }
            LMReturn ret = KillLicenseDlg.this.d_ck.killLicense();
            KillLicenseDlg.this.d_ck.getAuthorization(0);
            String conf = null;
            if (ret.success()) {
                conf = ret.getMessage();
                KillLicenseDlg.this.d_confCode.getTextField().setText(conf);
                KillLicenseDlg.this.d_killed = true;
            } else {
                JOptionPane.showMessageDialog(KillLicenseDlg.this, Intl.intl("Error removing license") + " (" + ret.getError() + ")\n" + ret.getMessage(), Intl.intl("Couldn't Remove License"), 0);
            }
            if (conf != null) {
                try {
                    FileWriter w = new FileWriter("KillConf.txt", true);
                    w.write(conf);
                    w.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(KillLicenseDlg.this, Intl.intl("WARNING: Failed to write Confirmation Code to a file, so BE\nSURE TO WRITE IT DOWN. Thunderhead Engineering cannot issue\nyou a replacement Site Key if you don't provide the correct\nConfirmation Number.\n\nConfirmation Code:") + conf, Intl.intl("Important"), 2);
                }
            }
            KillLicenseDlg.this.d_killButton.updateEnabled();
        }
    }
}

