/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiField;

public class guiTextField
extends guiField {
    private static final long serialVersionUID = -6437890900648627242L;
    private String d_value;
    private int d_minChars;
    private int d_maxChars;
    private boolean d_rangeCheck;
    private boolean d_modified;

    public guiTextField() {
        this.init();
        this.setValue("");
    }

    public guiTextField(String value) {
        this.init();
        this.setValue(value);
    }

    private void init() {
        this.d_value = "";
        this.d_minChars = 0;
        this.d_maxChars = Integer.MAX_VALUE;
        this.d_rangeCheck = false;
        this.d_modified = false;
        this.setHorizontalAlignment(2);
    }

    public void setValue(String value) {
        String tmpValue;
        String string = tmpValue = value == null ? "" : value;
        if (this.d_rangeCheck && !this.rangeCheck(tmpValue)) {
            String msg = "Value out of range in guiTextField.setValue()";
            throw new IllegalArgumentException(msg);
        }
        super.setText(tmpValue);
        this.d_value = tmpValue;
    }

    @Override
    public void setText(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this.d_value;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!this.shouldValidate()) {
            return true;
        }
        try {
            String newValue = this.getText();
            if (this.d_rangeCheck && !this.rangeCheck(newValue)) {
                throw new Exception();
            }
            if (allowModify) {
                if (!this.d_value.equals(newValue)) {
                    this.d_modified = true;
                }
                this.d_value = newValue;
            }
            return true;
        }
        catch (Exception e) {
            if (showWarn) {
                String msg = Intl.intl("The entry ") + "\"" + this.getText() + "\"" + Intl.intl("is invalid.");
                if (this.d_rangeCheck) {
                    msg = msg + "\nPlease enter an expression containing " + this.d_minChars + " to " + this.d_maxChars + " characters.";
                }
                this.showMessageBox(msg);
                this.requestFocusHack();
            }
            return false;
        }
    }

    private boolean rangeCheck(String value) {
        return value.length() >= this.d_minChars && value.length() <= this.d_maxChars;
    }

    @Override
    public boolean isModified() {
        if (this.d_modified) {
            return true;
        }
        String newValue = this.getText();
        return !this.d_value.equals(newValue);
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void setMinChars(int min) {
        this.d_minChars = min;
    }

    public void setMaxChars(int max) {
        this.d_maxChars = max;
    }

    public void setRangeCheck(boolean check) {
        this.d_rangeCheck = check;
    }
}

