/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class guiFormattedFld<T>
extends JFormattedTextField
implements Modifiable,
Validateable {
    private static final long serialVersionUID = 5328550564285487691L;
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll;
    private boolean d_modified;
    private boolean d_selectAllOnFocusEnabled;
    private PropertyChangeListener d_highlightOnErrorListener;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;

    public guiFormattedFld(Format format) {
        this(format, null);
    }

    public guiFormattedFld(Format format, T initValue) {
        this(new Formatter(format), initValue);
    }

    public guiFormattedFld(Formatter<T> formatter) {
        this(formatter, null);
    }

    public guiFormattedFld(Formatter<T> formatter, T initValue) {
        this((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(formatter), initValue);
    }

    public guiFormattedFld(JFormattedTextField.AbstractFormatterFactory formatterFactory, T initValue) {
        super(new FormatterFactory(formatterFactory, false));
        this.init(initValue);
    }

    private void init(T initValue) {
        this.d_selectAll = true;
        this.d_selectAllOnFocusEnabled = true;
        this.d_highlightOnErrorListener = null;
        Dimension d = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, d.height));
        this.setHorizontalAlignment(2);
        this.setInputVerifier(new Verifier(true));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                guiFormattedFld.this.d_selectAll = false;
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                Component c = e.getComponent();
                if (c.isEnabled() && e.isPopupTrigger()) {
                    JPopupMenu menu = guiFormattedFld.this.getRightClickMenu();
                    menu.setLocation(e.getPoint());
                    menu.show(c, e.getX(), e.getY());
                }
            }
        });
        this.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!theUtil.equal(evt.getOldValue(), evt.getNewValue())) {
                    guiFormattedFld.this.d_modified = true;
                }
            }
        });
        this.setHighlightOnError(true);
        this.setFocusLostBehavior(0);
        this.setValue(initValue);
        this.setModified(false);
    }

    public void setHighlightOnError(boolean highlight) {
        if (highlight && this.d_highlightOnErrorListener == null) {
            this.d_highlightOnErrorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    guiFormattedFld.this.updateValidState();
                }
            };
            this.addPropertyChangeListener("editValid", this.d_highlightOnErrorListener);
        } else if (!highlight && this.d_highlightOnErrorListener != null) {
            this.removePropertyChangeListener("editValid", this.d_highlightOnErrorListener);
            this.d_highlightOnErrorListener = null;
        }
        this.updateValidState();
    }

    public boolean getHightlightOnError() {
        return this.d_highlightOnErrorListener != null;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.isTemporary()) {
            return;
        }
        if (e.getID() == 1005) {
            this.d_selectAll = true;
        } else if (this.d_selectAllOnFocusEnabled && this.d_selectAll) {
            this.selectAll();
        }
    }

    protected void updateValidState() {
        if (!this.getHightlightOnError() || this.isEditValid()) {
            Border border = this.getBorder();
            if (border instanceof InvalidBorder) {
                InvalidBorder iborder = (InvalidBorder)border;
                Border existing = iborder.getInsideBorder();
                this.setBorder(existing);
            }
        } else {
            Border border = this.getBorder();
            if (!(border instanceof InvalidBorder)) {
                this.setBorder(new InvalidBorder(border));
            }
        }
    }

    public void setSelectAllOnFocus(boolean enabled) {
        this.d_selectAllOnFocusEnabled = enabled;
    }

    public boolean getSelectAllOnFocus() {
        return this.d_selectAllOnFocusEnabled;
    }

    public void setYieldFocusOnError(boolean enabled) {
        ((Verifier)this.getInputVerifier()).setYieldFocusOnErrorEnabled(enabled);
    }

    public boolean getYieldFocusOnError() {
        return ((Verifier)this.getInputVerifier()).isYieldFocusOnErrorEnabled();
    }

    public void setCommitOnValidEdit(boolean enabled) {
        FormatterFactory current = this.getFormatterFactory();
        if (current != null) {
            current.setCommitOnValidEdit(this, enabled);
        }
    }

    public boolean getCommitOnValidEdit() {
        return this.getFormatterFactory().d_commitOnValidEdit;
    }

    public void addValueChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("value", listener);
    }

    private JPopupMenu getRightClickMenu() {
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
            cut.putValue("Name", Intl.intl("Cut"));
            DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
            copy.putValue("Name", Intl.intl("Copy"));
            DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
            paste.putValue("Name", Intl.intl("Paste"));
            AbstractAction delete = new AbstractAction(Intl.intl("Delete")){
                private static final long serialVersionUID = -1145220452963451362L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiFormattedFld.this.replaceSelection("");
                }
            };
            AbstractAction selectAll = new AbstractAction(Intl.intl("Select All")){
                private static final long serialVersionUID = 7156361685066902730L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiFormattedFld.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, cut);
            this.d_rightClickMenuActions.put(COPY, copy);
            this.d_rightClickMenuActions.put(PASTE, paste);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, delete);
            this.d_rightClickMenuActions.put(SELECT_ALL, selectAll);
            this.d_rightClickMenu.add(cut);
            this.d_rightClickMenu.add(copy);
            this.d_rightClickMenu.add(paste);
            this.d_rightClickMenu.add(delete);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(selectAll);
        }
        String selText = this.getSelectedText();
        boolean canEdit = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(COPY).setEnabled(selText != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(canEdit);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (selText == null || selText.length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public T getValue() {
        return (T)super.getValue();
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!this.shouldValidate()) {
            return true;
        }
        try {
            InputVerifier verifier = this.getInputVerifier();
            ((Verifier)verifier).check(this);
            if (allowModify) {
                this.commitEdit();
            }
        }
        catch (ParseException e) {
            if (showWarn) {
                this.showMessageBox(e.getLocalizedMessage(), true);
            }
            if (allowModify) {
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    protected boolean shouldValidate() {
        return this.isEnabled();
    }

    protected void showMessageBox(String msg) {
        this.showMessageBox(msg, false);
    }

    protected void showMessageBox(String msg, boolean removeFocusListeners) {
        int focusLostBehavior = this.getFocusLostBehavior();
        FocusListener[] listeners = null;
        if (removeFocusListeners) {
            this.setFocusLostBehavior(3);
            for (FocusListener listener : listeners = this.getFocusListeners()) {
                this.removeFocusListener(listener);
            }
        }
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("Invalid Entry"), 2);
        if (removeFocusListeners) {
            for (FocusListener listener : listeners) {
                this.addFocusListener(listener);
            }
            this.setFocusLostBehavior(focusLostBehavior);
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiFormattedFld.this.requestFocus();
            }
        });
    }

    @Override
    @Deprecated
    public final void setInputVerifier(InputVerifier inputVerifier) {
        if (!(inputVerifier instanceof Verifier)) {
            return;
        }
        this.setInputVerifier((Verifier)inputVerifier);
    }

    public void setInputVerifier(Verifier<T> inputVerifier) {
        super.setInputVerifier(inputVerifier);
    }

    @Override
    public Verifier<T> getInputVerifier() {
        return (Verifier)super.getInputVerifier();
    }

    @Override
    public JFormattedTextField.AbstractFormatter getFormatter() {
        return super.getFormatter();
    }

    @Override
    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory tf) {
        if (!(tf instanceof FormatterFactory)) {
            FormatterFactory curr = this.getFormatterFactory();
            boolean commit = curr != null ? curr.d_commitOnValidEdit : false;
            tf = new FormatterFactory(tf, commit);
        }
        super.setFormatterFactory(tf);
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return (FormatterFactory)super.getFormatterFactory();
    }

    public static class Verifier<T>
    extends InputVerifier {
        private boolean d_yieldFocusOnError;

        public Verifier(boolean yieldFocusOnError) {
            this.d_yieldFocusOnError = yieldFocusOnError;
        }

        public boolean isYieldFocusOnErrorEnabled() {
            return this.d_yieldFocusOnError;
        }

        public void setYieldFocusOnErrorEnabled(boolean enabled) {
            this.d_yieldFocusOnError = enabled;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                this.check(input);
            }
            catch (ParseException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.isYieldFocusOnErrorEnabled() || super.shouldYieldFocus(input);
        }

        public void check(JComponent input) throws ParseException {
            assert (input instanceof guiFormattedFld);
            guiFormattedFld fld = (guiFormattedFld)input;
            JFormattedTextField.AbstractFormatter formatter = fld.getFormatter();
            if (formatter != null) {
                String text = fld.getText();
                formatter.stringToValue(text);
            }
        }
    }

    public static class Formatter<T>
    extends InternationalFormatter
    implements IObserver {
        private static final long serialVersionUID = 6485261405788018218L;
        private IObjectFilter<T> d_filter;
        private boolean d_nullAllowed;

        public Formatter(Format format) {
            this(format, null, false);
        }

        public Formatter(Format format, IObjectFilter<T> filter) {
            this(format, filter, false);
        }

        public Formatter(Format format, boolean nullAllowed) {
            this(format, null, nullAllowed);
        }

        public Formatter(Format format, IObjectFilter<T> filter, boolean nullAllowed) {
            super(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
            this.d_filter = filter;
            this.d_nullAllowed = nullAllowed;
        }

        @Override
        public void update(IObservable source, Object arg) {
            JFormattedTextField fld = this.getFormattedTextField();
            if (fld != null && !fld.isFocusOwner()) {
                this.uninstall();
                this.install(fld);
            }
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Object value = super.stringToValue(text);
            if (value == null && !this.isNullAllowed()) {
                throw new ParseException(Intl.intl("Empty values are not allowed."), 0);
            }
            if (this.d_filter != null && this.d_filter.shouldFilter(value)) {
                throw new ParseException(this.d_filter.toString(), 0);
            }
            return value;
        }

        public IObjectFilter<T> getFilter() {
            return this.d_filter;
        }

        public void setFilter(IObjectFilter<T> filter) {
            this.d_filter = filter;
        }

        public boolean isNullAllowed() {
            return this.d_nullAllowed;
        }

        public void setNullAllowed(boolean allowed) {
            this.d_nullAllowed = allowed;
        }
    }

    public static class FormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        private boolean d_commitOnValidEdit;
        private JFormattedTextField.AbstractFormatterFactory d_baseFactory;

        public FormatterFactory(JFormattedTextField.AbstractFormatterFactory baseFactory, boolean commitOnValidEdit) {
            this.d_baseFactory = baseFactory;
            this.d_commitOnValidEdit = commitOnValidEdit;
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            JFormattedTextField.AbstractFormatter formatter = this.d_baseFactory.getFormatter(tf);
            this.updateFormatter(formatter);
            return formatter;
        }

        public void setCommitOnValidEdit(JFormattedTextField field, boolean enabled) {
            this.d_commitOnValidEdit = enabled;
            this.updateFormatter(field.getFormatter());
        }

        public void updateFormatter(JFormattedTextField.AbstractFormatter formatter) {
            if (formatter instanceof DefaultFormatter) {
                ((DefaultFormatter)formatter).setCommitsOnValidEdit(this.d_commitOnValidEdit);
            }
        }
    }

    protected static class InvalidBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -6494216944048832137L;

        public InvalidBorder(Border innerBorder) {
            super(BorderFactory.createLineBorder(Color.RED), innerBorder);
        }
    }
}

