/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.DlgListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.WaitCursorMgr;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.Application;

public class guiDialog
extends JDialog
implements Modifiable,
Validateable {
    private static final long serialVersionUID = -5778852173570800106L;
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int RESET = 4;
    public static final int CANCEL = 8;
    public static final int CLOSE = 16;
    public static final int HELP = 32;
    private JPanel d_btnPanel;
    private guiPanel d_dialogPane;
    protected int d_status;
    private Window d_owner = null;
    private Vector d_listeners = new Vector();
    private JButton d_helpButton;
    private JButton d_okButton;
    private JButton d_cancelButton;
    private JButton d_closeButton;
    private JButton d_resetButton;
    private JButton d_applyButton;
    protected CancelListener d_cancelListener;
    private boolean d_minimumSizeEnabled = false;
    private boolean d_disposeAfterModal = true;
    private final WaitCursorMgr d_waitCursorMgr;

    public guiDialog(Window owner) {
        this(owner, "", 0);
    }

    public guiDialog(Window owner, String title) {
        this(owner, title, 0);
    }

    public guiDialog(Window owner, String title, int buttons) {
        super(owner, title);
        this.init(owner, buttons);
        this.d_waitCursorMgr = new WaitCursorMgr(this);
    }

    private void init(Window owner, int buttons) {
        JButton button;
        this.d_owner = owner;
        this.setResizable(false);
        this.setModal(true);
        JPanel btnHolder = new JPanel(new FlowLayout(2, 0, 0));
        this.d_btnPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        btnHolder.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        btnHolder.add(this.d_btnPanel);
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)btnHolder, "South");
        this.d_cancelListener = new CancelListener();
        this.getRootPane().registerKeyboardAction(this.d_cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(this.d_cancelListener);
        if ((buttons & 2) != 0) {
            this.d_applyButton = new ApplyBtn(this);
            button = this.d_applyButton;
            this.addButton(button);
            this.getRootPane().setDefaultButton(button);
        }
        if ((buttons & 1) != 0) {
            this.d_okButton = new OkBtn(this);
            button = this.d_okButton;
            this.addButton(button);
            this.getRootPane().setDefaultButton(button);
        }
        if ((buttons & 4) != 0) {
            this.d_resetButton = new ResetBtn(this);
            button = this.d_resetButton;
            this.addButton(button);
        }
        if ((buttons & 8) != 0) {
            this.d_cancelButton = new CancelBtn(this);
            button = this.d_cancelButton;
            this.addButton(button);
        }
        if ((buttons & 0x10) != 0) {
            this.d_closeButton = new CloseBtn(this);
            button = this.d_closeButton;
            this.addButton(button);
        }
        if ((buttons & 0x20) != 0) {
            this.d_helpButton = new HelpBtn(this);
            this.addButton(this.d_helpButton);
        }
        this.setSize(0, 0);
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        this.d_waitCursorMgr.beginWaitCursor();
    }

    public void beginWaitCursor(boolean delay) {
        this.d_waitCursorMgr.beginWaitCursor(delay);
    }

    public void beginWaitCursor(int delay) {
        this.d_waitCursorMgr.beginWaitCursor(delay);
    }

    public void endWaitCursor() {
        this.d_waitCursorMgr.endWaitCursor();
    }

    public void setDialogComponent(JComponent comp) {
        this.getDialogPane().add((Component)comp, "Center");
    }

    public void setDialogComponents(JComponent[] panels, String[] names) {
        assert (panels != null && names != null);
        assert (panels.length == names.length);
        JTabbedPane tabs = new JTabbedPane();
        for (int i = 0; i < panels.length; ++i) {
            FlowLayout layout = new FlowLayout(0, 12, 12);
            guiPanel insetPanel = new guiPanel(layout);
            insetPanel.add(panels[i]);
            tabs.add(names[i], insetPanel);
        }
        this.setDialogComponent(tabs);
    }

    public JButton getButton(int button) {
        switch (button) {
            case 2: {
                return this.d_applyButton;
            }
            case 1: {
                return this.d_okButton;
            }
            case 4: {
                return this.d_resetButton;
            }
            case 8: {
                return this.d_cancelButton;
            }
            case 16: {
                return this.d_closeButton;
            }
            case 32: {
                return this.d_helpButton;
            }
        }
        return null;
    }

    public void setButtons(JComponent[] buttons) {
        this.d_btnPanel.removeAll();
        for (int i = 0; i < buttons.length; ++i) {
            this.addButton(buttons[i]);
        }
    }

    public void addButton(JComponent button) {
        JButton tmpButton = new JButton(Intl.intl("Cancel"));
        Dimension minSize = tmpButton.getPreferredSize();
        if (button.getPreferredSize().getWidth() < (double)minSize.width) {
            button.setPreferredSize(minSize);
        }
        this.d_btnPanel.add(button);
    }

    public guiPanel getDialogPane() {
        return this.d_dialogPane;
    }

    public void setHelpIDString(String id) {
    }

    public void prepareSize() {
        Dimension setSize = this.getSize();
        if (setSize.width == 0 || setSize.height == 0 || this.d_minimumSizeEnabled) {
            this.pack();
        }
        if (this.d_minimumSizeEnabled) {
            this.setMinimumSize(this.getPreferredSize());
        }
        if (setSize.width != 0 && setSize.height != 0) {
            this.setSize(setSize);
        }
    }

    private void beginShowing() {
        this.d_status = 8;
        this.prepareSize();
        this.setLocationRelativeTo(this.d_owner);
        this.setVisible(true);
    }

    public boolean doModeless() {
        if (this.isVisible()) {
            return false;
        }
        this.setModal(false);
        this.beginShowing();
        return true;
    }

    public int doModal() {
        this.setModal(true);
        this.beginShowing();
        return this.d_status;
    }

    protected void endModal(int status) {
        this.d_status = status;
        this.setVisible(false);
    }

    public void setDisposeAfterModal(boolean dispose) {
        this.d_disposeAfterModal = dispose;
    }

    public void setMinimumSizeEnabled(boolean enabled) {
        if (enabled) {
            this.enableEvents(101L);
        } else {
            this.disableEvents(101L);
        }
        this.d_minimumSizeEnabled = enabled;
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        Dimension d = this.getSize();
        Dimension minSize = this.getMinimumSize();
        if (d.width < minSize.width) {
            d.width = minSize.width;
        }
        if (d.height < minSize.height) {
            d.height = minSize.height;
        }
        this.setSize(d);
    }

    public int getStatus() {
        return this.d_status;
    }

    @Deprecated
    public final boolean validateData() throws Exception {
        throw new Exception("No. You lose.");
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return this.d_dialogPane.validateData(showWarn, allowModify);
    }

    @Override
    public boolean isModified() {
        return this.d_dialogPane.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.d_dialogPane.setModified(modified);
    }

    public void addDlgListener(DlgListener l) {
        this.d_listeners.add(l);
    }

    public void removeDlgListener(DlgListener l) {
        this.d_listeners.remove(l);
    }

    protected void fireButtonPressed(int button) {
        block8: for (int i = 0; i < this.d_listeners.size(); ++i) {
            DlgListener l = (DlgListener)this.d_listeners.get(i);
            switch (button) {
                case 1: {
                    l.okPressed();
                    continue block8;
                }
                case 2: {
                    l.applyPressed();
                    continue block8;
                }
                case 4: {
                    l.resetPressed();
                    continue block8;
                }
                case 8: {
                    l.cancelPressed();
                    continue block8;
                }
                case 16: {
                    l.closePressed();
                    continue block8;
                }
                case 32: {
                    l.helpPressed();
                    continue block8;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.d_disposeAfterModal) {
            this.dispose();
        }
    }

    protected boolean invalidateFld(boolean warn, boolean modify, guiField field, String msg) {
        if (warn) {
            this.showMessageBox(msg);
        }
        if (modify) {
            field.requestFocus();
        }
        return false;
    }

    protected void showMessageBox(String msg) {
        guiDialog.showInvalidEntryMessage(this, msg);
    }

    public static void showInvalidEntryMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, Intl.intl("Invalid Entry"), 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiDialog.this.requestFocus();
            }
        });
    }

    public void loadPreferredSize(String preferenceNameX, String preferenceNameY) {
        if (Application.getApp() != null) {
            String sizeYS;
            Dimension dim = this.getSize();
            boolean sizeChanged = false;
            String sizeXS = Application.getApp().getPreference(preferenceNameX);
            if (sizeXS != null) {
                try {
                    Integer sizeX = Integer.valueOf(sizeXS);
                    dim.width = sizeX;
                    sizeChanged = true;
                }
                catch (Exception sizeX) {
                    // empty catch block
                }
            }
            if ((sizeYS = Application.getApp().getPreference(preferenceNameY)) != null) {
                try {
                    Integer sizeY = Integer.valueOf(sizeYS);
                    dim.height = sizeY;
                    sizeChanged = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sizeChanged) {
                this.setSize(dim);
            }
        }
    }

    public void savePreferredSize(String preferenceNameX, String preferenceNameY) {
        if (Application.getApp() != null) {
            Dimension d = this.getSize();
            Application.getApp().setPreference(preferenceNameX, Integer.valueOf(d.width).toString());
            Application.getApp().setPreference(preferenceNameY, Integer.valueOf(d.height).toString());
        }
    }

    public static void main(String[] argv) {
        guiDialog dlg = new guiDialog((Window)null, "hi there", 1);
        dlg.getDialogPane().add(new JButton("Now is the time for all good men to come to the aid of their party."));
        System.out.println(dlg.doModal());
        dlg.doModal();
        dlg.doModal();
        dlg.doModal();
    }

    public static class HelpBtn
    extends JButton {
        private static final long serialVersionUID = 5199882236744880672L;
        private guiDialog d_dlg;

        public HelpBtn(guiDialog dlg) {
            super(Intl.intl("Help"));
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.fireButtonPressed(32);
                }
            });
        }
    }

    public static class CloseBtn
    extends JButton {
        private static final long serialVersionUID = 7466172221605359340L;
        private guiDialog d_dlg;

        public CloseBtn(guiDialog dlg) {
            super(Intl.intl("Close"));
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.d_status = 16;
                    d_dlg.fireButtonPressed(16);
                    d_dlg.setVisible(false);
                }
            });
        }
    }

    public static class CancelBtn
    extends JButton {
        private static final long serialVersionUID = 5844836095025038200L;
        private guiDialog d_dlg;

        public CancelBtn(guiDialog dlg) {
            super(Intl.intl("Cancel"));
            this.d_dlg = dlg;
            this.addActionListener(this.d_dlg.d_cancelListener);
        }
    }

    public static class ResetBtn
    extends JButton {
        private static final long serialVersionUID = 6299199455642133480L;
        private guiDialog d_dlg;

        public ResetBtn(guiDialog dlg) {
            super("Reset");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.fireButtonPressed(4);
                }
            });
        }
    }

    public static class ApplyBtn
    extends JButton {
        private static final long serialVersionUID = -6968857708775987036L;
        private guiDialog d_dlg;

        public ApplyBtn(guiDialog dlg) {
            super(Intl.intl("Apply"));
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (d_dlg.validateData(true, true)) {
                        d_dlg.d_status = 2;
                        d_dlg.fireButtonPressed(2);
                    }
                }
            });
        }
    }

    public static class OkBtn
    extends JButton {
        private static final long serialVersionUID = 6613577892314070488L;
        private guiDialog d_dlg;

        public OkBtn(guiDialog dlg) {
            super(Intl.intl("OK"));
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (d_dlg.validateData(true, true)) {
                        d_dlg.d_status = 1;
                        d_dlg.fireButtonPressed(1);
                        d_dlg.setVisible(false);
                    }
                }
            });
        }
    }

    private class CancelListener
    extends WindowAdapter
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel(true);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.cancel(false);
        }

        private void cancel(boolean hide) {
            guiDialog.this.d_status = 8;
            guiDialog.this.fireButtonPressed(8);
            if (hide) {
                guiDialog.this.setVisible(false);
            }
        }
    }
}

