/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedEvent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorScheme;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class ColorMgr {
    private Hashtable d_schemes = new Hashtable();
    private ColorScheme d_currScheme;
    private Set<ColorChangedListener> d_listeners = new IdentityHashSet<ColorChangedListener>();
    private String d_prefix = "Colors";
    private static final String DEFAULT_PREFIX = "Colors";
    private static final String CURR_SCHEME_KEY = "DefaultScheme";

    private void putScheme(ColorScheme scheme) {
        this.d_schemes.put(scheme.getName(), scheme);
    }

    public void addScheme(ColorScheme scheme) {
        this.putScheme(scheme);
    }

    public void removeScheme(String schemeName) {
        this.d_schemes.remove(schemeName);
        this.fireColorChangedEvent();
    }

    public void setCurrentColorScheme(String schemeName) {
        ColorScheme scheme = (ColorScheme)this.d_schemes.get(schemeName);
        if (scheme != null) {
            this.d_currScheme = scheme;
            this.fireColorChangedEvent();
        }
    }

    public void setCurrentColorScheme(ColorScheme scheme) {
        if (scheme != null) {
            this.putScheme(scheme);
            this.d_currScheme = scheme;
            this.fireColorChangedEvent();
        }
    }

    public ColorScheme getCurrentColorScheme() {
        return this.d_currScheme;
    }

    public String[] getAvailableSchemes() {
        String[] schemes = new String[this.d_schemes.size()];
        Enumeration e = this.d_schemes.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            schemes[i++] = (String)e.nextElement();
        }
        return schemes;
    }

    public Color getColor(String colorName) {
        ColorScheme cs = this.getCurrentColorScheme();
        if (cs == null) {
            return null;
        }
        return cs.getColor(colorName);
    }

    public void setColor(String colorName, Color value) {
        ColorScheme cs = this.getCurrentColorScheme();
        if (cs != null) {
            cs.setColor(colorName, value);
            this.fireColorChangedEvent();
        }
    }

    public void setPrefix(String prefix) {
        this.d_prefix = prefix;
    }

    public void addColorChangedListener(ColorChangedListener ccl) {
        this.d_listeners.add(ccl);
    }

    public void removeColorChangedListener(ColorChangedListener ccl) {
        this.d_listeners.remove(ccl);
    }

    public Collection<ColorChangedListener> getListeners() {
        return Collections.unmodifiableCollection(this.d_listeners);
    }

    protected void fireColorChangedEvent() {
        this.fireColorChangedEvent(new ColorChangedEvent());
    }

    protected void fireColorChangedEvent(ColorChangedEvent event) {
        for (ColorChangedListener ccl : this.d_listeners) {
            ccl.colorChanged(event);
        }
    }

    public void load(Properties props) {
        ColorScheme cs;
        Enumeration<Object> keys = props.keys();
        String fullPrefix = this.d_prefix + ".";
        IdentityHashSet d_alreadyLoaded = new IdentityHashSet();
        while (keys.hasMoreElements()) {
            String schemeName;
            ColorScheme existingScheme;
            int firstSepPos;
            int nextSepPos;
            String key = (String)keys.nextElement();
            if (!key.startsWith(fullPrefix) || (nextSepPos = key.indexOf(".", (firstSepPos = fullPrefix.length()) + 1)) < 0 || d_alreadyLoaded.contains(existingScheme = (ColorScheme)this.d_schemes.get(schemeName = key.substring(firstSepPos, nextSepPos)))) continue;
            ColorScheme targetScheme = existingScheme == null ? new ColorScheme(schemeName) : existingScheme;
            targetScheme.load(props, fullPrefix + schemeName + ".");
            if (targetScheme.getColorNames().length <= 0) continue;
            this.putScheme(targetScheme);
            d_alreadyLoaded.add(targetScheme);
            System.out.println("Added scheme: " + targetScheme.toString());
        }
        String currScheme = props.getProperty(this.d_prefix + ".DefaultScheme");
        if (currScheme != null && (cs = (ColorScheme)this.d_schemes.get(currScheme)) != null) {
            this.d_currScheme = cs;
            this.fireColorChangedEvent();
        }
    }

    public void store(Properties props) {
        Iterator schemes = this.d_schemes.values().iterator();
        while (schemes.hasNext()) {
            ((ColorScheme)schemes.next()).store(props, this.d_prefix + ".");
        }
        if (this.d_currScheme != null) {
            props.setProperty(this.d_prefix + ".DefaultScheme", this.d_currScheme.getName());
        }
    }
}

