/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Utils;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiFileChooser;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableEditor;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableUtil;
import pyrosim.legacy_2012_1.thunderheadeng.util.IWarning;
import pyrosim.legacy_2012_1.thunderheadeng.util.WarningReport;
import thunderheadeng.gui.Application;

public class WarningDlg<T extends IWarning>
extends guiDialog {
    private static final long serialVersionUID = 4781445495340909253L;
    private WarningReport<T> d_report;
    private T[] d_warnings;
    private guiTableEditor d_editor;
    private guiTable d_table;
    private JButton d_saveReportToFileButton;
    private JButton d_copyReportToClipBoardButton;

    public static <T extends IWarning> WarningDlg create(Component parent, String title, String message, WarningReport<T> report) {
        if ((parent = Utils.findParentWindow(parent)) instanceof JDialog) {
            return new WarningDlg<T>((JDialog)parent, title, message, report);
        }
        if (parent instanceof JFrame) {
            return new WarningDlg<T>((JFrame)parent, title, message, report);
        }
        return new WarningDlg<T>(Application.getApp().getActiveFrame(), title, message, report);
    }

    public WarningDlg(JDialog owner, String title, String message, WarningReport<T> report) {
        super((Window)owner, title, 1);
        this.init(message, report);
    }

    public WarningDlg(JFrame owner, String title, String message, WarningReport<T> report) {
        super((Window)owner, title, 1);
        this.init(message, report);
    }

    private void init(String message, WarningReport<T> report) {
        this.d_report = report;
        this.d_warnings = (IWarning[])Array.newInstance(this.d_report.getType(), this.d_report.getWarnings().size());
        this.d_report.getWarnings().toArray(this.d_warnings);
        Object[] columnTypes = new Class[this.d_report.getInfoTypes().length];
        Arrays.fill(columnTypes, String.class);
        this.d_table = guiTableUtil.fixedColumnTable(this.d_report.getInfoDescriptions(), (Class[])columnTypes, 7);
        this.d_table.setSortOrder(0);
        this.d_editor = new guiTableEditor(this.d_table, 0);
        this.d_table.setCellSelectionEnabled(false);
        this.d_table.setRowSelectionAllowed(true);
        CellRenderer cellRend = new CellRenderer();
        CellEditor cellEd = new CellEditor();
        for (int m = 0; m < this.d_report.getInfoTypes().length; ++m) {
            this.d_table.getColumnModel().getColumn(m).setCellRenderer(cellRend);
            this.d_table.getColumnModel().getColumn(m).setCellEditor(cellEd);
        }
        this.d_table.addMouseListener(new MouseMessageListener());
        JScrollPane tablesp = new JScrollPane(this.d_editor);
        this.d_saveReportToFileButton = new JButton(Intl.intl("Save to File"));
        this.d_saveReportToFileButton.addActionListener(new SaveToFileAction());
        this.d_copyReportToClipBoardButton = new JButton(Intl.intl("Copy to Clipboard"));
        this.d_copyReportToClipBoardButton.addActionListener(new CopyToClipboardAction());
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        Icon warningIcon = UIManager.getIcon("OptionPane.warningIcon");
        JLabel iconComp = new JLabel(warningIcon);
        MultiLineLabel messageLab = new MultiLineLabel(message);
        int row = 0;
        GridBagUtil.add(mainPanel, iconComp, 0, row, 1, 1, 0, 0, 12, 6, 2, 0.0, 0.0, 10);
        GridBagUtil.add(mainPanel, messageLab, 1, row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 10);
        GridBagUtil.add(mainPanel, tablesp, 0, ++row, 2, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 10);
        guiPanel savePanel = new guiPanel(new FlowLayout(1, 6, 0));
        savePanel.add(this.d_saveReportToFileButton);
        savePanel.add(this.d_copyReportToClipBoardButton);
        GridBagUtil.add(mainPanel, savePanel, 0, ++row, 2, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 10);
        this.loadValues();
        this.d_table.autoSizeColumns(true);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.setPreferredSize(new Dimension(500, 300));
    }

    private String getMessageForWarning(T warning) {
        Object message = "";
        int[] infoTypes = this.d_report.getInfoTypes();
        String[] infoDescs = this.d_report.getInfoDescriptions();
        for (int m = 0; m < infoTypes.length; ++m) {
            Comparable info = warning.getWarningInfo(infoTypes[m]);
            message = (String)message + infoDescs[m] + ":  " + info.toString() + "\n";
        }
        return message;
    }

    private void loadValues() {
        int[] infoTypes = this.d_report.getInfoTypes();
        for (int row = 0; row < this.d_warnings.length; ++row) {
            for (int col = 0; col < infoTypes.length; ++col) {
                this.d_table.setValueAt(this.getObjectAt(row, col), row, col);
            }
        }
    }

    public Comparable getObjectAt(int row, int col) {
        T warning = this.d_warnings[row];
        return warning.getWarningInfo(this.d_report.getInfoTypes()[col]);
    }

    private void prepareForReport() {
        int sortOrdReport;
        int sortCol = this.d_table.getSortColumn();
        int sortType = this.d_report.getInfoTypes()[sortCol];
        int sortOrd = this.d_table.getSortOrder();
        switch (sortOrd) {
            case 0: {
                sortOrdReport = 0;
                break;
            }
            case 1: {
                sortOrdReport = 1;
                break;
            }
            case 2: {
                sortOrdReport = 2;
                break;
            }
            default: {
                assert (false);
                sortOrdReport = 0;
            }
        }
        this.d_report.sortWarnings(sortType, sortOrdReport);
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = -7897925698417705455L;

        private CopyToClipboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WarningDlg.this.prepareForReport();
            String report = WarningDlg.this.d_report.prepareReport();
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new StringSelection(report), null);
        }
    }

    private class SaveToFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 4656191590391288940L;

        private SaveToFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            guiFileChooser chooser = new guiFileChooser("txt", "Text Files");
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.setSelectedFile(new File("warning_log.txt"));
            int result = chooser.showSaveDialog(WarningDlg.this);
            if (result == 0) {
                WarningDlg.this.prepareForReport();
                File f = chooser.getSelectedFile();
                try {
                    WarningDlg.this.d_report.writeReport(f.getAbsolutePath());
                }
                catch (IOException e1) {
                    WarningDlg.this.showMessageBox(e1.getMessage());
                }
            }
        }
    }

    private class CellEditor
    implements TableCellEditor {
        private CellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -661138943373637331L;

        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, "<html>" + value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent && value != null) {
                ((JComponent)c).setToolTipText(value.toString());
            }
            return c;
        }
    }

    private class MouseMessageListener
    extends MouseAdapter {
        private MouseMessageListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                int row = WarningDlg.this.d_table.rowAtPoint(e.getPoint());
                int col = WarningDlg.this.d_table.columnAtPoint(e.getPoint());
                if (row < 0 || col < 0 || row >= WarningDlg.this.d_report.getWarnings().size() || col >= WarningDlg.this.d_report.getInfoTypes().length) {
                    return;
                }
                Object warning = WarningDlg.this.d_warnings[row];
                String message = WarningDlg.this.getMessageForWarning(warning);
                JOptionPane.showMessageDialog(WarningDlg.this, message, "Warning", 2);
            }
        }
    }
}

