/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DecoratedIcon
extends ImageIcon {
    private static final long serialVersionUID = -444837483761523564L;
    public static final int UL = 0;
    public static final int UR = 1;
    public static final int BL = 2;
    public static final int BR = 3;
    public static final int NUM_POS = 4;
    private static final int[][] s_posMults = new int[][]{{0, 0, 0, 0}, {1, -1, 0, 0}, {0, 0, 1, -1}, {1, -1, 1, -1}};
    private Icon d_baseIcon;
    private final Icon[] d_decoratorIcons = new Icon[4];

    public DecoratedIcon(Icon decoratorIcon, int position) {
        this(null, decoratorIcon, position);
    }

    public DecoratedIcon(Icon baseIcon, Icon decoratorIcon, int position) {
        this.d_baseIcon = baseIcon;
        this.d_decoratorIcons[position] = decoratorIcon;
        this.updateImage();
    }

    public DecoratedIcon setBaseIcon(Icon icon) {
        this.d_baseIcon = icon;
        this.updateImage();
        return this;
    }

    @Override
    public int getIconWidth() {
        return this.d_baseIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.d_baseIcon.getIconHeight();
    }

    public Icon getBase() {
        return this.d_baseIcon;
    }

    public Icon getDecorator(int position) {
        return this.d_decoratorIcons[position];
    }

    private void updateImage() {
        BufferedImage bi = new BufferedImage(this.d_baseIcon.getIconWidth(), this.d_baseIcon.getIconHeight(), 2);
        Graphics2D g = bi.createGraphics();
        int x = 0;
        int y = 0;
        this.d_baseIcon.paintIcon(null, g, x, y);
        for (int m = 0; m < this.d_decoratorIcons.length; ++m) {
            Icon decIcon = this.d_decoratorIcons[m];
            if (decIcon == null) continue;
            int[] iconMults = s_posMults[m];
            int ix = x + this.d_baseIcon.getIconWidth() * iconMults[0] + decIcon.getIconWidth() * iconMults[1];
            int iy = y + this.d_baseIcon.getIconHeight() * iconMults[2] + decIcon.getIconHeight() * iconMults[3];
            decIcon.paintIcon(null, g, ix, iy);
        }
        g.dispose();
        this.setImage(bi);
    }
}

