/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.Random;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.GeomTests;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Inter2D {
    public static double ISECT_TOL = 1.0E-7;

    public static double[] isectLinesegLineseg(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b, double tol) {
        double[] isect = Inter2D.isectLineLine(l1a, Util2D.vector(l1a, l1b), l2a, Util2D.vector(l2a, l2b), 1.0E-12);
        if (isect == null) {
            return null;
        }
        if (!Util.clampTIfValid(isect, 0.0, 1.0, tol)) {
            return null;
        }
        return isect;
    }

    public static boolean copLineSegLineSegCrossExact(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b) {
        return Inter2D.copLineSegLineSegCrossExact(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y, l2b.x, l2b.y);
    }

    public static boolean copLineSegLineSegCrossExact(double l1ax, double l1ay, double l1bx, double l1by, double l2ax, double l2ay, double l2bx, double l2by) {
        double side1a = GeomTests.orient2d(l2ax, l2ay, l2bx, l2by, l1ax, l1ay);
        double side1b = GeomTests.orient2d(l2ax, l2ay, l2bx, l2by, l1bx, l1by);
        if (side1a < 0.0 && side1b < 0.0 || side1a > 0.0 && side1b > 0.0 || side1a == 0.0 && side1b == 0.0) {
            return false;
        }
        double side2a = GeomTests.orient2d(l1ax, l1ay, l1bx, l1by, l2ax, l2ay);
        double side2b = GeomTests.orient2d(l1ax, l1ay, l1bx, l1by, l2bx, l2by);
        assert (side2a != 0.0 || side2b != 0.0);
        return side2a >= 0.0 && side2b <= 0.0 || side2a <= 0.0 && side2b >= 0.0;
    }

    public static double[] isectLineLine(Point2d p1, Vector2d v1, Point2d p3, Vector2d v2, double tol) {
        double denom = v2.y * v1.x - v2.x * v1.y;
        if (theUtil.eq0(denom, tol)) {
            return null;
        }
        double idenom = 1.0 / denom;
        double ydiff = p1.y - p3.y;
        double xdiff = p1.x - p3.x;
        double t1 = (v2.x * ydiff - v2.y * xdiff) * idenom;
        double t2 = (v1.x * ydiff - v1.y * xdiff) * idenom;
        return new double[]{t1, t2};
    }

    public static double[] isectLineSegLineSeg(Point2d p1, Point2d p2, Point2d p3, Point2d p4, double tol) {
        double[] isects = Inter2D.isectLineLine(p1, Util2D.vector(p1, p2), p3, Util2D.vector(p3, p4), tol);
        if (isects == null) {
            return null;
        }
        if (!Util.clampTIfValid(isects, 0.0, 1.0, tol)) {
            return null;
        }
        return isects;
    }

    public static Point2d[] extendSeg(Point2d p1, Point2d p2, Point2d l1, Vector2d ldir, double tol) {
        Vector2d dir = Util2D.vector(p1, p2);
        double[] isect = Inter2D.isectLineLine(p1, dir, l1, ldir, tol);
        if (isect != null) {
            if (isect[0] < 0.0) {
                return new Point2d[]{Util2D.linePoint(p1, dir, isect[0]), p2};
            }
            if (isect[0] > 1.0) {
                return new Point2d[]{p1, Util2D.linePoint(p1, dir, isect[0])};
            }
        }
        return new Point2d[]{p1, p2};
    }

    public static double[][] lineSeglineSegOverlap(Point2d p1a, Point2d p2a, Point2d p1b, Point2d p2b, double tol) {
        double t2a;
        Vector2d dirb;
        Vector2d dira = Util2D.vector(p1a, p2a);
        if (!Util2D.areLinesAligned(p1a, dira, p1b, dirb = Util2D.vector(p1b, p2b), tol)) {
            return null;
        }
        double t1a = Util2D.tOnLine(p1a, dira, p1b);
        if (t1a > (t2a = Util2D.tOnLine(p1a, dira, p2b))) {
            double temp = t1a;
            t1a = t2a;
            t2a = temp;
        }
        if (theUtil.gt(t1a, 1.0, tol) || theUtil.lt0(t2a, -tol)) {
            return null;
        }
        t1a = Util.clampT(t1a, 0.0, 1.0);
        t2a = Util.clampT(t2a, 0.0, 1.0);
        double t1b = Util2D.tOnLine(p1b, dirb, Util2D.linePoint(p1a, dira, t1a));
        double t2b = Util2D.tOnLine(p1b, dirb, Util2D.linePoint(p1a, dira, t2a));
        t1b = Util.clampT(t1b, 0.0, 1.0);
        t2b = Util.clampT(t2b, 0.0, 1.0);
        return new double[][]{{t1a, t2a}, {t1b, t2b}};
    }

    public static Point2d nearestToLineSeg(Point2d tp, Point2d p1, Point2d p2) {
        return Util2D.linePoint(p1, p2, Inter2D.nearestTOnLineSeg(tp, p1, p2));
    }

    public static Point2d nearestPtOnLine(Point2d p1, Vector2d vec, Point2d tp) {
        return Util2D.linePoint(p1, vec, Inter2D.nearestTOnLine(p1, vec, tp));
    }

    public static double nearestTOnLine(Point2d p1, Vector2d vec, Point2d tp) {
        return Inter2D.nearestTOnLine(p1.x, p1.y, vec.x, vec.y, tp.x, tp.y);
    }

    public static double distSqToNearestPtOnLineSeg(double l1x, double l1y, double l2x, double l2y, double px, double py) {
        double v1x = l2x - l1x;
        double v1y = l2y - l1y;
        double lensq = v1x * v1x + v1y * v1y;
        double v2x = px - l1x;
        double v2y = py - l1y;
        if (lensq == 0.0) {
            return v2x * v2x + v2y * v2y;
        }
        double dot = v1x * v2x + v1y * v2y;
        if (dot <= 0.0) {
            return v2x * v2x + v2y * v2y;
        }
        if (dot >= lensq) {
            v2x = px - l2x;
            v2y = py - l2y;
            return v2x * v2x + v2y * v2y;
        }
        return Math.max(0.0, v2x * v2x + v2y * v2y - dot * dot / lensq);
    }

    public static double distSqToNearestPtOnLine(double l1x, double l1y, double vx, double vy, double px, double py) {
        double lensq = vx * vx + vy * vy;
        double dx = px - l1x;
        double dy = py - l1y;
        double dot = vx * dx + vy * dy;
        return dx * dx + dy * dy - dot * dot / lensq;
    }

    public static double distSqToNearestPtOnLine2(double l1x, double l1y, double l2x, double l2y, double px, double py) {
        return Inter2D.distSqToNearestPtOnLine(l1x, l1y, l2x - l1x, l2y - l1y, px, py);
    }

    public static double nearestTOnLine(double p1x, double p1y, double vecx, double vecy, double tpx, double tpy) {
        double lensq = vecx * vecx + vecy * vecy;
        if (lensq == 0.0) {
            return Double.NaN;
        }
        double dx = tpx - p1x;
        double dy = tpy - p1y;
        return (vecx * dx + vecy * dy) / lensq;
    }

    public static double nearestTOnLineSeg(Point2d tp, Point2d p1, Point2d p2) {
        double nearestT = Inter2D.nearestTOnLine(p1, Util2D.vector(p1, p2), tp);
        return Double.isNaN(nearestT) ? 0.0 : Util.clampT(nearestT, 0.0, 1.0);
    }

    public static double pointOnLine(Point2d l1, Vector2d vec, Point2d p, double tolSq) {
        if (!Util2D.areLinesParallel(vec, Util2D.vector(l1, p), tolSq)) {
            return Double.NaN;
        }
        return Inter2D.nearestTOnLine(l1, vec, p);
    }

    public static double pointOnLineSeg(Point2d l1, Point2d l2, Point2d p, double tolSq) {
        double t = Inter2D.pointOnLine(l1, Util2D.vector(l1, l2), p, tolSq);
        if (Double.isNaN(t)) {
            return t;
        }
        double[] ts = new double[]{t};
        return Util.clampTIfValid(ts, 0.0, 1.0, tolSq) ? ts[0] : Double.NaN;
    }

    public static boolean aabbAABBIntersect(double minx1, double miny1, double maxx1, double maxy1, double minx2, double miny2, double maxx2, double maxy2, double tol) {
        return minx2 - tol <= maxx1 + tol && maxx2 + tol >= minx1 - tol && miny2 - tol <= maxy1 + tol && maxy2 + tol >= miny1 - tol;
    }

    public static boolean aabbAABBIntersect(double minx1, double miny1, double maxx1, double maxy1, double minx2, double miny2, double maxx2, double maxy2) {
        return minx2 <= maxx1 && maxx2 >= minx1 && miny2 <= maxy1 && maxy2 >= miny1;
    }

    public static double[] lineCircleIsect(double lpx, double lpy, double ldx, double ldy, double cx, double cy, double r, double tol) {
        double[] dArray;
        double t2;
        double c;
        double delta;
        double b = 2.0 * (ldx * (lpx -= cx) + ldy * (lpy -= cy));
        double a = ldx * ldx + ldy * ldy;
        if (theUtil.lt0(delta = b * b - 4.0 * a * (c = lpx * lpx + lpy * lpy - r * r), tol)) {
            return null;
        }
        if (theUtil.le0(delta, tol)) {
            double t = -b / (2.0 * a);
            return new double[]{t, t};
        }
        double i2a = 0.5 / a;
        double deltasqrt = Math.sqrt(delta);
        double t1 = (-b + deltasqrt) * i2a;
        if (t1 <= (t2 = (-b - deltasqrt) * i2a)) {
            double[] dArray2 = new double[2];
            dArray2[0] = t1;
            dArray = dArray2;
            dArray2[1] = t2;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = t2;
            dArray = dArray3;
            dArray3[1] = t1;
        }
        return dArray;
    }

    public static boolean pointInSimplePoly(double tol, Point2d tp, Point2d ... points) {
        Random rand = new Random(0L);
        boolean[] result = new boolean[2];
        for (int m = 0; m < 15; ++m) {
            Vector2d v = Util2D.newRandomVec2D(rand);
            if (!Inter2D.testPointInSimplePoly(points, tp, v, tol, result)) continue;
            return result[0] || result[1];
        }
        System.err.println("Could not complete Inter2D.pointInSimplePoly using test point = " + tp.toString());
        return false;
    }

    private static boolean testPointInSimplePoly(Point2d[] points, Point2d tp, Vector2d dir, double tol, boolean[] result) {
        assert (result.length >= 2);
        int numIsects = 0;
        for (int m = 0; m < points.length; ++m) {
            Point2d e1 = points[m];
            Point2d e2 = points[(m + 1) % points.length];
            Vector2d edir = Util2D.vector(e1, e2);
            double[] isect = Inter2D.isectLineLine(tp, dir, e1, edir, tol);
            if (isect == null || !Util.checkRange(0.0, 1.0, isect[1], tol)) continue;
            double tr = isect[0];
            double tcurve = isect[1];
            if (theUtil.eq0(tr, tol)) {
                result[0] = true;
                result[1] = false;
                return true;
            }
            if (tr < 0.0) continue;
            if (theUtil.eq0(tcurve, tol) || theUtil.eq(tcurve, 1.0, tol)) {
                return false;
            }
            ++numIsects;
        }
        result[0] = false;
        result[1] = numIsects % 2 != 0;
        return true;
    }

    public static boolean pointInConvexPoly(double tol, Point2d pt, Point2d ... polyPoints) {
        assert (polyPoints.length >= 3);
        Vector2d vp = new Vector2d();
        Vector2d vt = new Vector2d();
        double lastCross = Double.NaN;
        int inCount = 0;
        double tolSq = tol * tol;
        for (int m = 0; m < polyPoints.length; ++m) {
            Point2d p1 = polyPoints[m];
            Point2d p2 = polyPoints[(m + 1) % polyPoints.length];
            vt.sub(p2, p1);
            if (theUtil.eq0(vt.lengthSquared(), tolSq)) continue;
            vp.sub(pt, p1);
            double currentCross = Util2D.cross(vt, vp);
            if (theUtil.eq0(currentCross, tol)) {
                double dot = vp.dot(vt);
                return Util.checkRange(0.0, vt.dot(vt), dot, tol);
            }
            if (Double.isNaN(lastCross)) {
                lastCross = currentCross;
                continue;
            }
            if (lastCross < 0.0 && currentCross > 0.0 || lastCross > 0.0 && currentCross < 0.0) {
                return false;
            }
            ++inCount;
        }
        return inCount > 0;
    }

    public static boolean pointInPoly(double tol, Point2d pt, boolean polyConvex, Point2d ... polyPoints) {
        return polyConvex && Inter2D.pointInConvexPoly(tol, pt, polyPoints) || !polyConvex && Inter2D.pointInSimplePoly(tol, pt, polyPoints);
    }
}

